/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.deployment;

import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.core.Application;
import org.wildfly.swarm.swagger.SwaggerMessages;
import org.wildfly.swarm.swagger.deployment.AddSwaggerResources;

@AddSwaggerResources
@Interceptor
@Priority(value=2200)
public class SwaggerRestApplicationInterceptor {
    @AroundInvoke
    public Object aroundInvoke(InvocationContext context) throws Exception {
        HashSet<Class> response = context.proceed();
        Method method = context.getMethod();
        if (Application.class.isAssignableFrom(method.getDeclaringClass())) {
            if ("getClasses".equals(method.getName())) {
                HashSet<Class> classes = new HashSet<Class>((Set)response);
                Method getSingletons = Application.class.getDeclaredMethod("getSingletons", new Class[0]);
                Set singletons = (Set)getSingletons.invoke(context.getTarget(), new Object[0]);
                if (!classes.isEmpty() || !singletons.isEmpty()) {
                    classes.add(ApiListingResource.class);
                    classes.add(SwaggerSerializers.class);
                    response = classes;
                    SwaggerMessages.MESSAGES.addingSwaggerResourcesToCustomApplicationSubClass();
                }
            }
        } else {
            SwaggerMessages.MESSAGES.warnInvalidBeanTarget(method.getDeclaringClass());
        }
        return response;
    }
}

