/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.runtime;

import io.swagger.annotations.Api;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.Configurables;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.swagger.SwaggerArchive;
import org.wildfly.swarm.swagger.SwaggerMessages;
import org.wildfly.swarm.undertow.WARArchive;

@DeploymentScoped
public class SwaggerArchivePreparer
implements DeploymentProcessor {
    @Configurable(value="thorntail.deployment.*.swagger.title")
    private String title;
    @Configurable(value="thorntail.deployment.*.swagger.description")
    private String description;
    @Configurable(value="thorntail.deployment.*.swagger.packages")
    private List<String> packages;
    @Configurable(value="thorntail.deployment.*.swagger.tos-url")
    private String tosUrl;
    @Configurable(value="thorntail.deployment.*.swagger.license")
    private String license;
    @Configurable(value="thorntail.deployment.*.swagger.license-url")
    private String licenseUrl;
    @Configurable(value="thorntail.deployment.*.swagger.version")
    private String version;
    @Configurable(value="thorntail.deployment.*.swagger.schemes")
    private List<String> schemes;
    @Configurable(value="thorntail.deployment.*.swagger.host")
    private String host;
    @Configurable(value="thorntail.deployment.*.swagger.root")
    private String root;
    @Configurables(value={@Configurable(value="thorntail.deployment.*.context.path"), @Configurable(value="thorntail.context.path")})
    Defaultable<String> contextPath = Defaultable.string((String)"/");
    private final Archive archive;
    @Inject
    private DeploymentContext deploymentContext;
    @Inject
    private IndexView indexView;

    @Inject
    public SwaggerArchivePreparer(Archive archive) {
        this.archive = archive;
    }

    public void process() {
        if (this.deploymentContext != null && this.deploymentContext.isImplicit()) {
            return;
        }
        String restApplicationPath = this.getRestApplicationPath();
        if (!restApplicationPath.isEmpty()) {
            String path = (String)this.contextPath.get() + restApplicationPath;
            path = path.replaceAll("//", "/");
            if (!Objects.equals(this.contextPath.get(), path)) {
                this.contextPath.set((Object)path);
            }
        }
        if (this.archive.getName().endsWith(".war")) {
            WARArchive deployment = (WARArchive)this.archive.as(WARArchive.class);
            deployment.addModule("io.swagger");
            SwaggerArchive swaggerArchive = (SwaggerArchive)deployment.as(SwaggerArchive.class);
            deployment.addModule("org.wildfly.swarm.swagger", "deployment");
            deployment.addAsServiceProvider(Extension.class.getName(), new String[]{"org.wildfly.swarm.swagger.deployment.SwaggerExtension"});
            if (this.title != null) {
                swaggerArchive.setTitle(this.title);
            }
            if (this.description != null) {
                swaggerArchive.setDescription(this.description);
            }
            if (this.packages != null && !this.packages.isEmpty()) {
                swaggerArchive.setResourcePackages(this.packages.toArray(new String[this.packages.size()]));
            }
            if (this.tosUrl != null) {
                swaggerArchive.setTermsOfServiceUrl(this.tosUrl);
            }
            if (this.license != null) {
                swaggerArchive.setLicense(this.license);
            }
            if (this.licenseUrl != null) {
                swaggerArchive.setLicenseUrl(this.licenseUrl);
            }
            if (this.version != null) {
                swaggerArchive.setVersion(this.version);
            }
            if (this.schemes != null && !this.schemes.isEmpty()) {
                swaggerArchive.setSchemes(this.schemes.toArray(new String[this.schemes.size()]));
            }
            if (this.host != null) {
                swaggerArchive.setHost(this.host);
            }
            if (this.root != null) {
                swaggerArchive.setContextRoot(this.root);
            } else if (!swaggerArchive.hasContextRoot()) {
                if (deployment.getContextRoot() != null) {
                    String path = deployment.getContextRoot();
                    if (!restApplicationPath.isEmpty()) {
                        path = deployment.getContextRoot() + "/" + restApplicationPath;
                        path = path.replaceAll("/+", "/");
                    }
                    swaggerArchive.setContextRoot(path);
                } else {
                    swaggerArchive.setContextRoot((String)this.contextPath.get());
                }
            }
            if (!swaggerArchive.hasResourcePackages()) {
                String[] packages = this.getPackagesForScanning(deployment).toArray(new String[0]);
                if (packages.length == 0) {
                    SwaggerMessages.MESSAGES.noEligiblePackages(this.archive.getName());
                } else {
                    if (packages.length == 1) {
                        SwaggerMessages.MESSAGES.configureSwaggerForPackage(this.archive.getName(), packages[0]);
                    } else {
                        SwaggerMessages.MESSAGES.configureSwaggerForSeveralPackages(this.archive.getName(), Arrays.asList(packages));
                    }
                    swaggerArchive.setResourcePackages(packages);
                }
            } else {
                SwaggerMessages.MESSAGES.configureSwaggerForSeveralPackages(this.archive.getName(), Arrays.asList(swaggerArchive.getResourcePackages()));
            }
            deployment.addClass(ApiListingResource.class);
            deployment.addClass(SwaggerSerializers.class);
        }
    }

    private Set<String> getPackagesForScanning(WARArchive deployment) {
        TreeSet<String> packages = new TreeSet<String>();
        if (this.indexView != null) {
            DotName dotName = DotName.createSimple((String)Api.class.getName());
            Collection instances = this.indexView.getAnnotations(dotName);
            instances.forEach(ai -> {
                AnnotationTarget target = ai.target();
                if (target.kind() == AnnotationTarget.Kind.CLASS) {
                    SwaggerArchivePreparer.extractAndAddPackageInfo(target.asClass(), packages, this.indexView);
                }
            });
            dotName = DotName.createSimple((String)Path.class.getName());
            instances = this.indexView.getAnnotations(dotName);
            instances.forEach(ai -> {
                AnnotationTarget target = ai.target();
                switch (target.kind()) {
                    case CLASS: {
                        SwaggerArchivePreparer.extractAndAddPackageInfo(target.asClass(), packages, this.indexView);
                        break;
                    }
                    case METHOD: {
                        SwaggerArchivePreparer.extractAndAddPackageInfo(target.asMethod().declaringClass(), packages, this.indexView);
                        break;
                    }
                }
            });
            HashSet<String> tmp = new HashSet<String>(packages);
            Iterator itr = packages.iterator();
            while (itr.hasNext()) {
                String current = (String)itr.next();
                boolean remove = false;
                if (current.startsWith("org.wildfly.swarm")) {
                    remove = true;
                } else {
                    for (String s : tmp) {
                        if (s.length() >= current.length() || !current.startsWith(s)) continue;
                        remove = true;
                        break;
                    }
                }
                if (!remove) continue;
                itr.remove();
            }
        } else {
            String packageName = null;
            for (Map.Entry entry : deployment.getContent().entrySet()) {
                ArchivePath key = (ArchivePath)entry.getKey();
                if (!key.get().endsWith(".class")) continue;
                String parentPath = key.getParent().get();
                parentPath = parentPath.replaceFirst("/", "");
                String parentPackage = parentPath.replaceFirst(".*/classes/", "");
                if ((parentPackage = parentPackage.replaceAll("/", ".")).startsWith("org.wildfly.swarm")) {
                    SwaggerMessages.MESSAGES.ignoringPackage(parentPackage);
                    continue;
                }
                packageName = parentPackage;
                break;
            }
            packages.add(packageName);
        }
        return packages;
    }

    private static void extractAndAddPackageInfo(ClassInfo classInfo, Set<String> packages, IndexView indexView) {
        StringBuilder builder;
        int idx;
        if (classInfo == null) {
            return;
        }
        String className = classInfo.name().toString();
        if (indexView != null) {
            DotName dotName = DotName.createSimple((String)className);
            if (Modifier.isInterface(classInfo.flags())) {
                indexView.getAllKnownImplementors(dotName).forEach(ci -> SwaggerArchivePreparer.extractAndAddPackageInfo(ci, packages, indexView));
            } else if (Modifier.isAbstract(classInfo.flags())) {
                indexView.getAllKnownSubclasses(dotName).forEach(ci -> SwaggerArchivePreparer.extractAndAddPackageInfo(ci, packages, indexView));
            }
        }
        if ((idx = (builder = new StringBuilder(className).reverse()).indexOf(".")) != -1) {
            builder.delete(0, idx + 1);
        }
        packages.add(builder.reverse().toString());
    }

    private String getRestApplicationPath() {
        String path = "";
        if (this.indexView != null) {
            DotName dotName = DotName.createSimple((String)ApplicationPath.class.getName());
            Collection instances = this.indexView.getAnnotations(dotName);
            HashSet<String> applicationPaths = new HashSet<String>();
            for (AnnotationInstance ai : instances) {
                Object value;
                AnnotationTarget target = ai.target();
                if (target.kind() != AnnotationTarget.Kind.CLASS || (value = ai.value().value()) == null) continue;
                applicationPaths.add(String.valueOf(value));
            }
            if (applicationPaths.size() > 1) {
                SwaggerMessages.MESSAGES.multipleApplicationPathsFound(applicationPaths);
            } else if (!applicationPaths.isEmpty()) {
                path = (String)applicationPaths.iterator().next();
            }
        }
        return path;
    }
}

