/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

@Mojo(name="multistart", aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class MultiStartMojo
extends AbstractSwarmMojo {
    private static final String THORNTAIL_MAVEN_PLUGIN = "io.thorntail:thorntail-maven-plugin";
    private static final String SWARM_PROCESS = "swarm-process";
    @Parameter(alias="processes")
    protected List<XmlPlexusConfiguration> processes;
    @Component
    protected BuildPluginManager pluginManager;

    @Override
    public void executeSpecific() throws MojoExecutionException, MojoFailureException {
        this.initProperties(true);
        this.initEnvironment();
        for (XmlPlexusConfiguration process : this.processes) {
            try {
                this.start(process);
            }
            catch (Exception e) {
                throw new MojoFailureException("Unable to start", (Throwable)e);
            }
        }
    }

    protected void start(XmlPlexusConfiguration process) throws PluginConfigurationException, MojoFailureException, MojoExecutionException, PluginManagerException, InvalidPluginDescriptorException, PluginResolutionException, PluginDescriptorParsingException, PluginNotFoundException {
        String groupId = process.getChild("groupId").getValue(this.project.getGroupId());
        String artifactId = process.getChild("artifactId").getValue(this.project.getArtifactId());
        String executionId = process.getChild("executionId").getValue();
        MavenProject project = this.findProject(groupId, artifactId);
        if (project != null) {
            this.startProject(project, executionId, process);
            return;
        }
        String classifier = process.getChild("classifier").getValue();
        Artifact artifact = this.findArtifact(groupId, artifactId, classifier);
        if (artifact == null) {
            artifact = this.findArtifact(groupId, artifactId, "thorntail");
        }
        if (artifact != null) {
            this.startArtifact(artifact, process);
            return;
        }
        throw new MojoFailureException("Unable to start process");
    }

    protected void startProject(MavenProject project, String executionId, XmlPlexusConfiguration process) throws InvalidPluginDescriptorException, PluginResolutionException, PluginDescriptorParsingException, PluginNotFoundException, PluginConfigurationException, MojoFailureException, MojoExecutionException, PluginManagerException {
        Plugin plugin = this.project.getPlugin(THORNTAIL_MAVEN_PLUGIN);
        Xpp3Dom config = this.getConfiguration(project, executionId);
        Xpp3Dom processConfig = this.getProcessConfiguration(process);
        Xpp3Dom globalConfig = this.getGlobalConfig();
        Xpp3Dom mergedConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)processConfig, (Xpp3Dom)config);
        mergedConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)globalConfig);
        PluginDescriptor pluginDescriptor = this.pluginManager.loadPlugin(plugin, project.getRemotePluginRepositories(), (RepositorySystemSession)this.repositorySystemSession);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo("start");
        MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, mergedConfig);
        this.mavenSession.setCurrentProject(project);
        this.pluginManager.executeMojo(this.mavenSession, mojoExecution);
        List launched = (List)this.mavenSession.getPluginContext(pluginDescriptor, project).get(SWARM_PROCESS);
        ArrayList procs = (ArrayList)this.getPluginContext().get(SWARM_PROCESS);
        if (procs == null) {
            procs = new ArrayList();
            this.getPluginContext().put(SWARM_PROCESS, procs);
        }
        procs.addAll(launched);
        this.mavenSession.setCurrentProject(this.project);
    }

    protected void startArtifact(Artifact artifact, XmlPlexusConfiguration process) throws InvalidPluginDescriptorException, PluginResolutionException, PluginDescriptorParsingException, PluginNotFoundException, PluginConfigurationException, MojoFailureException, MojoExecutionException, PluginManagerException {
        int startTimeoutSeconds;
        ArrayList<SwarmProcess> procs = (ArrayList<SwarmProcess>)this.getPluginContext().get(SWARM_PROCESS);
        if (procs == null) {
            procs = new ArrayList<SwarmProcess>();
            this.getPluginContext().put(SWARM_PROCESS, procs);
        }
        SwarmExecutor executor = new SwarmExecutor();
        executor.withExecutableJar(artifact.getFile().toPath());
        executor.withProperties(this.properties);
        executor.withEnvironment(this.environment);
        PlexusConfiguration props = process.getChild("properties");
        for (PlexusConfiguration each : props.getChildren()) {
            executor.withProperty(each.getName(), each.getValue());
        }
        PlexusConfiguration env = process.getChild("environment");
        for (PlexusConfiguration each : env.getChildren()) {
            executor.withEnvironment(each.getName(), each.getValue());
        }
        try {
            startTimeoutSeconds = Integer.valueOf(props.getChild("start.timeout.seconds").getValue("30"));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Wrong format of the start timeout for " + artifact + "!. Integer expected.", nfe);
        }
        try {
            SwarmProcess launched = executor.execute();
            launched.awaitReadiness((long)startTimeoutSeconds, TimeUnit.SECONDS);
            procs.add(launched);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoFailureException("Unable to execute: " + artifact, (Throwable)e);
        }
    }

    protected MavenProject findProject(String groupId, String artifactId) {
        if (groupId.equals(this.project.getGroupId()) && artifactId.equals(this.project.getArtifactId())) {
            return this.project;
        }
        return this.project.getCollectedProjects().stream().filter(e -> e.getGroupId().equals(groupId) && e.getArtifactId().equals(artifactId)).findFirst().orElse(null);
    }

    protected Artifact findArtifact(String groupId, String artifactId, String classifier) {
        return this.project.getArtifacts().stream().filter(e -> e.getGroupId().equals(groupId) && e.getArtifactId().equals(artifactId) && (e.getClassifier() == null && classifier == null || e.getClassifier() != null && e.getClassifier().equals(classifier))).findFirst().orElse(null);
    }

    protected Xpp3Dom getGlobalConfig() {
        Xpp3Dom config = new Xpp3Dom("configuration");
        Xpp3Dom properties = new Xpp3Dom("properties");
        config.addChild(properties);
        for (String name : this.properties.stringPropertyNames()) {
            Xpp3Dom prop = new Xpp3Dom(name);
            prop.setValue(this.properties.getProperty(name));
            properties.addChild(prop);
        }
        Xpp3Dom environment = new Xpp3Dom("environment");
        config.addChild(environment);
        for (String name : this.environment.stringPropertyNames()) {
            Xpp3Dom env = new Xpp3Dom(name);
            env.setValue(this.environment.getProperty(name));
            environment.addChild(env);
        }
        return config;
    }

    protected Xpp3Dom getConfiguration(MavenProject project, String executionId) {
        Plugin plugin = project.getPlugin(THORNTAIL_MAVEN_PLUGIN);
        PluginExecution execution = null;
        for (PluginExecution each : plugin.getExecutions()) {
            if (executionId != null) {
                if (!each.getId().equals(executionId)) continue;
                execution = each;
                break;
            }
            if (!each.getGoals().contains("start")) continue;
            execution = each;
            break;
        }
        Xpp3Dom config = execution == null ? new Xpp3Dom("configuration") : (Xpp3Dom)execution.getConfiguration();
        Xpp3Dom pdom = new Xpp3Dom("project");
        pdom.setValue("${project}");
        config.addChild(pdom);
        pdom = new Xpp3Dom("repositorySystemSession");
        pdom.setValue("${repositorySystemSession}");
        config.addChild(pdom);
        pdom = new Xpp3Dom("remoteRepositories");
        pdom.setValue("${project.remoteArtifactRepositories}");
        config.addChild(pdom);
        return config;
    }

    protected Xpp3Dom getProcessConfiguration(XmlPlexusConfiguration process) {
        Xpp3Dom config = new Xpp3Dom("configuration");
        config.addChild(this.convert(process.getChild("properties")));
        config.addChild(this.convert(process.getChild("environment")));
        config.addChild(this.convert(process.getChild("jvmArguments")));
        return config;
    }

    protected Xpp3Dom convert(PlexusConfiguration config) {
        Xpp3Dom dom = new Xpp3Dom(config.getName());
        dom.setValue(config.getValue());
        for (String string : config.getAttributeNames()) {
            dom.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            dom.addChild(this.convert((PlexusConfiguration)string));
        }
        return dom;
    }
}

