/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.swarm.fractions.FractionDescriptor;
import org.wildfly.swarm.fractions.FractionList;
import org.wildfly.swarm.fractions.FractionUsageAnalyzer;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartMojo
extends AbstractSwarmMojo {
    @Parameter(alias="stdoutFile", property="swarm.stdout")
    public File stdoutFile;
    @Parameter(alias="stderrFile", property="swarm.stderr")
    public File stderrFile;
    @Parameter(alias="useUberJar", defaultValue="${wildfly-swarm.useUberJar}")
    public boolean useUberJar;
    @Parameter(alias="debug", property="swarm.debug.port")
    public Integer debugPort;
    @Parameter(alias="jvmArguments", property="swarm.jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(alias="arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(property="swarm.arguments", defaultValue="")
    public String argumentsProp;
    boolean waitForProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeSpecific() throws MojoExecutionException, MojoFailureException {
        SwarmProcess process;
        SwarmExecutor executor;
        this.initProperties(true);
        this.initEnvironment();
        if (this.useUberJar) {
            executor = this.uberJarExecutor();
        } else if (this.project.getPackaging().equals("war")) {
            executor = this.warExecutor();
        } else if (this.project.getPackaging().equals("jar")) {
            executor = this.jarExecutor();
        } else {
            throw new MojoExecutionException("Unsupported packaging: " + this.project.getPackaging());
        }
        executor.withJVMArguments(this.jvmArguments);
        if (this.argumentsProp != null) {
            StringTokenizer args = new StringTokenizer(this.argumentsProp);
            while (args.hasMoreTokens()) {
                this.arguments.add(args.nextToken());
            }
        }
        executor.withArguments(this.arguments);
        try {
            int startTimeoutSeconds;
            File tmp;
            try {
                tmp = Files.createTempFile("swarm-process-file", null, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new MojoFailureException("Error while creating process file");
            }
            process = executor.withDebug(this.debugPort).withProcessFile(tmp).withProperties(this.properties).withStdoutFile(this.stdoutFile != null ? this.stdoutFile.toPath() : null).withStderrFile(this.stderrFile != null ? this.stderrFile.toPath() : null).withEnvironment(this.environment).withWorkingDirectory(this.project.getBasedir().toPath()).withProperty("remote.maven.repo", String.join((CharSequence)",", this.project.getRemoteProjectRepositories().stream().map(RemoteRepository::getUrl).collect(Collectors.toList()))).execute();
            try {
                startTimeoutSeconds = Integer.valueOf(this.properties.getProperty("start.timeout.seconds", "120"));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong format of the start timeout!. Integer expected.", nfe);
            }
            process.awaitReadiness((long)startTimeoutSeconds, TimeUnit.SECONDS);
            if (!process.isAlive()) {
                throw new MojoFailureException("Process failed to start");
            }
            if (process.getError() != null) {
                throw new MojoFailureException("Error starting process", (Throwable)process.getError());
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("unable to execute", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new MojoFailureException("Error waiting for deployment", (Throwable)e);
        }
        ArrayList<SwarmProcess> procs = (ArrayList<SwarmProcess>)this.getPluginContext().get("swarm-process");
        if (procs == null) {
            procs = new ArrayList<SwarmProcess>();
            this.getPluginContext().put("swarm-process", procs);
        }
        procs.add(process);
        if (this.waitForProcess) {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                try {
                    process.stop(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                process.destroyForcibly();
            }
        }
    }

    protected SwarmExecutor uberJarExecutor() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting uberjar");
        String finalName = this.project.getBuild().getFinalName();
        if (finalName.endsWith(".war") || finalName.endsWith(".jar")) {
            finalName = finalName.substring(0, finalName.length() - 4);
        }
        return new SwarmExecutor().withExecutableJar(Paths.get(this.projectBuildDir, finalName + "-" + "thorntail" + ".jar"));
    }

    protected SwarmExecutor warExecutor() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting .war");
        String finalName = this.project.getBuild().getFinalName();
        if (!finalName.endsWith(".war")) {
            finalName = finalName + ".war";
        }
        Path warPath = Paths.get(this.projectBuildDir, finalName);
        SwarmExecutor executor = this.executor(warPath, finalName, false);
        executor.withProperty("swarm.app.path", warPath.toString());
        return executor;
    }

    protected SwarmExecutor jarExecutor() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting .jar");
        String finalName = this.project.getBuild().getFinalName();
        return this.executor(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]), finalName.endsWith(".jar") ? finalName : finalName + ".jar", true);
    }

    protected SwarmExecutor executor(Path appPath, String name, boolean scanDependencies) throws MojoFailureException {
        SwarmExecutor executor = new SwarmExecutor().withModules(this.expandModules()).withProperty("swarm.app.name", name).withClassPathEntries(this.dependencies(appPath, scanDependencies));
        if (this.mainClass != null) {
            executor.withMainClass(this.mainClass);
        } else {
            executor.withDefaultMainClass();
        }
        return executor;
    }

    List<Path> findNeededFractions(Set<Artifact> existingDeps, Path source, boolean scanDeps) throws MojoFailureException {
        Set detectedFractions;
        this.getLog().info((CharSequence)("Scanning for needed Thorntail fractions with mode: " + this.fractionDetectMode));
        Set existingDepGASet = existingDeps.stream().map(d -> String.format("%s:%s", d.getGroupId(), d.getArtifactId())).collect(Collectors.toSet());
        FractionUsageAnalyzer analyzer = new FractionUsageAnalyzer(FractionList.get()).source(source);
        if (scanDeps) {
            existingDeps.forEach(d -> analyzer.source(d.getFile()));
        }
        Predicate<FractionDescriptor> notExistingDep = d -> !existingDepGASet.contains(String.format("%s:%s", d.getGroupId(), d.getArtifactId()));
        try {
            detectedFractions = analyzer.detectNeededFractions().stream().filter(notExistingDep).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new MojoFailureException("failed to scan for fractions", (Throwable)e);
        }
        this.getLog().info((CharSequence)("Detected fractions: " + String.join((CharSequence)", ", detectedFractions.stream().map(FractionDescriptor::av).sorted().collect(Collectors.toList()))));
        this.fractions.forEach(f -> {
            if (f.startsWith("!")) {
                FractionDescriptor descriptor = FractionDescriptor.fromGav((FractionList)FractionList.get(), (String)f.substring(1));
                this.getLog().info((CharSequence)("Excluding detected fraction:" + descriptor));
                detectedFractions.remove(descriptor);
            } else {
                detectedFractions.add(FractionDescriptor.fromGav((FractionList)FractionList.get(), (String)f));
            }
        });
        HashSet allFractions = new HashSet(detectedFractions);
        allFractions.addAll(detectedFractions.stream().flatMap(f -> f.getDependencies().stream()).filter(notExistingDep).collect(Collectors.toSet()));
        this.getLog().info((CharSequence)("Using fractions: " + String.join((CharSequence)", ", allFractions.stream().map(FractionDescriptor::gavOrAv).sorted().collect(Collectors.toList()))));
        HashSet specs = new HashSet();
        specs.addAll(existingDeps.stream().map(this::artifactToArtifactSpec).collect(Collectors.toList()));
        specs.addAll(allFractions.stream().map(ArtifactSpec::fromFractionDescriptor).collect(Collectors.toList()));
        try {
            return this.mavenArtifactResolvingHelper().resolveAll(specs).stream().map(s -> s.file.toPath()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new MojoFailureException("failed to resolve fraction dependencies", (Throwable)e);
        }
    }

    List<Path> dependencies(Path archiveContent, boolean scanDependencies) throws MojoFailureException {
        ArrayList<Path> elements = new ArrayList<Path>();
        Set artifacts = this.project.getArtifacts();
        boolean hasSwarmDeps = false;
        DeclaredDependencies declaredDependencies = new DeclaredDependencies();
        for (Artifact each : artifacts) {
            String parentDep = (String)each.getDependencyTrail().get(1);
            declaredDependencies.add((Object)DeclaredDependencies.createSpec((String)parentDep), (Object)DeclaredDependencies.createSpec((String)each.toString()));
            if (each.getGroupId().equals("io.thorntail") && each.getArtifactId().equals("bootstrap")) {
                hasSwarmDeps = true;
            }
            if (each.getGroupId().equals("org.jboss.logmanager") && each.getArtifactId().equals("jboss-logmanager") || each.getScope().equals("provided")) continue;
            elements.add(each.getFile().toPath());
        }
        if (declaredDependencies.getDirectDeps().size() > 0) {
            try {
                File tmp = this.projectBuildDir != null ? Files.createTempFile(Paths.get(this.projectBuildDir, new String[0]), "wfswarmswarm-", "-cp.txt", new FileAttribute[0]).toFile() : Files.createTempFile("wfswarmswarm-", "-cp.txt", new FileAttribute[0]).toFile();
                tmp.deleteOnExit();
                this.getPluginContext().put("swarm-cp-file", tmp);
                declaredDependencies.writeTo(tmp);
                this.getLog().debug((CharSequence)("dependency info stored at: " + tmp.getAbsolutePath()));
                this.properties.setProperty("swarm.cp.info", tmp.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        elements.add(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
        if (this.fractionDetectMode != BuildTool.FractionDetectionMode.never) {
            if (this.fractionDetectMode == BuildTool.FractionDetectionMode.force || !hasSwarmDeps) {
                List<Path> fractionDeps = this.findNeededFractions(artifacts, archiveContent, scanDependencies);
                for (Path p : fractionDeps) {
                    if (elements.contains(p)) continue;
                    elements.add(p);
                }
            }
        } else if (!hasSwarmDeps) {
            this.getLog().warn((CharSequence)"No Thorntail dependencies found and fraction detection disabled");
        }
        return elements;
    }

    List<Path> expandModules() {
        return this.additionalModules.stream().map(m -> Paths.get(this.project.getBuild().getOutputDirectory(), m)).collect(Collectors.toList());
    }
}

