/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.wildfly.swarm.fractions.PropertiesUtil;
import org.wildfly.swarm.plugin.maven.MavenArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;

public abstract class AbstractSwarmMojo
extends AbstractMojo {
    protected static final String EXCLUDE_PREFIX = "!";
    protected static final String JAR = "jar";
    protected static final String WAR = "war";
    protected static final String DOT = ".";
    protected static final String JAR_FILE_EXTENSION = ".jar";
    protected static final String WAR_FILE_EXTENSION = ".war";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(alias="remoteRepositories", defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Deprecated
    @Parameter(alias="mainClass", property="swarm.mainClass")
    protected String mainClass;
    @Parameter(alias="skipAll", defaultValue="false", property="thorntail.skipAll")
    protected boolean skipAll;
    @Parameter(alias="properties")
    protected Properties properties;
    @Parameter(alias="propertiesFile", property="thorntail.propertiesFile")
    protected String propertiesFile;
    @Parameter(alias="environment")
    protected Properties environment;
    @Parameter(alias="environmentFile", property="thorntail.environmentFile")
    protected String environmentFile;
    @Parameter(alias="modules")
    protected List<String> additionalModules = new ArrayList<String>();
    @Parameter(alias="fractions")
    protected List<String> fractions = new ArrayList<String>();
    @Parameter(defaultValue="when_missing", property="thorntail.detect.mode")
    protected BuildTool.FractionDetectionMode fractionDetectMode;
    @Inject
    protected ArtifactResolver resolver;
    @Component
    protected RepositorySystem repositorySystem;

    AbstractSwarmMojo() {
        if (this.additionalModules.isEmpty()) {
            this.additionalModules.add("modules");
        }
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.deprecationWarnings();
        if (this.skipAll) {
            this.getLog().info((CharSequence)"Skipping thorntail-maven-plugin execution");
            return;
        }
        this.executeSpecific();
    }

    public abstract void executeSpecific() throws MojoExecutionException, MojoFailureException;

    protected void deprecationWarnings() {
        if (this.mainClass != null && !this.mainClass.equals("")) {
            this.getLog().warn((CharSequence)"\n------\nCustom main() usage is deprecated and is no longer supported.\nPlease refer to https://docs.thorntail.io for YAML configuration that replaces it.\n------");
        }
    }

    protected void initProperties(boolean withMaven) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.propertiesFile != null) {
            try {
                this.properties.putAll((Map<?, ?>)PropertiesUtil.loadProperties((String)this.propertiesFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to load properties from " + this.propertiesFile), (Throwable)e);
            }
        }
        this.properties.putAll((Map<?, ?>)PropertiesUtil.filteredSystemProperties((Properties)this.properties, (boolean)withMaven));
    }

    protected void initEnvironment() throws MojoFailureException {
        if (this.environment == null) {
            this.environment = new Properties();
        }
        if (this.environmentFile != null) {
            try {
                this.environment.putAll((Map<?, ?>)PropertiesUtil.loadProperties((String)this.environmentFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to load environment from " + this.environmentFile), (Throwable)e);
            }
        }
    }

    protected MavenArtifactResolvingHelper mavenArtifactResolvingHelper() {
        MavenArtifactResolvingHelper resolvingHelper = new MavenArtifactResolvingHelper(this.resolver, this.repositorySystem, (RepositorySystemSession)this.repositorySystemSession, this.project.getDependencyManagement());
        this.remoteRepositories.forEach(resolvingHelper::remoteRepository);
        return resolvingHelper;
    }

    protected ArtifactSpec artifactToArtifactSpec(Artifact dep) {
        return new ArtifactSpec(dep.getScope(), dep.getGroupId(), dep.getArtifactId(), dep.getBaseVersion(), dep.getType(), dep.getClassifier(), dep.getFile());
    }

    protected Map<ArtifactSpec, Set<ArtifactSpec>> createBuckets(Set<Artifact> transientDeps, List<Dependency> directDeps) {
        HashMap<ArtifactSpec, Set<ArtifactSpec>> buckets = new HashMap<ArtifactSpec, Set<ArtifactSpec>>();
        for (Artifact dep : transientDeps) {
            if (dep.getDependencyTrail().isEmpty()) {
                throw new RuntimeException("Empty trail " + AbstractSwarmMojo.asBucketKey(dep));
            }
            if (dep.getDependencyTrail().size() == 2) {
                ArtifactSpec key = AbstractSwarmMojo.asBucketKey(dep);
                if (buckets.containsKey(key)) continue;
                buckets.put(key, new HashSet());
                continue;
            }
            String owner = (String)dep.getDependencyTrail().get(1);
            String ownerScope = null;
            String[] tokens = owner.split(":");
            for (Dependency d : directDeps) {
                if (!d.getGroupId().equals(tokens[0]) || !d.getArtifactId().equals(tokens[1])) continue;
                ownerScope = d.getScope();
                break;
            }
            assert (ownerScope != null) : "Failed to resolve owner scope";
            ArtifactSpec parent = DeclaredDependencies.createSpec((String)owner, ownerScope);
            if (!buckets.containsKey(parent)) {
                buckets.put(parent, new HashSet());
            }
            ((Set)buckets.get(parent)).add(AbstractSwarmMojo.asBucketKey(dep));
        }
        return buckets;
    }

    private static ArtifactSpec asBucketKey(Artifact artifact) {
        return new ArtifactSpec(artifact.getScope(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getFile());
    }
}

