/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.wildfly.swarm.runner.WarBuilder;
import org.wildfly.swarm.runner.cache.ArtifactResolutionCache;
import org.wildfly.swarm.runner.maven.CachingArtifactResolvingHelper;
import org.wildfly.swarm.runner.utils.StdoutLogger;
import org.wildfly.swarm.runner.utils.StringUtils;
import org.wildfly.swarm.spi.meta.SimpleLogger;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.xml.sax.SAXException;

public class FatJarBuilder {
    public static final String FAKE_GROUP_ID = "com.fakegroupid";
    private final List<URL> classPathUrls;
    private final File target;

    public FatJarBuilder(List<URL> classPathUrls, File target) {
        this.classPathUrls = classPathUrls;
        this.target = target;
    }

    public static void main(String[] args) throws Exception {
        File fatJar = new File(args[0]);
        long start = System.currentTimeMillis();
        FatJarBuilder.buildFatJarTo(fatJar);
        System.out.printf("Uber jar built in %d ms\n", System.currentTimeMillis() - start);
    }

    private static File buildFatJarTo(File target) throws Exception {
        List<URL> urls = FatJarBuilder.getClasspathUrls();
        FatJarBuilder b = new FatJarBuilder(urls, target);
        return b.doBuild();
    }

    private static List<URL> getClasspathUrls() throws MalformedURLException {
        String[] classpath;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String file : classpath = System.getProperty("java.class.path").split(File.pathSeparator)) {
            urls.add(new File(file).toURI().toURL());
        }
        return urls;
    }

    private File doBuild() throws Exception {
        String type = "war";
        long start = System.currentTimeMillis();
        List<ArtifactOrFile> classPathEntries = this.analyzeClasspath();
        System.out.println("Classpath analyzing time: " + (System.currentTimeMillis() - start) + " ms");
        File war = this.buildWar(classPathEntries);
        BuildTool tool = new BuildTool((ArtifactResolvingHelper)new CachingArtifactResolvingHelper(), true).projectArtifact("tt", "thorntail-user-app", "0.1-SNAPSHOT", "war", war, "users.war").properties(System.getProperties()).fractionDetectionMode(BuildTool.FractionDetectionMode.when_missing).hollow(false).logger((SimpleLogger)new StdoutLogger());
        String mainClass = System.getProperty("thorntail.runner.main-class");
        if (mainClass != null) {
            tool.mainClass(mainClass);
        }
        tool.declaredDependencies(this.declaredDependencies(classPathEntries));
        this.classPathUrls.parallelStream().filter(url -> !url.toString().matches(".*\\.[^/]*")).forEach(r -> tool.resourceDirectory(r.getFile()));
        File uberjarResourcesDir = File.createTempFile("thorntail-runner-uberjar-resources", "placeholder");
        uberjarResourcesDir.deleteOnExit();
        tool.uberjarResourcesDirectory(uberjarResourcesDir.toPath());
        String currentDir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        File fileModules = Paths.get(currentDir, "target", "classes", "modules").toFile();
        if (fileModules.exists()) {
            tool.additionalModule(fileModules.getAbsolutePath());
        }
        File jar = tool.build(this.target.getName(), this.target.getParentFile().toPath());
        tool.repackageWar(war);
        ArtifactResolutionCache.INSTANCE.store();
        return jar;
    }

    private File buildWar(List<ArtifactOrFile> classPathEntries) {
        try {
            List<String> classesUrls = classPathEntries.stream().map(ArtifactOrFile::file).filter(this::isDirectory).filter(url -> url.contains("classes")).collect(Collectors.toList());
            List<File> classpathJars = classPathEntries.stream().map(ArtifactOrFile::file).filter(file -> file.endsWith(".jar")).map(File::new).collect(Collectors.toList());
            return WarBuilder.build(classesUrls, classpathJars);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to build war", e);
        }
    }

    private boolean isDirectory(String filePath) {
        return Files.isDirectory(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    private List<ArtifactOrFile> analyzeClasspath() {
        return this.classPathUrls.parallelStream().filter(this::notJdkJar).map(this::urlToSpec).collect(Collectors.toList());
    }

    private boolean notJdkJar(URL url) {
        return !url.toString().contains(System.getProperty("java.home"));
    }

    private DeclaredDependencies declaredDependencies(List<ArtifactOrFile> specsOrUrls) {
        final List specs = specsOrUrls.stream().filter(ArtifactOrFile::isJar).filter(ArtifactOrFile::hasSpec).map(ArtifactOrFile::spec).collect(Collectors.toList());
        return new DeclaredDependencies(){

            public Collection<ArtifactSpec> getDirectDeps() {
                return specs;
            }

            public Collection<ArtifactSpec> getTransientDeps(ArtifactSpec parent) {
                return Collections.emptyList();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArtifactOrFile urlToSpec(URL url) {
        String file = this.resolveUrlToFile(url);
        if (!url.toString().endsWith(".jar")) {
            return ArtifactOrFile.file(file);
        }
        try (FileSystem fs = FileSystems.newFileSystem(Paths.get(file, new String[0]), this.getClass().getClassLoader());){
            Optional<Path> maybePomXml = this.findPom(fs);
            ArtifactSpec spec = maybePomXml.map(pom -> this.toArtifactSpec((Path)pom, file)).orElse(this.mockArtifactSpec(file));
            ArtifactOrFile artifactOrFile = ArtifactOrFile.spec(spec);
            return artifactOrFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse jar: " + file, e);
        }
    }

    private Optional<Path> findPom(FileSystem fs) throws IOException {
        Path path = fs.getPath("/META-INF/maven", new String[0]);
        Optional<Path> maybePomXml = path == null || !Files.exists(path, new LinkOption[0]) ? Optional.empty() : Files.walk(path, new FileVisitOption[0]).filter(p -> p.endsWith("pom.xml")).findAny();
        return maybePomXml;
    }

    private ArtifactSpec mockArtifactSpec(String jarPath) {
        return new ArtifactSpec("compile", FAKE_GROUP_ID, StringUtils.randomAlphabetic(10), "0.0.1", "jar", null, new File(jarPath));
    }

    private ArtifactSpec toArtifactSpec(Path pom, String jarPath) {
        try {
            String groupId = this.extract(pom, "/project/groupId", () -> this.extract(pom, "/project/parent/groupId"));
            String artifactId = this.extract(pom, "/project/artifactId");
            String version = this.extract(pom, "/project/version", () -> this.extract(pom, "/project/parent/version"));
            String packaging = this.extract(pom, "/project/packaging", "jar");
            String classifier = this.extract(pom, "/project/classifier", (String)null);
            return new ArtifactSpec("compile", groupId, artifactId, version, packaging, classifier, new File(jarPath));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read artifact spec from pom " + pom + " you may have an invalid jar downloaded.", e);
        }
    }

    private String extract(Path source, String expression, Supplier<String> defaultValueProvider) {
        String extracted = this.extract(source, expression);
        return extracted == null || "".equals(extracted) ? defaultValueProvider.get() : extracted;
    }

    private String extract(Path source, String expression, String defaultValue) {
        String extracted = this.extract(source, expression);
        return extracted == null || "".equals(extracted) ? defaultValue : extracted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extract(Path sourcePath, String expression) {
        try (InputStream source = Files.newInputStream(sourcePath, new OpenOption[0]);){
            Document doc = this.parseDocument(source);
            XPath xpath = this.createXpath();
            XPathExpression expr = xpath.compile(expression);
            String string = (String)expr.evaluate(doc, XPathConstants.STRING);
            return string;
        }
        catch (Exception any) {
            throw new RuntimeException("Failure when trying to find a match for " + expression + " in " + sourcePath.toAbsolutePath(), any);
        }
    }

    private XPath createXpath() {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        return xPathfactory.newXPath();
    }

    private Document parseDocument(InputStream source) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(source);
    }

    private String resolveUrlToFile(URL url) {
        try {
            String zipFile = Paths.get(url.toURI()).toFile().getAbsolutePath();
            if (zipFile == null) {
                try (InputStream stream = url.openStream();){
                    File tempFile = File.createTempFile("tt-dependency", ".jar");
                    tempFile.deleteOnExit();
                    zipFile = tempFile.getAbsolutePath();
                    Files.copy(stream, Paths.get(zipFile, new String[0]), new CopyOption[0]);
                }
            }
            return zipFile;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Unable to resolve: " + url);
        }
    }

    public static class ArtifactOrFile {
        private final String file;
        private final ArtifactSpec spec;

        private ArtifactOrFile(String file, ArtifactSpec spec) {
            this.file = file;
            this.spec = spec;
        }

        public String file() {
            return this.file;
        }

        public ArtifactSpec spec() {
            return this.spec;
        }

        public boolean isJar() {
            return this.spec != null;
        }

        public boolean hasSpec() {
            return !this.spec.groupId().equals(FatJarBuilder.FAKE_GROUP_ID);
        }

        private static ArtifactOrFile file(String file) {
            return new ArtifactOrFile(file, null);
        }

        private static ArtifactOrFile spec(ArtifactSpec spec) {
            return new ArtifactOrFile(spec.file.getAbsolutePath(), spec);
        }
    }
}

