/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.jdk.specific.ClassLoaders;
import org.wildfly.swarm.runner.FatJarBuilder;
import org.wildfly.swarm.runner.RunnerConstants;

public class Runner {
    private Runner() {
    }

    public static void main(String[] args) throws Exception {
        System.out.printf("Starting Thorntail Runner. Runner caches will be stored in %s\n", RunnerConstants.CACHE_STORAGE_DIR);
        URLClassLoader loader = Runner.createClassLoader();
        Runner.run(args, loader);
    }

    private static void run(Object args, URLClassLoader loader) throws Exception {
        Runner.callWithClassloader(loader, "org.wildfly.swarm.bootstrap.Main", "main", new Class[]{String[].class}, args);
    }

    private static <T> T callWithClassloader(ClassLoader loader, String className, String methodName, Class<?>[] argumentTypes, Object ... arguments) throws Exception {
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> aClass = loader.loadClass(className);
        Method method = aClass.getMethod(methodName, argumentTypes);
        return (T)method.invoke(null, arguments);
    }

    private static URLClassLoader createClassLoader() throws Exception {
        File fatJar = File.createTempFile("thorntail-user-app", ".jar");
        Runner.buildJar(fatJar);
        if (RunnerConstants.PRESERVE_JAR == null) {
            System.out.println("Built " + fatJar.getAbsolutePath() + ", the file will be deleted on shutdown. To keep it, use -Dthorntail.runner.preserve-jar");
            fatJar.deleteOnExit();
        }
        URL jarUrl = fatJar.toURI().toURL();
        return new URLClassLoader(new URL[]{jarUrl}, ClassLoaders.getPlatformClassLoader());
    }

    private static void buildJar(File fatJar) throws IOException, InterruptedException {
        String classpath = System.getProperty("java.class.path");
        List<String> command = Runner.buildCommand(fatJar);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.environment().put("CLASSPATH", classpath);
        Process fatJarBuilder = processBuilder.inheritIO().start();
        int exitCode = fatJarBuilder.waitFor();
        if (exitCode != 0) {
            throw new RuntimeException("Failed to generate the uber jar.");
        }
    }

    private static List<String> buildCommand(File fatJar) {
        ArrayList<String> command = new ArrayList<String>(Collections.singleton(Runner.javaCommand()));
        command.addAll(Runner.properties());
        command.addAll(Arrays.asList(FatJarBuilder.class.getCanonicalName(), fatJar.getAbsolutePath()));
        return command;
    }

    private static Collection<String> properties() {
        return System.getProperties().entrySet().stream().map(Runner::propertyToString).collect(Collectors.toList());
    }

    private static String propertyToString(Map.Entry<Object, Object> property) {
        return property.getValue() == null ? String.format("-D%s", property.getKey()) : String.format("-D%s=%s", property.getKey(), property.getValue());
    }

    private static String javaCommand() {
        Path javaBinPath = Paths.get(System.getProperty("java.home"), "bin");
        File javaExecutable = javaBinPath.resolve("java").toFile();
        if (!javaExecutable.exists()) {
            javaExecutable = javaBinPath.resolve("java.exe").toFile();
        }
        return javaExecutable.getAbsolutePath();
    }
}

