/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class RunnerConstants {
    public static final String CACHE_STORAGE_DIR;
    public static final String IGNORE_DEFAULT_REPOSITORIES;
    public static final String USER_REPOSITORIES;
    public static final String PRESERVE_JAR;

    private RunnerConstants() {
    }

    private static Properties loadFileProperties() {
        Properties fileProperties = new Properties();
        try (FileInputStream st = new FileInputStream("thorntail-runner.properties");){
            fileProperties.load(st);
        }
        catch (FileNotFoundException e) {
            System.out.println("No configuration (thorntail-runner.properties) found");
        }
        catch (IOException e) {
            System.out.println("Could not read configuration (thorntail-runner.properties), ignoring file");
        }
        return fileProperties;
    }

    private static String getProperty(Properties fileProperties, String key, String defaultValue) {
        String value = null;
        if (fileProperties.getProperty(key) != null) {
            value = fileProperties.getProperty(key);
        }
        if (System.getProperty(key) != null) {
            value = System.getProperty(key);
        }
        return value != null ? value : defaultValue;
    }

    static {
        Properties fileProperties = RunnerConstants.loadFileProperties();
        CACHE_STORAGE_DIR = RunnerConstants.getProperty(fileProperties, "thorntail.runner.cache-location", ".thorntail-runner-cache");
        IGNORE_DEFAULT_REPOSITORIES = RunnerConstants.getProperty(fileProperties, "thorntail.runner.ignore-default-repositories", null);
        USER_REPOSITORIES = RunnerConstants.getProperty(fileProperties, "thorntail.runner.repositories", null);
        PRESERVE_JAR = RunnerConstants.getProperty(fileProperties, "thorntail.runner.preserve-jar", null);
    }
}

