/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class WarBuilder {
    private final ZipOutputStream output;
    private final List<String> classesDirs;
    private final List<File> jars;

    public static File build(List<String> classesDirs, List<File> classpathJars) throws IOException {
        File war = File.createTempFile("thorntail-user-war", ".war");
        war.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(war);
             ZipOutputStream out = new ZipOutputStream(fos);){
            WarBuilder builder = new WarBuilder(out, classesDirs, classpathJars);
            builder.build();
        }
        System.out.println("built " + war.getAbsolutePath());
        return war;
    }

    private WarBuilder(ZipOutputStream output, List<String> classesDirs, List<File> jars) {
        this.output = output;
        this.classesDirs = classesDirs;
        this.jars = jars;
    }

    private void build() {
        List<String> warDirs = this.classesDirs.stream().filter(this::isWar).collect(Collectors.toList());
        this.classesDirs.stream().filter(d -> !this.isWar((String)d)).map(this::buildJar).forEach(this.jars::add);
        warDirs.forEach(this::addClassesToWar);
        this.addWebAppResourcesToWar();
        this.jars.forEach(this::addJarToWar);
    }

    private File buildJar(String classesDir) {
        try {
            File jar = File.createTempFile("thorntail-user-jar", ".jar");
            jar.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(jar);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                this.addClassesToZip(out, "", new File(classesDir));
            }
            return jar;
        }
        catch (Exception any) {
            throw new RuntimeException("Unable to build jar from directory: " + classesDir, any);
        }
    }

    private boolean isWar(String path) {
        String currentDir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        String classesDirPath = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        return classesDirPath.startsWith(currentDir);
    }

    private void addClassesToWar(String directory) {
        File classesDirectory = new File(directory);
        if (!classesDirectory.isDirectory()) {
            throw new RuntimeException("Invalid classes directory on classpath: " + directory);
        }
        this.addClassesToZip(this.output, "/WEB-INF/classes/", classesDirectory);
    }

    private void addWebAppResourcesToWar() {
        try {
            Path webappPath = this.getWebAppLocation();
            if (!webappPath.toFile().exists()) {
                return;
            }
            Files.walk(webappPath, new FileVisitOption[0]).forEach(this::addWebappResourceToWar);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get webapp dir");
        }
    }

    private Path getWebAppLocation() {
        Path webappPath;
        String webappLocationProperty = System.getProperty("thorntail.runner.webapp-location");
        if (webappLocationProperty != null) {
            webappPath = Paths.get(webappLocationProperty, new String[0]);
            if (!webappPath.toFile().exists()) {
                System.err.println("Invalid web app location directory provided: " + webappLocationProperty);
                System.exit(1);
            }
        } else {
            webappPath = Paths.get("src", "main", "webapp");
        }
        return webappPath;
    }

    private void addJarToWar(File file) {
        String jarName = file.getName();
        try {
            WarBuilder.writeFileToZip(this.output, file, "WEB-INF/lib/" + jarName);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to add jar " + file.getAbsolutePath() + " to war", e);
        }
    }

    private void addWebappResourceToWar(Path path) {
        File file = path.toFile();
        if (file.isFile()) {
            try {
                String projectDir = Paths.get("src", "main", "webapp").toFile().getAbsolutePath();
                String fileName = file.getAbsolutePath().replace(projectDir, "");
                WarBuilder.writeFileToZip(this.output, file, fileName);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to add file: " + path.toAbsolutePath() + "  from webapp to the war", e);
            }
        }
    }

    private void addClassesToZip(ZipOutputStream output, String prefix, File classesDirectory) {
        try {
            Files.walk(classesDirectory.toPath(), new FileVisitOption[0]).map(Path::toFile).forEach(file -> this.addClassToZip(output, prefix, (File)file, classesDirectory));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to add classes to war", e);
        }
    }

    private void addClassToZip(ZipOutputStream output, String prefix, File file, File classesDirectory) {
        URI base = classesDirectory.toURI();
        try {
            String name = base.relativize(file.toURI()).getPath();
            name = prefix + name;
            if (file.isDirectory()) {
                name = name.endsWith("/") ? name : name + "/";
                output.putNextEntry(new ZipEntry(name));
                output.closeEntry();
            } else {
                WarBuilder.writeFileToZip(output, file, name);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to add file " + file.getAbsolutePath() + " to war", e);
        }
    }

    private static void writeFileToZip(ZipOutputStream output, File file, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        output.putNextEntry(entry);
        try (FileInputStream input = new FileInputStream(file);){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) >= 0) {
                output.write(buffer, 0, length);
            }
        }
        output.closeEntry();
    }
}

