/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner.cache;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.swarm.runner.RunnerConstants;
import org.wildfly.swarm.tools.ArtifactSpec;

public class ArtifactResolutionCache {
    public static final Path CACHE_PATH = Paths.get(RunnerConstants.CACHE_STORAGE_DIR, "resolution-cache");
    public static final ArtifactResolutionCache INSTANCE = new ArtifactResolutionCache();
    private Map<String, File> resolvedCache = new ConcurrentHashMap<String, File>();
    private Set<String> resolutionFailures = Collections.newSetFromMap(new ConcurrentHashMap());

    private ArtifactResolutionCache() {
        long startTime = System.currentTimeMillis();
        System.out.println("Reading and verifying cache");
        Path cache = CACHE_PATH;
        if (!cache.toFile().exists()) {
            System.out.println("No preexisting artifact resolution cache found. The first execution may take some time.");
        } else {
            try (Stream<String> lines = Files.lines(cache);){
                lines.forEach(this::addToCache);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Error reading resolution cache file, caching will be disabled.");
            }
        }
        this.resolutionFailures.add("org.jboss.narayana.jta:cdi:jar:5.5.30.Final");
        System.out.printf("Cache initialization done in %d ms\n", System.currentTimeMillis() - startTime);
    }

    public void store() {
        System.out.println("Storing cache resolution results...");
        try {
            Files.deleteIfExists(CACHE_PATH);
            List<String> lines = this.resolvedCache.entrySet().stream().map(entry -> String.format("%s#%s", entry.getKey(), ((File)entry.getValue()).getAbsolutePath())).collect(Collectors.toList());
            this.storeToFile(CACHE_PATH, lines);
        }
        catch (IOException e) {
            System.out.println("Failed to store artifact resolution. Next execution won't be able to use full caching capabilities");
            e.printStackTrace();
        }
    }

    private void addToCache(String cacheFileLine) {
        String[] split = cacheFileLine.split("#");
        try {
            String key = split[0];
            String path = split[1];
            File file = Paths.get(path, new String[0]).toFile();
            if (file.exists()) {
                this.resolvedCache.put(key, file);
            } else {
                System.out.printf("Omitting %s -> %s mapping from cache resolution. It points to a non-existent file\n", key, path);
            }
        }
        catch (Exception any) {
            System.out.printf("Omitting invalid cache line %s\n", cacheFileLine);
            any.printStackTrace();
        }
    }

    private void storeToFile(Path path, List<String> linesToStore) throws IOException {
        File cacheFile = path.toFile();
        File parent = cacheFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(cacheFile);){
            for (String line : linesToStore) {
                writer.append(line).append("\n");
            }
        }
    }

    public File getCachedFile(ArtifactSpec spec) {
        String key = spec.mavenGav();
        return this.resolvedCache.get(key);
    }

    public void storeArtifactFile(ArtifactSpec spec, File maybeFile) {
        if (maybeFile != null) {
            this.resolvedCache.put(spec.mavenGav(), maybeFile);
        }
    }

    public void storeResolutionFailure(ArtifactSpec spec) {
        this.resolutionFailures.add(spec.mavenGav());
    }

    public boolean isKnownFailure(ArtifactSpec spec) {
        return this.resolutionFailures.contains(spec.mavenGav());
    }
}

