/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.wildfly.swarm.maven.utils.RepositorySystemSessionWrapper;
import org.wildfly.swarm.runner.RunnerConstants;
import org.wildfly.swarm.runner.cache.ArtifactResolutionCache;
import org.wildfly.swarm.runner.cache.DependencyResolutionCache;
import org.wildfly.swarm.runner.maven.MavenInitializer;
import org.wildfly.swarm.runner.utils.StringUtils;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class CachingArtifactResolvingHelper
implements ArtifactResolvingHelper {
    private final DependencyResolutionCache dependencyCache = DependencyResolutionCache.INSTANCE;
    private final ArtifactResolutionCache artifactCache = ArtifactResolutionCache.INSTANCE;
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private final RepositorySystem repoSystem = MavenInitializer.newRepositorySystem();
    private final RepositorySystemSession session = MavenInitializer.newSession(this.repoSystem);

    public CachingArtifactResolvingHelper() {
        this.addDefaultRepositories();
        this.addUserRepositories();
    }

    public ArtifactSpec resolve(ArtifactSpec spec) {
        if (spec.file == null) {
            File maybeFile = this.artifactCache.getCachedFile(spec);
            if (!this.artifactCache.isKnownFailure(spec) && maybeFile == null) {
                System.out.println("no cached file for " + spec.mscGav());
                maybeFile = this.resolveArtifactFile(spec);
                this.artifactCache.storeArtifactFile(spec, maybeFile);
            }
            if (maybeFile == null) {
                this.artifactCache.storeResolutionFailure(spec);
                return null;
            }
            spec.file = maybeFile;
        }
        return spec;
    }

    public Set<ArtifactSpec> resolveAll(Collection<ArtifactSpec> specs, boolean transitive, boolean defaultExcludes) throws Exception {
        if (specs.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<ArtifactSpec> toResolve = specs;
        if (transitive) {
            toResolve = this.resolveDependencies(specs, defaultExcludes);
        }
        return this.resolveInParallel(toResolve);
    }

    public void addDefaultRepositories() {
        if (RunnerConstants.IGNORE_DEFAULT_REPOSITORIES == null) {
            this.remoteRepositories.add(MavenInitializer.buildRemoteRepository(this.session, "jboss-public-repository-group", "https://repository.jboss.org/nexus/content/groups/public/", null, null));
            this.remoteRepositories.add(MavenInitializer.buildRemoteRepository(this.session, "redhat-ga", "https://maven.repository.redhat.com/ga/", null, null));
            this.remoteRepositories.add(MavenInitializer.buildRemoteRepository(this.session, "maven-central", "https://repo.maven.apache.org/maven2/", null, null));
        }
    }

    private Set<ArtifactSpec> resolveInParallel(Collection<ArtifactSpec> toResolve) throws InterruptedException {
        ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 10);
        List callable = toResolve.stream().map(spec -> () -> this.resolve((ArtifactSpec)spec)).collect(Collectors.toList());
        List futures = threadPool.invokeAll(callable);
        Set<ArtifactSpec> result = futures.stream().map(this::safeGet).filter(Objects::nonNull).collect(Collectors.toSet());
        threadPool.shutdown();
        return result;
    }

    private <T> T safeGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addUserRepositories() {
        String repositoriesProperty = RunnerConstants.USER_REPOSITORIES;
        if (repositoriesProperty != null) {
            Stream.of(repositoriesProperty.split(",")).forEach(this::addUserRepository);
        }
    }

    private void addUserRepository(String repositoryAsString) {
        String[] split = repositoryAsString.split("#");
        String url = split[0];
        String username = null;
        String password = null;
        if (split.length > 2) {
            username = split[1];
            password = split[2];
        }
        this.remoteRepositories.add(MavenInitializer.buildRemoteRepository(this.session, StringUtils.randomAlphabetic(8), url, username, password));
    }

    private Collection<ArtifactSpec> resolveDependencies(Collection<ArtifactSpec> specs, boolean defaultExcludes) throws DependencyCollectionException {
        List<Object> dependencyNodes = this.dependencyCache.getCachedDependencies(specs, defaultExcludes);
        if (dependencyNodes == null) {
            List dependencies = specs.stream().map(this::artifact).map(a -> new Dependency((Artifact)a, "compile")).collect(Collectors.toList());
            CollectRequest collectRequest = new CollectRequest(dependencies, null, this.remoteRepositories);
            RepositorySystemSessionWrapper session = new RepositorySystemSessionWrapper(this.session, defaultExcludes);
            CollectResult result = this.repoSystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            PreorderNodeListGenerator gen = new PreorderNodeListGenerator();
            result.getRoot().accept((DependencyVisitor)gen);
            dependencyNodes = gen.getNodes().stream().map(node -> {
                Artifact artifact = node.getArtifact();
                return new ArtifactSpec(node.getDependency().getScope(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension(), artifact.getClassifier(), artifact.getFile());
            }).collect(Collectors.toList());
            this.dependencyCache.storeCachedDependencies(specs, dependencyNodes, defaultExcludes);
        }
        Collection<ArtifactSpec> result = this.resolveDependencies(dependencyNodes);
        return result;
    }

    private Collection<ArtifactSpec> resolveDependencies(List<ArtifactSpec> dependencyNodes) {
        long start = System.currentTimeMillis();
        dependencyNodes = new ArrayList<ArtifactSpec>(dependencyNodes);
        return dependencyNodes.parallelStream().filter(node -> !"system".equals(node.scope)).map(node -> new ArtifactSpec(node.scope, node.groupId(), node.artifactId(), node.version(), "bundle".equals(node.type()) ? "jar" : node.type(), node.classifier(), null)).map(this::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private DefaultArtifact artifact(ArtifactSpec spec) {
        String type = spec.type();
        type = "bundle".equals(type) ? "jar" : type;
        return new DefaultArtifact(spec.groupId(), spec.artifactId(), spec.classifier(), type, spec.version());
    }

    private File resolveArtifactFile(ArtifactSpec spec) {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)this.artifact(spec));
        this.remoteRepositories.forEach(arg_0 -> ((ArtifactRequest)request).addRepository(arg_0));
        try {
            ArtifactResult artifactResult = this.repoSystem.resolveArtifact(this.session, request);
            return artifactResult.isResolved() ? artifactResult.getArtifact().getFile() : null;
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
            return null;
        }
    }
}

