/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runner.maven;

import java.io.File;
import java.nio.file.Paths;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class MavenInitializer {
    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static RepositorySystemSession newSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(MavenInitializer.localRepoLocation());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    public static File localRepoLocation() {
        String userHome;
        File result = null;
        String userRepository = System.getProperty("thorntail.runner.local-repository");
        if (userRepository != null && !(result = new File(userRepository)).isDirectory()) {
            System.err.println("The defined local repository: " + userRepository + " does not exist or is not a directory");
        }
        if (result == null && !(result = Paths.get(userHome = System.getProperty("user.home"), ".m2", "repository").toFile()).exists()) {
            result.mkdirs();
        }
        return result;
    }

    public static RemoteRepository buildRemoteRepository(RepositorySystemSession session, String id, String url, String username, String password) {
        Proxy proxy;
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        if (username != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(username).addPassword(password).build());
        }
        RemoteRepository repository = builder.build();
        RemoteRepository mirror = session.getMirrorSelector().getMirror(repository);
        if (mirror != null) {
            Authentication mirrorAuth = session.getAuthenticationSelector().getAuthentication(mirror);
            RemoteRepository.Builder mirrorBuilder = new RemoteRepository.Builder(mirror).setId(repository.getId());
            if (mirrorAuth != null) {
                mirrorBuilder.setAuthentication(mirrorAuth);
            }
            repository = mirrorBuilder.build();
        }
        if ((proxy = session.getProxySelector().getProxy(repository)) != null) {
            repository = new RemoteRepository.Builder(repository).setProxy(proxy).build();
        }
        return repository;
    }

    private MavenInitializer() {
    }
}

