/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.bootstrap.env.WildFlySwarmManifest;
import org.wildfly.swarm.jdk.specific.JarFiles;
import org.wildfly.swarm.tools.ArtifactResolver;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.wildfly.swarm.tools.ModuleAnalyzer;
import org.wildfly.swarm.tools.ProjectAsset;
import org.wildfly.swarm.tools.ResolvedDependencies;
import org.wildfly.swarm.tools.utils.ChecksumUtil;

public class DependencyManager
implements ResolvedDependencies {
    private static final String JAR = "jar";
    private final WildFlySwarmManifest applicationManifest = new WildFlySwarmManifest();
    private final List<FractionManifest> fractionManifests = new ArrayList<FractionManifest>();
    private final Set<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> removableDependencies = new HashSet<ArtifactSpec>();
    private volatile Set<String> removableCheckSums;
    private final Set<ArtifactSpec> moduleDependencies = new HashSet<ArtifactSpec>();
    private ProjectAsset projectAsset;
    private ArtifactResolver resolver;
    private final boolean removeAllThorntailLibs;

    public DependencyManager(ArtifactResolver resolver, boolean removeAllThorntailLibs) {
        this.resolver = resolver;
        this.removeAllThorntailLibs = removeAllThorntailLibs;
    }

    public void addAdditionalModule(Path module) {
        try {
            this.analyzeModuleDependencies(new ModuleAnalyzer(module));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<ArtifactSpec> getDependencies() {
        return this.dependencies;
    }

    @Override
    public ArtifactSpec findWildFlySwarmBootstrapJar() {
        return this.findArtifact("io.thorntail", "bootstrap", null, JAR, null, false);
    }

    @Override
    public ArtifactSpec findJBossModulesJar() {
        return this.findArtifact("org.jboss.modules", "jboss-modules", null, JAR, null, false);
    }

    @Override
    public ArtifactSpec findArtifact(String groupId, String artifactId, String version, String packaging, String classifier) {
        return this.findArtifact(groupId, artifactId, version, packaging, classifier, true);
    }

    @Override
    public ArtifactSpec findArtifact(String groupId, String artifactId, String version, String packaging, String classifier, boolean includeTestScope) {
        for (ArtifactSpec each : this.dependencies) {
            if (groupId != null && !groupId.equals(each.groupId()) || artifactId != null && !artifactId.equals(each.artifactId()) || version != null && !version.equals(each.version()) || packaging != null && !packaging.equals(each.type()) || classifier != null && !classifier.equals(each.classifier()) || !includeTestScope && each.scope.equals("test")) continue;
            return each;
        }
        return null;
    }

    public ResolvedDependencies analyzeDependencies(boolean autodetect, DeclaredDependencies declaredDependencies) throws Exception {
        this.resolveDependencies(declaredDependencies, autodetect);
        this.analyzeFractionManifests();
        this.analyzeRemovableDependencies(declaredDependencies);
        this.dependencies.stream().filter(e -> !this.removableDependencies.contains(e)).forEach(e -> this.applicationManifest.addDependency(e.mavenGav()));
        this.analyzeModuleDependencies();
        return this;
    }

    private void resolveDependencies(DeclaredDependencies declaredDependencies, boolean autodetect) throws Exception {
        Collection<Object> resolvedTransientDependencies;
        Collection filtered;
        Collection<ArtifactSpec> inputSet;
        this.dependencies.clear();
        ArrayList<ArtifactSpec> explicitDependencies = new ArrayList<ArtifactSpec>(declaredDependencies.getDirectDependencies());
        declaredDependencies.runnerDependency().ifPresent(runner -> this.filterOutRunnerDependencies((ArtifactSpec)((Object)runner), (Collection<ArtifactSpec>)explicitDependencies));
        boolean resolveExplicitsTransitively = !declaredDependencies.isPresolved() || autodetect;
        Collection<ArtifactSpec> resolvedExplicitDependencies = resolveExplicitsTransitively ? this.resolver.resolveAllArtifactsTransitively(explicitDependencies, false) : this.resolver.resolveAllArtifactsNonTransitively(explicitDependencies);
        this.dependencies.addAll(resolvedExplicitDependencies);
        if (declaredDependencies.getTransientDependencies().isEmpty()) {
            inputSet = explicitDependencies;
            filtered = inputSet.stream().filter(dep -> dep.type().equals(JAR)).collect(Collectors.toList());
            resolvedTransientDependencies = this.resolver.resolveAllArtifactsTransitively(filtered, false);
            this.dependencies.addAll(resolvedTransientDependencies);
        } else {
            inputSet = declaredDependencies.getTransientDependencies();
            filtered = inputSet.stream().filter(dep -> dep.type().equals(JAR)).collect(Collectors.toList());
            resolvedTransientDependencies = Collections.emptySet();
            if (filtered.size() > 0) {
                resolvedTransientDependencies = this.resolver.resolveAllArtifactsNonTransitively(filtered);
                this.dependencies.addAll(resolvedTransientDependencies);
            }
        }
        ArrayList<ArtifactSpec> remainder = new ArrayList<ArtifactSpec>(inputSet);
        remainder.removeAll(resolvedTransientDependencies);
        this.dependencies.addAll(this.resolver.resolveAllArtifactsNonTransitively(remainder));
    }

    private void filterOutRunnerDependencies(ArtifactSpec runnerJar, Collection<ArtifactSpec> explicitDependencies) {
        this.removableDependencies.add(runnerJar);
        explicitDependencies.remove((Object)runnerJar);
        this.mavenDependencies(runnerJar.file).stream().map(ArtifactSpec::fromMavenDependencyDescription).forEach(this.removableDependencies::add);
    }

    private void analyzeModuleDependencies() {
        this.dependencies.stream().filter(e -> e.type().equals(JAR)).map(e -> e.file).flatMap(ResolvedDependencies::findModuleXmls).forEach(this::analyzeModuleDependencies);
    }

    private void analyzeModuleDependencies(ModuleAnalyzer analyzer) {
        List<ArtifactSpec> thorntailDependencies = analyzer.getDependencies();
        this.moduleDependencies.addAll(thorntailDependencies);
    }

    private void analyzeFractionManifests() {
        this.dependencies.stream().map(e -> this.fractionManifest(e.file)).filter(Objects::nonNull).peek(this.fractionManifests::add).forEach(manifest -> {
            String module = manifest.getModule();
            if (module != null) {
                this.applicationManifest.addBootstrapModule(module);
            }
        });
        this.dependencies.stream().filter(e -> DependencyManager.isFractionJar(e.file) || this.isConfigApiModulesJar(e.file)).forEach(artifact -> this.applicationManifest.addBootstrapArtifact(artifact.mavenGav()));
    }

    private void analyzeRemovableDependencies(DeclaredDependencies declaredDependencies) throws Exception {
        Collection bootstrapDeps = this.dependencies.stream().filter(e -> DependencyManager.isFractionJar(e.file)).collect(Collectors.toSet());
        if (this.removeAllThorntailLibs) {
            String whitelistProperty = System.getProperty("thorntail.runner.user-dependencies");
            HashSet<String> whitelist = new HashSet<String>();
            if (whitelistProperty != null) {
                whitelist.addAll(Arrays.asList(whitelistProperty.split(",")));
            }
            HashSet uniqueMavenDependencies = new HashSet();
            this.dependencies.stream().map(e -> e.file).flatMap(e -> this.mavenDependencies((File)e).stream()).forEach(uniqueMavenDependencies::add);
            this.fractionManifests.stream().flatMap(manifest -> manifest.getMavenDependencies().stream()).forEach(uniqueMavenDependencies::add);
            uniqueMavenDependencies.stream().map(ArtifactSpec::fromMavenDependencyDescription).forEach(this.removableDependencies::add);
            this.removableDependencies.addAll(bootstrapDeps);
            this.removableDependencies.removeIf(dep -> whitelist.contains(dep.mscGav()));
        } else {
            Collection<Object> nonBootstrapTransitive;
            ArrayList<ArtifactSpec> nonBootstrapDeps = new ArrayList<ArtifactSpec>();
            nonBootstrapDeps.addAll(declaredDependencies.getDirectDependencies());
            nonBootstrapDeps.removeAll(bootstrapDeps);
            if (declaredDependencies.isPresolved()) {
                nonBootstrapTransitive = new HashSet();
                nonBootstrapDeps.stream().filter(s -> !"io.thorntail".equals(s.groupId())).forEach(s -> {
                    nonBootstrapTransitive.add(s);
                    nonBootstrapTransitive.addAll(declaredDependencies.getTransientDependencies((ArtifactSpec)((Object)s)));
                });
            } else {
                nonBootstrapTransitive = this.resolver.resolveAllArtifactsTransitively(nonBootstrapDeps, true);
            }
            Set justJars = this.dependencies.stream().filter(e -> e.type().equals(JAR)).collect(Collectors.toSet());
            this.removableDependencies.addAll(justJars);
            this.removableDependencies.removeAll(nonBootstrapTransitive);
        }
    }

    Set<ArtifactSpec> getRemovableDependencies() {
        return this.removableDependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRemovable(Node node) {
        Asset asset = node.getAsset();
        if (asset == null) {
            return false;
        }
        if (this.removableCheckSums == null) {
            this.initCheckSums();
        }
        try (InputStream inputStream = asset.openStream();){
            String checksum = ChecksumUtil.calculateChecksum(inputStream);
            boolean bl = this.removableCheckSums.contains(checksum);
            return bl;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
    }

    private synchronized void initCheckSums() {
        if (this.removableCheckSums == null) {
            this.removableCheckSums = this.removableDependencies.stream().map(this::checksum).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checksum(ArtifactSpec spec) {
        if (spec.sha1sum != null) {
            return spec.sha1sum;
        }
        try (FileInputStream stream = new FileInputStream(spec.file);){
            String string = ChecksumUtil.calculateChecksum(stream);
            return string;
        }
        catch (Exception any) {
            any.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isConfigApiModulesJar(File file) {
        if (file == null) {
            return false;
        }
        try (JarFile jar = JarFiles.create((File)file);){
            boolean bl = jar.getEntry("wildfly-swarm-modules.conf") != null;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFractionJar(File file) {
        if (file == null) {
            return false;
        }
        try (JarFile jar = JarFiles.create((File)file);){
            boolean bl = jar.getEntry("META-INF/fraction-manifest.yaml") != null;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected List<String> mavenDependencies(File file) {
        ArrayList<String> resultList;
        block40: {
            if (file == null) {
                return Collections.emptyList();
            }
            resultList = new ArrayList<String>();
            try (JarFile jar = JarFiles.create((File)file);){
                ZipEntry entry = jar.getEntry("META-INF/maven-dependencies.txt");
                if (entry == null) break block40;
                InputStream inputStream = jar.getInputStream(entry);
                try (InputStreamReader streamReader = new InputStreamReader(inputStream);
                     BufferedReader reader = new BufferedReader(streamReader);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        resultList.add(line);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return resultList;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected FractionManifest fractionManifest(File file) {
        block30: {
            try {
                Throwable throwable = null;
                try (JarFile jar = JarFiles.create((File)file);){
                    ZipEntry entry = jar.getEntry("META-INF/fraction-manifest.yaml");
                    if (entry != null) {
                        try (InputStream in = jar.getInputStream(entry);){
                            FractionManifest fractionManifest = new FractionManifest(in);
                            return fractionManifest;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    void setProjectAsset(ProjectAsset projectAsset) {
        if (!this.applicationManifest.isHollow()) {
            this.projectAsset = projectAsset;
            this.applicationManifest.setAsset(this.projectAsset.getName());
        }
    }

    protected WildFlySwarmManifest getWildFlySwarmManifest() {
        return this.applicationManifest;
    }

    @Override
    public Set<ArtifactSpec> getModuleDependencies() {
        return this.moduleDependencies;
    }
}

