/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.swarm.bootstrap.env.DependencyTree;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.tools.ArtifactSpec;

public class DeclaredDependencies
extends DependencyTree<ArtifactSpec> {
    private static final Set<String> PRIORITIZED_SCOPES = Stream.of("compile", "provided").collect(Collectors.toSet());
    private Set<ArtifactSpec> completeTransitiveDependencies;

    public Collection<ArtifactSpec> getDirectDependencies() {
        return new LinkedHashSet<ArtifactSpec>(this.getDirectDeps());
    }

    public Set<ArtifactSpec> getTransientDependencies() {
        HashSet<ArtifactSpec> deps = new HashSet<ArtifactSpec>();
        this.getDirectDeps().stream().filter(d -> !this.isThorntailRunner((ArtifactSpec)((Object)d))).forEach(d -> deps.addAll(this.getTransientDeps(d)));
        return deps;
    }

    public Collection<ArtifactSpec> getRuntimeExplicitAndTransientDependencies() {
        HashSet<ArtifactSpec> allDeps = new HashSet<ArtifactSpec>();
        this.getDirectDeps().stream().filter(spec -> !spec.scope.equals("test")).forEach(spec -> {
            allDeps.add((ArtifactSpec)((Object)spec));
            allDeps.addAll(this.getTransientDeps(spec));
        });
        return allDeps;
    }

    public Collection<ArtifactSpec> getTransientDependencies(ArtifactSpec artifact) {
        HashSet<ArtifactSpec> deps = new HashSet<ArtifactSpec>();
        if (this.isDirectDep((Object)artifact)) {
            deps.addAll(this.getTransientDeps((Object)artifact));
        }
        return deps;
    }

    public boolean isPresolved() {
        boolean unsolvedDependenciesExist = this.getDirectDeps().stream().anyMatch(d -> !this.getTransientDeps(d).isEmpty());
        return !unsolvedDependenciesExist;
    }

    public Optional<ArtifactSpec> runnerDependency() {
        return this.getDirectDependencies().stream().filter(this::isThorntailRunner).findAny();
    }

    private boolean isThorntailRunner(ArtifactSpec artifactSpec) {
        return artifactSpec.groupId().equals("io.thorntail") && artifactSpec.artifactId().equals("thorntail-runner");
    }

    public static ArtifactSpec createSpec(String gav) {
        return DeclaredDependencies.createSpec(gav, "compile");
    }

    public static ArtifactSpec createSpec(String gav, String scope) {
        try {
            MavenArtifactDescriptor maven = ArtifactSpec.fromMavenGav((String)gav);
            return new ArtifactSpec(scope, maven.groupId(), maven.artifactId(), maven.version(), maven.type(), maven.classifier(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(File file) {
        try {
            FileWriter w = new FileWriter(file);
            for (ArtifactSpec key : this.getDirectDeps()) {
                w.write(key.mavenGav());
                w.write(":\n");
                for (ArtifactSpec s : this.getTransientDeps((Object)key)) {
                    w.write("  - ");
                    w.write(s.mavenGav());
                    w.write("\n");
                }
            }
            ((Writer)w).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write dependency tree", e);
        }
    }

    public Collection<ArtifactSpec> getDirectDeps() {
        Collection originalDeps = super.getDirectDeps();
        ArrayList<ArtifactSpec> reordered = new ArrayList<ArtifactSpec>(originalDeps.size());
        originalDeps.stream().filter(s -> PRIORITIZED_SCOPES.contains(s.scope)).forEach(reordered::add);
        originalDeps.stream().filter(s -> !PRIORITIZED_SCOPES.contains(s.scope)).forEach(reordered::add);
        return reordered;
    }

    public void markComplete(ArtifactSpec directDep) {
        if (this.completeTransitiveDependencies == null) {
            this.completeTransitiveDependencies = new HashSet<ArtifactSpec>();
        }
        this.completeTransitiveDependencies.add(directDep);
    }

    public boolean isComplete(ArtifactSpec directDep) {
        return this.completeTransitiveDependencies != null && this.completeTransitiveDependencies.contains((Object)directDep);
    }
}

