/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.fractions.FractionDescriptor;

public class ArtifactSpec
extends MavenArtifactDescriptor {
    public final String scope;
    public String sha1sum;
    public File file;
    public boolean shouldGather = true;

    public ArtifactSpec(String scope, String groupId, String artifactId, String version, String packaging, String classifier, File file) {
        super(groupId, artifactId, packaging, classifier, version);
        this.scope = scope;
        this.file = file;
        this.sha1sum = null;
    }

    private ArtifactSpec(String groupId, String artifactId, String version, String classifier, String sha1sum) {
        super(groupId, artifactId, "jar", classifier, version);
        this.sha1sum = sha1sum;
        this.scope = "compile";
    }

    public static ArtifactSpec fromMscGav(String gav) {
        String[] parts = gav.split(":");
        if (parts.length == 3) {
            return new ArtifactSpec("compile", parts[0], parts[1], parts[2], "jar", null, null);
        }
        if (parts.length == 4) {
            return new ArtifactSpec("compile", parts[0], parts[1], parts[2], "jar", parts[3], null);
        }
        throw new RuntimeException("Invalid gav: " + gav);
    }

    public static ArtifactSpec fromMavenDependencyDescription(String description) {
        String[] parts = description.split("#");
        ArtifactSpec result = ArtifactSpec.fromMscGav(parts[0]);
        result.sha1sum = parts[1];
        return result;
    }

    public FractionDescriptor toFractionDescriptor() {
        return new FractionDescriptor(this.groupId(), this.artifactId(), this.version());
    }

    public static ArtifactSpec fromFractionDescriptor(FractionDescriptor descriptor) {
        return ArtifactSpec.fromMscGav(descriptor.toString());
    }

    public String jarName() {
        String classifier = this.classifier();
        classifier = classifier != null && classifier.length() > 0 ? "-" + classifier : "";
        return String.format("%s-%s%s.%s", this.artifactId(), this.version(), classifier, this.type());
    }

    public String jarRepoPath() {
        return String.format("%s/%s/%s/%s", this.groupId().replace('.', '/'), this.artifactId(), this.version(), this.jarName());
    }

    public boolean isResolved() {
        return this.file != null;
    }

    public String toString() {
        return this.mavenGav() + " [" + this.scope + "]";
    }
}

