/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.JBossWebAsset;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class HttpSecurityPreparer
implements DeploymentProcessor {
    private static final Logger LOG = Logger.getLogger(HttpSecurityPreparer.class);
    private final Archive archive;
    @AttributeDocumentation(value="Map of security configuration by deployment")
    @Configurable(value="thorntail.deployment")
    Map<String, Object> deploymentConfigs;

    @Inject
    public HttpSecurityPreparer(Archive archive) {
        this.archive = archive;
    }

    public void process() {
        if (this.deploymentConfigs == null || this.deploymentConfigs.isEmpty()) {
            return;
        }
        Optional<String> match = this.deploymentConfigs.keySet().stream().filter(c -> this.archive.getName().equals(c)).findFirst();
        if (!match.isPresent()) {
            return;
        }
        Map matchingConfig = (Map)this.deploymentConfigs.get(match.get());
        if (!matchingConfig.containsKey("web")) {
            return;
        }
        Map deploymentConfig = (Map)matchingConfig.get("web");
        WARArchive war = (WARArchive)this.archive.as(WARArchive.class);
        WebXmlAsset webXml = war.findWebXmlAsset();
        JBossWebAsset jbossWeb = war.findJbossWebAsset();
        Map loginConfig = (Map)deploymentConfig.get("login-config");
        if (loginConfig != null) {
            String authMethod = loginConfig.getOrDefault("auth-method", "NONE");
            webXml.setLoginConfig(authMethod, loginConfig.getOrDefault("realm-name", "ignored"));
            if (loginConfig.containsKey("security-domain")) {
                jbossWeb.setSecurityDomain((String)loginConfig.get("security-domain"));
            }
            if (loginConfig.containsKey("form-login-config")) {
                Map formLoginConfig = (Map)loginConfig.get("form-login-config");
                webXml.setFormLoginConfig("Security Realm", (String)formLoginConfig.get("form-login-page"), (String)formLoginConfig.get("form-error-page"));
            }
        }
        List securityConstraints = deploymentConfig.getOrDefault("security-constraints", Collections.EMPTY_LIST);
        for (Map sc : securityConstraints) {
            SecurityConstraint securityConstraint = webXml.protect(sc.getOrDefault("url-pattern", "/*"));
            sc.getOrDefault("methods", Collections.emptyList()).forEach(securityConstraint::withMethod);
            List roles = (List)sc.get("roles");
            if (roles != null) {
                securityConstraint.withRole(roles.toArray(new String[roles.size()]));
                continue;
            }
            securityConstraint.permitAll();
        }
    }
}

