/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.tiledb.cloud.Pair;
import io.tiledb.cloud.TileDBClient;
import io.tiledb.cloud.TileDBLogin;
import io.tiledb.cloud.TileDBSQL;
import io.tiledb.cloud.TileDBUDF;
import io.tiledb.cloud.TileDBUtils;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.api.ArrayApi;
import io.tiledb.cloud.rest_api.api.GroupsApi;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.ArrayInfoUpdate;
import io.tiledb.cloud.rest_api.model.ArraySchema;
import io.tiledb.cloud.rest_api.model.ArrayType;
import io.tiledb.cloud.rest_api.model.Attribute;
import io.tiledb.cloud.rest_api.model.Datatype;
import io.tiledb.cloud.rest_api.model.Dimension;
import io.tiledb.cloud.rest_api.model.DimensionTileExtent;
import io.tiledb.cloud.rest_api.model.Domain;
import io.tiledb.cloud.rest_api.model.DomainArray;
import io.tiledb.cloud.rest_api.model.Filter;
import io.tiledb.cloud.rest_api.model.FilterPipeline;
import io.tiledb.cloud.rest_api.model.FilterType;
import io.tiledb.cloud.rest_api.model.GenericUDF;
import io.tiledb.cloud.rest_api.model.GroupBrowserData;
import io.tiledb.cloud.rest_api.model.Layout;
import io.tiledb.cloud.rest_api.model.MultiArrayUDF;
import io.tiledb.cloud.rest_api.model.QueryRanges;
import io.tiledb.cloud.rest_api.model.SQLParameters;
import io.tiledb.cloud.rest_api.model.UDFArrayDetails;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.arrow.vector.ValueVector;

public class Examples {
    public static void main(String[] args2) throws ApiException {
        TileDBClient tileDBClient = new TileDBClient(new TileDBLogin(null, null, System.getenv("API_TOKEN"), true, true, true, "https://api.tiledb.com"));
        tileDBClient.setDebugging(true);
        Examples.runGenericUDF(tileDBClient);
        Examples.runArrayUDF(tileDBClient);
        Examples.runMultiArrayUDF(tileDBClient);
        Examples.getArray(tileDBClient);
        Examples.listArrays(tileDBClient);
        Examples.listGroups(tileDBClient);
        Examples.runSQL(tileDBClient);
        Examples.runSQLArrow(tileDBClient);
    }

    private static void runSQL(TileDBClient tileDBClient) {
        SQLParameters sqlParameters = new SQLParameters();
        sqlParameters.setQuery("SELECT * FROM `tiledb://TileDB-Inc/quickstart_sparse`");
        TileDBSQL tileDBSQL = new TileDBSQL(tileDBClient, "TileDB-Inc", sqlParameters);
        System.out.println(tileDBSQL.exec());
    }

    private static void runSQLArrow(TileDBClient tileDBClient) {
        SQLParameters sqlParameters = new SQLParameters();
        sqlParameters.setQuery("SELECT * FROM `tiledb://TileDB-Inc/quickstart_sparse`");
        TileDBSQL tileDBSQL = new TileDBSQL(tileDBClient, "TileDB-Inc", sqlParameters);
        Pair<ArrayList<ValueVector>, Integer> a = tileDBSQL.execArrow();
    }

    private static void runGenericUDF(TileDBClient tileDBClient) {
        TileDBUDF tileDBUDF = new TileDBUDF(tileDBClient, "TileDB-Inc");
        GenericUDF genericUDF = new GenericUDF();
        genericUDF.setUdfInfoName("TileDB-Inc/args-udf");
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("arg1", "a1");
        arguments.put("arg2", "a2");
        genericUDF.setArgument(TileDBUtils.serializeArgs(arguments));
        System.out.println(tileDBUDF.executeGeneric(genericUDF));
    }

    public static void runArrayUDF(TileDBClient tileDBClient) {
        TileDBUDF tileDBUDF = new TileDBUDF(tileDBClient, "TileDB-Inc");
        ArrayList<BigDecimal> range1 = new ArrayList<BigDecimal>();
        range1.add(BigDecimal.valueOf(1L));
        range1.add(BigDecimal.valueOf(4L));
        ArrayList<BigDecimal> range2 = new ArrayList<BigDecimal>();
        range2.add(BigDecimal.valueOf(1L));
        range2.add(BigDecimal.valueOf(4L));
        QueryRanges queryRanges = new QueryRanges();
        queryRanges.addRangesItem(range1);
        queryRanges.addRangesItem(range2);
        HashMap<String, Object> argumentsForArrayUDF = new HashMap<String, Object>();
        argumentsForArrayUDF.put("attr", "rows");
        argumentsForArrayUDF.put("scale", 9);
        GenericUDF genericUDF = new GenericUDF();
        genericUDF.setUdfInfoName("TileDB-Inc/array-udf");
        genericUDF.setArgument(TileDBUtils.serializeArgs(argumentsForArrayUDF));
        UDFArrayDetails array = new UDFArrayDetails();
        array.setUri("tiledb://TileDB-Inc/quickstart_sparse");
        System.out.println(tileDBUDF.executeSingleArray(genericUDF, array, queryRanges, "TileDB-Inc"));
    }

    public static void runMultiArrayUDF(TileDBClient tileDBClient) {
        TileDBUDF tileDBUDF = new TileDBUDF(tileDBClient, "TileDB-Inc");
        ArrayList<BigDecimal> range1 = new ArrayList<BigDecimal>();
        range1.add(BigDecimal.valueOf(1L));
        range1.add(BigDecimal.valueOf(4L));
        ArrayList<BigDecimal> range2 = new ArrayList<BigDecimal>();
        range2.add(BigDecimal.valueOf(1L));
        range2.add(BigDecimal.valueOf(4L));
        QueryRanges queryRanges = new QueryRanges();
        queryRanges.addRangesItem(range1);
        queryRanges.addRangesItem(range2);
        MultiArrayUDF multiArrayUDF = new MultiArrayUDF();
        multiArrayUDF.setUdfInfoName("TileDB-Inc/multi-array-udf");
        ArrayList<UDFArrayDetails> arrays = new ArrayList<UDFArrayDetails>();
        UDFArrayDetails array1 = new UDFArrayDetails();
        array1.setUri("tiledb://shaunreed/dense-array");
        array1.setRanges(queryRanges);
        array1.setBuffers(Arrays.asList("rows", "cols", "a1"));
        arrays.add(array1);
        UDFArrayDetails array2 = new UDFArrayDetails();
        array2.setUri("tiledb://TileDB-Inc/quickstart_dense");
        array2.setRanges(queryRanges);
        array2.setBuffers(Arrays.asList("rows", "cols", "a"));
        arrays.add(array2);
        multiArrayUDF.setArrays(arrays);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("attr1", "a1");
        arguments.put("attr2", "a");
        multiArrayUDF.setArgument(TileDBUtils.serializeArgs(arguments));
        System.out.println(tileDBUDF.executeMultiArray(multiArrayUDF));
    }

    private static void deregisterArray(TileDBClient tileDBClient) {
        String namespace = "<TILEDB_NAMESPACE>";
        String array = "<ARRAY_NAME>";
        ArrayApi apiInstance = new ArrayApi(tileDBClient.getApiClient());
        try {
            apiInstance.deregisterArray(namespace, array);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling ArrayApi#deregisterArray");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }

    private static void deleteArray(TileDBClient tileDBClient) {
        String namespace = "<TILEDB_NAMESPACE>";
        String array = "<ARRAY_NAME>";
        String contentType = "application/json";
        ArrayApi apiInstance = new ArrayApi(tileDBClient.getApiClient());
        try {
            apiInstance.deleteArray(namespace, array, contentType);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling ArrayApi#deleteArray");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }

    private static void listGroups(TileDBClient tileDBClient) {
        GroupsApi apiInstance = new GroupsApi(tileDBClient.getApiClient());
        Integer page = null;
        Integer perPage = null;
        String search = null;
        String namespace = "TileDB-Inc";
        String orderby = null;
        String permissions = null;
        String groupType = "generic";
        List<String> tag = null;
        List<String> excludeTag = null;
        Boolean flat = true;
        String parent = null;
        try {
            GroupBrowserData result = apiInstance.listPublicGroups(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent);
            System.out.println(result.getGroups());
        }
        catch (ApiException e) {
            System.err.println("Exception when calling GroupsApi#listPublicGroups");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }

    private static void listArrays(TileDBClient tileDBClient) {
        String namespace = "dstara";
        ArrayApi apiInstance = new ArrayApi(tileDBClient.getApiClient());
        try {
            List<ArrayInfo> result = apiInstance.getArraysInNamespace(namespace);
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling ArrayApi#getArraysInNamespace");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }

    private static void getArray(TileDBClient tileDBClient) {
        String namespace = "TileDB-Inc";
        String array = "quickstart_sparse";
        String contentType = "application/json";
        ArrayApi apiInstance = new ArrayApi(tileDBClient.getApiClient());
        try {
            ArraySchema result = apiInstance.getArray(namespace, array, contentType);
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling ArrayApi#getArray");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }

    private static void createArray(TileDBClient tileDBClient) {
        String namespace = "<TILEDB_NAMESPACE>";
        String arrayName = "s3://<BUCKET-NAME>/my_array";
        String contentType = "application/json";
        Dimension d1 = new Dimension();
        d1.setName("d1");
        d1.setType(Datatype.INT64);
        DomainArray domainArray = new DomainArray();
        domainArray.addInt64Item(0L);
        domainArray.addInt64Item(4L);
        d1.setDomain(domainArray);
        DimensionTileExtent tileExtent = new DimensionTileExtent().int64(2L);
        d1.setTileExtent(tileExtent);
        d1.setNullTileExtent(false);
        Domain domain = new Domain();
        domain.setTileOrder(Layout.ROW_MAJOR);
        domain.setCellOrder(Layout.ROW_MAJOR);
        domain.setType(Datatype.INT64);
        domain.addDimensionsItem(d1);
        Attribute a1 = new Attribute();
        a1.setName("a1");
        a1.setType(Datatype.INT32);
        a1.setNullable(true);
        ArraySchema schema = new ArraySchema();
        schema.addVersionItem(10);
        FilterPipeline filterPipeline = new FilterPipeline();
        filterPipeline.addFiltersItem(new Filter().type(FilterType.ZSTD));
        schema.setOffsetFilterPipeline(filterPipeline);
        schema.setCoordsFilterPipeline(filterPipeline);
        schema.setDomain(domain);
        schema.setCapacity(1000);
        schema.addAttributesItem(a1);
        schema.setArrayType(ArrayType.DENSE);
        schema.setTileOrder(Layout.ROW_MAJOR);
        schema.setCellOrder(Layout.ROW_MAJOR);
        System.out.println(schema);
        ArrayApi apiInstance = new ArrayApi(tileDBClient.getApiClient());
        try {
            apiInstance.createArray(namespace, arrayName, contentType, schema, null);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling ArrayApi#createArray");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }

    public static void registerArray(TileDBClient tileDBClient) {
        String namespace = "<TILEDB_NAMESPACE>";
        String array = "s3://<BUCKET-NAME>/<ARRAY-URI>/";
        ArrayInfoUpdate arrayMetadata = new ArrayInfoUpdate();
        arrayMetadata.setUri("s3://<BUCKET-NAME>/<ARRAY-URI>/");
        arrayMetadata.setName("<ARRAY-NAME>");
        ArrayApi apiInstance = new ArrayApi(tileDBClient.getApiClient());
        try {
            ArrayInfo result = apiInstance.registerArray(namespace, array, arrayMetadata);
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling ArrayApi#registerArray");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

