/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud;

import io.tiledb.cloud.TileDBLogin;
import io.tiledb.cloud.rest_api.ApiClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TileDBClient {
    private static String apiKey;
    private static String username;
    private static String password;
    private static String basePath;
    private static boolean verifyingSsl;
    private static boolean loginInfoIsInJSONFile;
    private static final String homeDir;
    private static String cloudFilePath;
    static Logger logger;
    private ApiClient apiClient;

    private static boolean loadCloudJSONFileFromHome() throws IOException {
        JSONObject apiKeyObject;
        String fileName = homeDir + cloudFilePath;
        File initialFile = new File(fileName);
        InputStream is = Files.newInputStream(initialFile.toPath(), new OpenOption[0]);
        JSONTokener tokener = new JSONTokener(is);
        JSONObject object = new JSONObject(tokener);
        if (object.has("api_key") && (apiKeyObject = object.getJSONObject("api_key")).has("X-TILEDB-REST-API-KEY")) {
            apiKey = apiKeyObject.getString("X-TILEDB-REST-API-KEY");
            logger.log(Level.INFO, "Found apiKey from disk");
        }
        if (object.has("username")) {
            username = object.getString("username");
            logger.log(Level.INFO, "Found username from disk");
        }
        if (object.has("password")) {
            password = object.getString("password");
            logger.log(Level.INFO, "Found password from disk");
        }
        if (object.has("verify_ssl")) {
            boolean verifySSL;
            verifyingSsl = verifySSL = object.getBoolean("verify_ssl");
            logger.log(Level.INFO, "Found verifySSL from disk");
        }
        if (object.has("host")) {
            String host = object.getString("host");
            basePath = host.equals("https://api.tiledb.com") ? host + "/v1" : host;
            logger.log(Level.INFO, "Found host from disk");
        }
        return (!Objects.equals(apiKey, "") || !Objects.equals(password, "") || Objects.equals(username, "")) && (!Objects.equals(apiKey, "") || !Objects.equals(password, "") && !Objects.equals(username, ""));
    }

    public void setDebugging(boolean flag) {
        this.apiClient.setDebugging(flag);
    }

    private void findCredentials(TileDBLogin tileDBLogin) {
        if (!loginInfoIsInJSONFile) {
            if (tileDBLogin == null || !tileDBLogin.isValid()) {
                logger.warning("No login info was provided nor found. Use the Login class to login for the first time");
            } else {
                this.populateFieldsFromLogin(tileDBLogin);
            }
        } else if (tileDBLogin != null && tileDBLogin.overwritePrevious()) {
            this.populateFieldsFromLogin(tileDBLogin);
        }
    }

    private void populateFieldsFromLogin(TileDBLogin tileDBLogin) {
        basePath = !tileDBLogin.getHost().equals("") ? tileDBLogin.getHost() : "https://api.tiledb.com/v1";
        apiKey = tileDBLogin.getApiKey();
        username = tileDBLogin.getUsername();
        password = tileDBLogin.getPassword();
        verifyingSsl = tileDBLogin.isVerifySSL();
        if (tileDBLogin.rememberMe()) {
            this.writeAuthJSONFileToHome();
        }
    }

    private void writeAuthJSONFileToHome() {
        JSONObject jsonObject = new JSONObject();
        JSONObject apiKeyObject = new JSONObject();
        apiKeyObject.put("X-TILEDB-REST-API-KEY", apiKey);
        jsonObject.put("api_key", apiKeyObject);
        jsonObject.put("username", username);
        jsonObject.put("password", password);
        if (basePath.equals("https://api.tiledb.com/v1")) {
            jsonObject.put("host", "https://api.tiledb.com");
        } else {
            jsonObject.put("host", basePath);
        }
        jsonObject.put("verify_ssl", verifyingSsl);
        try {
            File file = new File(homeDir + cloudFilePath);
            file.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(jsonObject.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TileDBClient(OkHttpClient client, TileDBLogin tileDBLogin) {
        this.apiClient = new ApiClient(client);
        this.setClientCredentials(tileDBLogin);
        this.setReadTimeout(0);
    }

    public TileDBClient(OkHttpClient client) {
        this.apiClient = new ApiClient(client);
        this.setClientCredentials(new TileDBLogin());
        this.setReadTimeout(0);
    }

    public TileDBClient(TileDBLogin tileDBLogin) {
        this.apiClient = new ApiClient();
        this.setClientCredentials(tileDBLogin);
        this.setReadTimeout(0);
    }

    public TileDBClient() {
        this.apiClient = new ApiClient();
        this.setClientCredentials(new TileDBLogin());
        this.setReadTimeout(0);
    }

    public TileDBClient(String basePath, String clientId, String clientSecret, Map<String, String> parameters) {
        this.apiClient = new ApiClient(basePath, clientId, clientSecret, parameters);
        this.setClientCredentials(new TileDBLogin());
        this.setReadTimeout(0);
    }

    public TileDBClient(String basePath, String clientId, String clientSecret, Map<String, String> parameters, TileDBLogin tileDBLogin) {
        this.apiClient = new ApiClient(basePath, clientId, clientSecret, parameters);
        this.setClientCredentials(tileDBLogin);
        this.setReadTimeout(0);
    }

    public void setReadTimeout(int timeout2) {
        this.apiClient = this.apiClient.setReadTimeout(timeout2);
    }

    public void setClientCredentials(TileDBLogin tileDBLogin) {
        this.findCredentials(tileDBLogin);
        this.apiClient.setApiKey(apiKey);
        this.apiClient.setUsername(username);
        this.apiClient.setPassword(password);
        this.apiClient.setBasePath(basePath);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    static {
        homeDir = System.getProperty("user.home");
        logger = Logger.getLogger(TileDBClient.class.getName());
        apiKey = "";
        username = "";
        password = "";
        basePath = "https://api.tiledb.com/v1";
        loginInfoIsInJSONFile = true;
        verifyingSsl = true;
        cloudFilePath = System.getProperty("os.name").toLowerCase().contains("windows") ? "\\.tiledb\\cloud.json" : "/.tiledb/cloud.json";
        boolean ok = false;
        try {
            ok = TileDBClient.loadCloudJSONFileFromHome();
        }
        catch (Exception e) {
            loginInfoIsInJSONFile = false;
        }
        if (!ok) {
            loginInfoIsInJSONFile = false;
        }
    }
}

