/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud;

import io.tiledb.cloud.rest_api.ApiException;

public class TileDBLogin {
    private String password;
    private String username;
    private String host;
    private String apiKey;
    private boolean verifySSL;
    private boolean rememberMe;
    private boolean overwritePrevious;

    public TileDBLogin(String username, String password, String apiKey, boolean verifySSL, boolean rememberMe, boolean overwritePrevious) {
        this.password = password;
        this.username = username;
        this.apiKey = apiKey;
        this.verifySSL = verifySSL;
        this.rememberMe = rememberMe;
        this.overwritePrevious = overwritePrevious;
        this.host = "";
    }

    public TileDBLogin(String username, String password, String apiKey, boolean verifySSL, boolean rememberMe, boolean overwritePrevious, String host) throws ApiException {
        this.password = password;
        this.username = username;
        this.apiKey = apiKey;
        this.verifySSL = verifySSL;
        this.rememberMe = rememberMe;
        this.host = host + "/v1";
        this.overwritePrevious = overwritePrevious;
    }

    public String getHost() {
        return this.host;
    }

    public TileDBLogin() {
        this.overwritePrevious = false;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean overwritePrevious() {
        return this.overwritePrevious;
    }

    public boolean isVerifySSL() {
        return this.verifySSL;
    }

    public boolean rememberMe() {
        return this.rememberMe;
    }

    public boolean isValid() {
        return this.apiKey != null || this.password != null && this.username != null;
    }
}

