/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud;

import io.tiledb.cloud.Pair;
import io.tiledb.cloud.TileDBClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.api.SqlApi;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import io.tiledb.cloud.rest_api.model.SQLParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.unsafe.UnsafeAllocationManager;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.util.TransferPair;

public class TileDBSQL
implements AutoCloseable {
    private String namespace;
    private SQLParameters sql;
    private TileDBClient tileDBClient;
    private SqlApi apiInstance;
    private ArrayList<VectorSchemaRoot> readBatches;
    private List<Object> results;
    private ArrowStreamReader reader;

    public TileDBSQL(TileDBClient tileDBClient, String namespace, SQLParameters sql) {
        Objects.requireNonNull(tileDBClient, "TileDBClient can not be null");
        Objects.requireNonNull(namespace, "Namespace can not be null");
        Objects.requireNonNull(sql, "SQL parameters can not be null");
        this.namespace = namespace;
        this.sql = sql;
        this.tileDBClient = tileDBClient;
        this.apiInstance = new SqlApi(this.tileDBClient.getApiClient());
        this.readBatches = new ArrayList();
    }

    public Pair<ArrayList<ValueVector>, Integer> execArrow() {
        try {
            if (this.sql.getResultFormat() != ResultFormat.ARROW && this.sql.getResultFormat() != null) {
                throw new ApiException("The ResultFormat you specified is not 'ARROW'. Since you are calling 'execArrow()' you can not specify a different ResultFormat. ");
            }
            this.sql.setResultFormat(ResultFormat.ARROW);
            byte[] bytes = this.apiInstance.runSQLBytes(this.namespace, this.sql, "none");
            ArrayList<ValueVector> valueVectors = null;
            int readBatchesCount = 0;
            RootAllocator allocator = new RootAllocator(RootAllocator.configBuilder().allocationManagerFactory(UnsafeAllocationManager.FACTORY).build());
            ArrowStreamReader reader = new ArrowStreamReader(new ByteArrayInputStream(bytes), (BufferAllocator)allocator, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            while (reader.loadNextBatch()) {
                ++readBatchesCount;
                valueVectors = new ArrayList<ValueVector>();
                for (FieldVector f : root.getFieldVectors()) {
                    TransferPair t = f.getTransferPair(allocator);
                    t.transfer();
                    valueVectors.add(t.getTo());
                }
            }
            reader.close();
            return new Pair<ArrayList<ValueVector>, Integer>(valueVectors, readBatchesCount);
        }
        catch (ApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> exec() {
        try {
            if (this.sql.getResultFormat() == null) {
                return this.apiInstance.runSQL(this.namespace, this.sql, ResultFormat.TILEDB_JSON.toString());
            }
            return this.apiInstance.runSQL(this.namespace, this.sql, this.sql.getResultFormat().toString());
        }
        catch (ApiException e) {
            System.err.println("Exception when calling SqlApi#runSQL/runSQLBytes");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

