/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud;

import io.tiledb.cloud.Pair;
import io.tiledb.cloud.TileDBClient;
import io.tiledb.cloud.TileDBUtils;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.api.UdfApi;
import io.tiledb.cloud.rest_api.model.GenericUDF;
import io.tiledb.cloud.rest_api.model.MultiArrayUDF;
import io.tiledb.cloud.rest_api.model.QueryRanges;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import io.tiledb.cloud.rest_api.model.UDFArrayDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.arrow.vector.ValueVector;
import org.json.JSONArray;
import org.json.JSONObject;

public class TileDBUDF {
    private TileDBClient tileDBClient;
    private String namespace;
    private UdfApi apiInstance;

    public TileDBUDF(TileDBClient tileDBClient, String namespace) {
        this.tileDBClient = tileDBClient;
        this.namespace = namespace;
        this.apiInstance = new UdfApi(this.tileDBClient.getApiClient());
    }

    public String executeGeneric(GenericUDF genericUDF, HashMap<String, Object> arguments) {
        String serializedArgs = TileDBUtils.serializeArgs(arguments);
        genericUDF.setArgument(serializedArgs);
        try {
            return this.apiInstance.submitGenericUDFString(this.namespace, genericUDF, "none");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitGenericUDF");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    public String executeGeneric(GenericUDF genericUDF) {
        try {
            return this.apiInstance.submitGenericUDFString(this.namespace, genericUDF, "none");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitGenericUDF");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject executeGenericJSON(GenericUDF genericUDF, HashMap<String, Object> arguments) {
        genericUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeGeneric(genericUDF, arguments);
        return new JSONObject(jsonString);
    }

    public JSONObject executeGenericJSON(GenericUDF genericUDF) {
        genericUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeGeneric(genericUDF);
        return new JSONObject(jsonString);
    }

    public JSONArray executeGenericJSONArray(GenericUDF genericUDF, HashMap<String, Object> arguments) {
        genericUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeGeneric(genericUDF, arguments);
        return new JSONArray(jsonString);
    }

    public JSONArray executeGenericJSONArray(GenericUDF genericUDF) {
        genericUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeGeneric(genericUDF);
        return new JSONArray(jsonString);
    }

    public Pair<ArrayList<ValueVector>, Integer> executeGenericArrow(GenericUDF genericUDF, HashMap<String, Object> arguments) {
        String serializedArgs = TileDBUtils.serializeArgs(arguments);
        genericUDF.setArgument(serializedArgs);
        genericUDF.setResultFormat(ResultFormat.ARROW);
        try {
            byte[] bytes = this.apiInstance.submitGenericUDFBytes(this.namespace, genericUDF, "none");
            return TileDBUtils.createValueVectors(bytes);
        }
        catch (ApiException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pair<ArrayList<ValueVector>, Integer> executeGenericArrow(GenericUDF genericUDF) {
        genericUDF.setResultFormat(ResultFormat.ARROW);
        try {
            byte[] bytes = this.apiInstance.submitGenericUDFBytes(this.namespace, genericUDF, "none");
            return TileDBUtils.createValueVectors(bytes);
        }
        catch (ApiException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public String executeSingleArray(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments, String arrayURI, String xPayer) {
        String serializedArgs = TileDBUtils.serializeArgs(arguments);
        multiArrayUDF.setArgument(serializedArgs);
        String[] split = this.breakdownFullURI(arrayURI);
        try {
            return this.apiInstance.submitUDFString(split[0], split[1], multiArrayUDF, xPayer, "none", "");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitUDF");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    public String executeSingleArray(GenericUDF genericUDF, UDFArrayDetails array, QueryRanges queryRanges, String xPayer) {
        ArrayList<UDFArrayDetails> arrays = new ArrayList<UDFArrayDetails>();
        arrays.add(array);
        MultiArrayUDF multiArrayUDF = new MultiArrayUDF();
        multiArrayUDF.setArgument(genericUDF.getArgument());
        multiArrayUDF.setUdfInfoName(genericUDF.getUdfInfoName());
        multiArrayUDF.setRanges(queryRanges);
        multiArrayUDF.setArrays(arrays);
        String[] split = this.breakdownFullURI(array.getUri());
        try {
            return this.apiInstance.submitUDFString(split[0], split[1], multiArrayUDF, xPayer, "none", "");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitUDF");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public JSONObject executeSingleArrayJSON(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments, String arrayURI, String xPayer) {
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeSingleArray(multiArrayUDF, arguments, arrayURI, xPayer);
        return new JSONObject(jsonString);
    }

    public JSONObject executeSingleArrayJSON(GenericUDF genericUDF, UDFArrayDetails array, QueryRanges queryRanges, String xPayer) {
        ArrayList<UDFArrayDetails> arrays = new ArrayList<UDFArrayDetails>();
        arrays.add(array);
        MultiArrayUDF multiArrayUDF = new MultiArrayUDF();
        multiArrayUDF.setArgument(genericUDF.getArgument());
        multiArrayUDF.setUdfInfoName(genericUDF.getUdfInfoName());
        multiArrayUDF.setRanges(queryRanges);
        multiArrayUDF.setArrays(arrays);
        String[] split = this.breakdownFullURI(array.getUri());
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String result = "";
        try {
            result = this.apiInstance.submitUDFString(split[0], split[1], multiArrayUDF, xPayer, "none", "");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitUDF");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
        return new JSONObject(result);
    }

    @Deprecated
    public JSONArray executeSingleArrayJSONArray(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments, String arrayURI, String xPayer) {
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeSingleArray(multiArrayUDF, arguments, arrayURI, xPayer);
        return new JSONArray(jsonString);
    }

    public JSONArray executeSingleArrayJSONArray(GenericUDF genericUDF, UDFArrayDetails array, QueryRanges queryRanges, String xPayer) {
        ArrayList<UDFArrayDetails> arrays = new ArrayList<UDFArrayDetails>();
        arrays.add(array);
        MultiArrayUDF multiArrayUDF = new MultiArrayUDF();
        multiArrayUDF.setArgument(genericUDF.getArgument());
        multiArrayUDF.setUdfInfoName(genericUDF.getUdfInfoName());
        multiArrayUDF.setRanges(queryRanges);
        multiArrayUDF.setArrays(arrays);
        String[] split = this.breakdownFullURI(array.getUri());
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String result = "";
        try {
            result = this.apiInstance.submitUDFString(split[0], split[1], multiArrayUDF, xPayer, "none", "");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitUDF");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
        return new JSONArray(result);
    }

    @Deprecated
    public Pair<ArrayList<ValueVector>, Integer> executeSingleArrayArrow(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments, String arrayURI, String xPayer) {
        String serializedArgs = TileDBUtils.serializeArgs(arguments);
        multiArrayUDF.setArgument(serializedArgs);
        multiArrayUDF.setResultFormat(ResultFormat.ARROW);
        String[] split = this.breakdownFullURI(arrayURI);
        try {
            byte[] bytes = this.apiInstance.submitUDFBytes(split[0], split[1], multiArrayUDF, xPayer, "none", "");
            return TileDBUtils.createValueVectors(bytes);
        }
        catch (ApiException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pair<ArrayList<ValueVector>, Integer> executeSingleArrayArrow(GenericUDF genericUDF, UDFArrayDetails array, QueryRanges queryRanges, String xPayer) {
        ArrayList<UDFArrayDetails> arrays = new ArrayList<UDFArrayDetails>();
        arrays.add(array);
        MultiArrayUDF multiArrayUDF = new MultiArrayUDF();
        multiArrayUDF.setArgument(genericUDF.getArgument());
        multiArrayUDF.setResultFormat(ResultFormat.ARROW);
        multiArrayUDF.setUdfInfoName(genericUDF.getUdfInfoName());
        multiArrayUDF.setRanges(queryRanges);
        multiArrayUDF.setArrays(arrays);
        String[] split = this.breakdownFullURI(array.getUri());
        try {
            byte[] bytes = this.apiInstance.submitUDFBytes(split[0], split[1], multiArrayUDF, xPayer, "none", "");
            return TileDBUtils.createValueVectors(bytes);
        }
        catch (ApiException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String executeMultiArray(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments) {
        String serializedArgs = TileDBUtils.serializeArgs(arguments);
        multiArrayUDF.setArgument(serializedArgs);
        try {
            return this.apiInstance.submitMultiArrayUDFString(this.namespace, multiArrayUDF, "none");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitMultiArrayUDFString");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    public String executeMultiArray(MultiArrayUDF multiArrayUDF) {
        try {
            return this.apiInstance.submitMultiArrayUDFString(this.namespace, multiArrayUDF, "none");
        }
        catch (ApiException e) {
            System.err.println("Exception when calling UdfApi#submitMultiArrayUDFString");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject executeMultiArrayJSON(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments) {
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeMultiArray(multiArrayUDF, arguments);
        return new JSONObject(jsonString);
    }

    public JSONObject executeMultiArrayJSON(MultiArrayUDF multiArrayUDF) {
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeMultiArray(multiArrayUDF);
        return new JSONObject(jsonString);
    }

    public JSONArray executeMultiArrayJSONArray(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments) {
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeMultiArray(multiArrayUDF, arguments);
        return new JSONArray(jsonString);
    }

    public JSONArray executeMultiArrayJSONArray(MultiArrayUDF multiArrayUDF) {
        multiArrayUDF.setResultFormat(ResultFormat.JSON);
        String jsonString = this.executeMultiArray(multiArrayUDF);
        return new JSONArray(jsonString);
    }

    public Pair<ArrayList<ValueVector>, Integer> executeMultiArrayArrow(MultiArrayUDF multiArrayUDF, HashMap<String, Object> arguments) {
        String serializedArgs = TileDBUtils.serializeArgs(arguments);
        multiArrayUDF.setArgument(serializedArgs);
        multiArrayUDF.setResultFormat(ResultFormat.ARROW);
        try {
            byte[] bytes = this.apiInstance.submitMultiArrayUDFBytes(this.namespace, multiArrayUDF, "none");
            return TileDBUtils.createValueVectors(bytes);
        }
        catch (ApiException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Pair<ArrayList<ValueVector>, Integer> executeMultiArrayArrow(MultiArrayUDF multiArrayUDF) {
        multiArrayUDF.setResultFormat(ResultFormat.ARROW);
        try {
            byte[] bytes = this.apiInstance.submitMultiArrayUDFBytes(this.namespace, multiArrayUDF, "none");
            return TileDBUtils.createValueVectors(bytes);
        }
        catch (ApiException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] breakdownFullURI(String arrayURI) {
        String[] split = (arrayURI = arrayURI.replaceAll("tiledb://", "")).split("/");
        if (split.length != 2) {
            throw new RuntimeException("TileDB URI is in the wrong format. The format should be: tiledb://namespace/array_name");
        }
        return split;
    }
}

