/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud;

import com.google.gson.Gson;
import io.tiledb.cloud.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.unsafe.UnsafeAllocationManager;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.util.TransferPair;

public class TileDBUtils {
    public static String serializeArgs(HashMap<String, Object> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return "";
        }
        Gson gson = new Gson();
        return gson.toJson(arguments);
    }

    protected static Pair<ArrayList<ValueVector>, Integer> createValueVectors(byte[] bytes) throws IOException {
        ArrayList<ValueVector> valueVectors = null;
        int readBatchesCount = 0;
        RootAllocator allocator = new RootAllocator(RootAllocator.configBuilder().allocationManagerFactory(UnsafeAllocationManager.FACTORY).build());
        ArrowStreamReader reader = new ArrowStreamReader(new ByteArrayInputStream(bytes), (BufferAllocator)allocator, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
        VectorSchemaRoot root = reader.getVectorSchemaRoot();
        while (reader.loadNextBatch()) {
            ++readBatchesCount;
            valueVectors = new ArrayList<ValueVector>();
            for (FieldVector f : root.getFieldVectors()) {
                TransferPair t = f.getTransferPair(allocator);
                t.transfer();
                valueVectors.add(t.getTo());
            }
        }
        reader.close();
        return new Pair<ArrayList<ValueVector>, Integer>(valueVectors, readBatchesCount);
    }
}

