/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import io.tiledb.cloud.rest_api.model.AWSAccessCredentials;
import io.tiledb.cloud.rest_api.model.Array;
import io.tiledb.cloud.rest_api.model.ArrayActivityLog;
import io.tiledb.cloud.rest_api.model.ArrayBrowserData;
import io.tiledb.cloud.rest_api.model.ArrayBrowserSidebar;
import io.tiledb.cloud.rest_api.model.ArrayConsolidationRequest;
import io.tiledb.cloud.rest_api.model.ArrayEndTimestampData;
import io.tiledb.cloud.rest_api.model.ArrayFavorite;
import io.tiledb.cloud.rest_api.model.ArrayFavoritesData;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.ArrayInfoUpdate;
import io.tiledb.cloud.rest_api.model.ArrayMetadata;
import io.tiledb.cloud.rest_api.model.ArrayMetadataEntry;
import io.tiledb.cloud.rest_api.model.ArraySample;
import io.tiledb.cloud.rest_api.model.ArraySchema;
import io.tiledb.cloud.rest_api.model.ArraySharing;
import io.tiledb.cloud.rest_api.model.ArrayTask;
import io.tiledb.cloud.rest_api.model.ArrayTaskBrowserSidebar;
import io.tiledb.cloud.rest_api.model.ArrayTaskData;
import io.tiledb.cloud.rest_api.model.ArrayTaskLog;
import io.tiledb.cloud.rest_api.model.ArrayVacuumRequest;
import io.tiledb.cloud.rest_api.model.AssetLocations;
import io.tiledb.cloud.rest_api.model.Attribute;
import io.tiledb.cloud.rest_api.model.AttributeBufferHeader;
import io.tiledb.cloud.rest_api.model.AttributeBufferSize;
import io.tiledb.cloud.rest_api.model.Backoff;
import io.tiledb.cloud.rest_api.model.Dimension;
import io.tiledb.cloud.rest_api.model.DimensionCoordinate;
import io.tiledb.cloud.rest_api.model.DimensionTileExtent;
import io.tiledb.cloud.rest_api.model.Domain;
import io.tiledb.cloud.rest_api.model.DomainArray;
import io.tiledb.cloud.rest_api.model.DomainCheckResult;
import io.tiledb.cloud.rest_api.model.Error;
import io.tiledb.cloud.rest_api.model.FileCreate;
import io.tiledb.cloud.rest_api.model.FileCreated;
import io.tiledb.cloud.rest_api.model.FileExport;
import io.tiledb.cloud.rest_api.model.FileExported;
import io.tiledb.cloud.rest_api.model.FileUploaded;
import io.tiledb.cloud.rest_api.model.Filter;
import io.tiledb.cloud.rest_api.model.FilterData;
import io.tiledb.cloud.rest_api.model.FilterPipeline;
import io.tiledb.cloud.rest_api.model.FragmentInfo;
import io.tiledb.cloud.rest_api.model.FragmentInfoRequest;
import io.tiledb.cloud.rest_api.model.FragmentMetadata;
import io.tiledb.cloud.rest_api.model.GenericUDF;
import io.tiledb.cloud.rest_api.model.GetTiledbStats200Response;
import io.tiledb.cloud.rest_api.model.GroupActivity;
import io.tiledb.cloud.rest_api.model.GroupActivityAsset;
import io.tiledb.cloud.rest_api.model.GroupActivityResponse;
import io.tiledb.cloud.rest_api.model.GroupBrowserData;
import io.tiledb.cloud.rest_api.model.GroupBrowserFilterData;
import io.tiledb.cloud.rest_api.model.GroupChanges;
import io.tiledb.cloud.rest_api.model.GroupContents;
import io.tiledb.cloud.rest_api.model.GroupContentsFilterData;
import io.tiledb.cloud.rest_api.model.GroupCreate;
import io.tiledb.cloud.rest_api.model.GroupEntry;
import io.tiledb.cloud.rest_api.model.GroupInfo;
import io.tiledb.cloud.rest_api.model.GroupMember;
import io.tiledb.cloud.rest_api.model.GroupRegister;
import io.tiledb.cloud.rest_api.model.GroupSharing;
import io.tiledb.cloud.rest_api.model.GroupSharingRequest;
import io.tiledb.cloud.rest_api.model.GroupUpdate;
import io.tiledb.cloud.rest_api.model.Invitation;
import io.tiledb.cloud.rest_api.model.InvitationArrayShareEmail;
import io.tiledb.cloud.rest_api.model.InvitationData;
import io.tiledb.cloud.rest_api.model.InvitationFailedRecipients;
import io.tiledb.cloud.rest_api.model.InvitationGroupShareEmail;
import io.tiledb.cloud.rest_api.model.InvitationOrganizationJoinEmail;
import io.tiledb.cloud.rest_api.model.LastAccessedArray;
import io.tiledb.cloud.rest_api.model.MLModelFavorite;
import io.tiledb.cloud.rest_api.model.MLModelFavoritesData;
import io.tiledb.cloud.rest_api.model.MaxBufferSizes;
import io.tiledb.cloud.rest_api.model.MultiArrayUDF;
import io.tiledb.cloud.rest_api.model.NonEmptyDomain;
import io.tiledb.cloud.rest_api.model.NotebookCopied;
import io.tiledb.cloud.rest_api.model.NotebookCopy;
import io.tiledb.cloud.rest_api.model.NotebookFavorite;
import io.tiledb.cloud.rest_api.model.NotebookFavoritesData;
import io.tiledb.cloud.rest_api.model.NotebookStatus;
import io.tiledb.cloud.rest_api.model.Organization;
import io.tiledb.cloud.rest_api.model.OrganizationUser;
import io.tiledb.cloud.rest_api.model.PaginationMetadata;
import io.tiledb.cloud.rest_api.model.Pricing;
import io.tiledb.cloud.rest_api.model.Query;
import io.tiledb.cloud.rest_api.model.QueryJson;
import io.tiledb.cloud.rest_api.model.QueryRanges;
import io.tiledb.cloud.rest_api.model.QueryReader;
import io.tiledb.cloud.rest_api.model.ReadState;
import io.tiledb.cloud.rest_api.model.RegisteredTaskGraph;
import io.tiledb.cloud.rest_api.model.ResetUserPasswordRequest;
import io.tiledb.cloud.rest_api.model.RetryStrategy;
import io.tiledb.cloud.rest_api.model.SQLParameters;
import io.tiledb.cloud.rest_api.model.SSODomainConfig;
import io.tiledb.cloud.rest_api.model.SSODomainConfigResponse;
import io.tiledb.cloud.rest_api.model.SSODomainSetup;
import io.tiledb.cloud.rest_api.model.SingleFragmentInfo;
import io.tiledb.cloud.rest_api.model.StorageLocation;
import io.tiledb.cloud.rest_api.model.Subarray;
import io.tiledb.cloud.rest_api.model.SubarrayPartitioner;
import io.tiledb.cloud.rest_api.model.SubarrayPartitionerCurrent;
import io.tiledb.cloud.rest_api.model.SubarrayPartitionerState;
import io.tiledb.cloud.rest_api.model.SubarrayRanges;
import io.tiledb.cloud.rest_api.model.Subscription;
import io.tiledb.cloud.rest_api.model.TGArrayNodeData;
import io.tiledb.cloud.rest_api.model.TGInputNodeData;
import io.tiledb.cloud.rest_api.model.TGQueryRanges;
import io.tiledb.cloud.rest_api.model.TGSQLNodeData;
import io.tiledb.cloud.rest_api.model.TGUDFArgument;
import io.tiledb.cloud.rest_api.model.TGUDFEnvironment;
import io.tiledb.cloud.rest_api.model.TGUDFEnvironmentResources;
import io.tiledb.cloud.rest_api.model.TGUDFNodeData;
import io.tiledb.cloud.rest_api.model.TaskGraph;
import io.tiledb.cloud.rest_api.model.TaskGraphClientNodeStatus;
import io.tiledb.cloud.rest_api.model.TaskGraphLog;
import io.tiledb.cloud.rest_api.model.TaskGraphLogsData;
import io.tiledb.cloud.rest_api.model.TaskGraphNode;
import io.tiledb.cloud.rest_api.model.TaskGraphNodeMetadata;
import io.tiledb.cloud.rest_api.model.TaskGraphSharing;
import io.tiledb.cloud.rest_api.model.TaskGraphs;
import io.tiledb.cloud.rest_api.model.TileDBConfig;
import io.tiledb.cloud.rest_api.model.TileDBConfigEntriesInner;
import io.tiledb.cloud.rest_api.model.Token;
import io.tiledb.cloud.rest_api.model.TokenRequest;
import io.tiledb.cloud.rest_api.model.UDFArrayDetails;
import io.tiledb.cloud.rest_api.model.UDFCopied;
import io.tiledb.cloud.rest_api.model.UDFCopy;
import io.tiledb.cloud.rest_api.model.UDFFavorite;
import io.tiledb.cloud.rest_api.model.UDFFavoritesData;
import io.tiledb.cloud.rest_api.model.UDFImage;
import io.tiledb.cloud.rest_api.model.UDFImageVersion;
import io.tiledb.cloud.rest_api.model.UDFInfo;
import io.tiledb.cloud.rest_api.model.UDFInfoUpdate;
import io.tiledb.cloud.rest_api.model.UDFSharing;
import io.tiledb.cloud.rest_api.model.UDFSubarray;
import io.tiledb.cloud.rest_api.model.UDFSubarrayRange;
import io.tiledb.cloud.rest_api.model.User;
import io.tiledb.cloud.rest_api.model.Writer;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import okio.ByteString;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter;
    private static LocalDateTypeAdapter localDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public JSON() {
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), dateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)java.sql.Date.class), sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)OffsetDateTime.class), offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)LocalDate.class), localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)byte[].class), byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new AWSAccessCredentials.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Array.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayActivityLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayBrowserData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayBrowserSidebar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayConsolidationRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayEndTimestampData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayInfoUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayMetadataEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySample.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySchema.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTask.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTaskBrowserSidebar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTaskData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTaskLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayVacuumRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AssetLocations.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Attribute.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttributeBufferHeader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttributeBufferSize.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Backoff.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Dimension.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DimensionCoordinate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DimensionTileExtent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Domain.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DomainArray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DomainCheckResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileCreated.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileExport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileExported.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileUploaded.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Filter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FilterPipeline.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FragmentInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FragmentInfoRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FragmentMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenericUDF.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetTiledbStats200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupActivity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupActivityAsset.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupActivityResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupBrowserData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupBrowserFilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupChanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContents.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentsFilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupMember.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupRegister.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupSharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupSharingRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Invitation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationArrayShareEmail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationFailedRecipients.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationGroupShareEmail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationOrganizationJoinEmail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new LastAccessedArray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MLModelFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MLModelFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MaxBufferSizes.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MultiArrayUDF.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NonEmptyDomain.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookCopied.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookCopy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Organization.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new OrganizationUser.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PaginationMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Pricing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Query.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryJson.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryRanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryReader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ReadState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RegisteredTaskGraph.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResetUserPasswordRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RetryStrategy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SQLParameters.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SSODomainConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SSODomainConfigResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SSODomainSetup.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SingleFragmentInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new StorageLocation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Subarray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitioner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitionerCurrent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitionerState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayRanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Subscription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGArrayNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGInputNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGQueryRanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGSQLNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFArgument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFEnvironment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFEnvironmentResources.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraph.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphClientNodeStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphLogsData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphNode.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphNodeMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphSharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphs.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TileDBConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TileDBConfigEntriesInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Token.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TokenRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFArrayDetails.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFCopied.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFCopy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFImage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFImageVersion.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFInfoUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFSharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFSubarray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFSubarrayRange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new User.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Writer.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            }
            return gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        localDateTypeAdapter = new LocalDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format(date, true);
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse(date, new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException(e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<java.sql.Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new java.sql.Date(this.dateFormat.parse(date).getTime());
                }
                return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

