/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.ArrayActivityLog;
import io.tiledb.cloud.rest_api.model.ArrayBrowserData;
import io.tiledb.cloud.rest_api.model.ArrayBrowserSidebar;
import io.tiledb.cloud.rest_api.model.ArrayConsolidationRequest;
import io.tiledb.cloud.rest_api.model.ArrayEndTimestampData;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.ArrayInfoUpdate;
import io.tiledb.cloud.rest_api.model.ArrayMetadata;
import io.tiledb.cloud.rest_api.model.ArraySample;
import io.tiledb.cloud.rest_api.model.ArraySchema;
import io.tiledb.cloud.rest_api.model.ArraySharing;
import io.tiledb.cloud.rest_api.model.ArrayVacuumRequest;
import io.tiledb.cloud.rest_api.model.FragmentInfo;
import io.tiledb.cloud.rest_api.model.FragmentInfoRequest;
import io.tiledb.cloud.rest_api.model.LastAccessedArray;
import io.tiledb.cloud.rest_api.model.MaxBufferSizes;
import io.tiledb.cloud.rest_api.model.NonEmptyDomain;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ArrayApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ArrayApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ArrayApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call arrayActivityLogCall(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/activity".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (eventTypes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("event_types", eventTypes));
        }
        if (taskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("task_id", taskId));
        }
        if (hasTaskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("has_task_id", hasTaskId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arrayActivityLogValidateBeforeCall(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling arrayActivityLog(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling arrayActivityLog(Async)");
        }
        Call localVarCall = this.arrayActivityLogCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, _callback);
        return localVarCall;
    }

    public List<ArrayActivityLog> arrayActivityLog(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId) throws ApiException {
        ApiResponse<List<ArrayActivityLog>> localVarResp = this.arrayActivityLogWithHttpInfo(namespace, array, start, end, eventTypes, taskId, hasTaskId);
        return localVarResp.getData();
    }

    public ApiResponse<List<ArrayActivityLog>> arrayActivityLogWithHttpInfo(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId) throws ApiException {
        Call localVarCall = this.arrayActivityLogValidateBeforeCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, null);
        Type localVarReturnType = new TypeToken<List<ArrayActivityLog>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arrayActivityLogAsync(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId, ApiCallback<List<ArrayActivityLog>> _callback) throws ApiException {
        Call localVarCall = this.arrayActivityLogValidateBeforeCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, _callback);
        Type localVarReturnType = new TypeToken<List<ArrayActivityLog>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysBrowserOwnedGetCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/browser/owned";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (permissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", permissions));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysBrowserOwnedGetValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserOwnedGetCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        return localVarCall;
    }

    public ArrayBrowserData arraysBrowserOwnedGet(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        ApiResponse<ArrayBrowserData> localVarResp = this.arraysBrowserOwnedGetWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayBrowserData> arraysBrowserOwnedGetWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        Call localVarCall = this.arraysBrowserOwnedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysBrowserOwnedGetAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback<ArrayBrowserData> _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserOwnedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysBrowserOwnedSidebarGetCall(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/browser/owned/sidebar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysBrowserOwnedSidebarGetValidateBeforeCall(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserOwnedSidebarGetCall(fileType, excludeFileType, fileProperty, _callback);
        return localVarCall;
    }

    public ArrayBrowserSidebar arraysBrowserOwnedSidebarGet(List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        ApiResponse<ArrayBrowserSidebar> localVarResp = this.arraysBrowserOwnedSidebarGetWithHttpInfo(fileType, excludeFileType, fileProperty);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayBrowserSidebar> arraysBrowserOwnedSidebarGetWithHttpInfo(List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        Call localVarCall = this.arraysBrowserOwnedSidebarGetValidateBeforeCall(fileType, excludeFileType, fileProperty, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysBrowserOwnedSidebarGetAsync(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback<ArrayBrowserSidebar> _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserOwnedSidebarGetValidateBeforeCall(fileType, excludeFileType, fileProperty, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysBrowserPublicGetCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/browser/public";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (permissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", permissions));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysBrowserPublicGetValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserPublicGetCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        return localVarCall;
    }

    public ArrayBrowserData arraysBrowserPublicGet(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        ApiResponse<ArrayBrowserData> localVarResp = this.arraysBrowserPublicGetWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayBrowserData> arraysBrowserPublicGetWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        Call localVarCall = this.arraysBrowserPublicGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysBrowserPublicGetAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback<ArrayBrowserData> _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserPublicGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysBrowserPublicSidebarGetCall(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/browser/public/sidebar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysBrowserPublicSidebarGetValidateBeforeCall(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserPublicSidebarGetCall(fileType, excludeFileType, fileProperty, _callback);
        return localVarCall;
    }

    public ArrayBrowserSidebar arraysBrowserPublicSidebarGet(List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        ApiResponse<ArrayBrowserSidebar> localVarResp = this.arraysBrowserPublicSidebarGetWithHttpInfo(fileType, excludeFileType, fileProperty);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayBrowserSidebar> arraysBrowserPublicSidebarGetWithHttpInfo(List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        Call localVarCall = this.arraysBrowserPublicSidebarGetValidateBeforeCall(fileType, excludeFileType, fileProperty, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysBrowserPublicSidebarGetAsync(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, ApiCallback<ArrayBrowserSidebar> _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserPublicSidebarGetValidateBeforeCall(fileType, excludeFileType, fileProperty, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysBrowserSharedGetCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/browser/shared";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (permissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", permissions));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }
        if (sharedTo != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "shared_to", sharedTo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysBrowserSharedGetValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserSharedGetCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo, _callback);
        return localVarCall;
    }

    public ArrayBrowserData arraysBrowserSharedGet(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo) throws ApiException {
        ApiResponse<ArrayBrowserData> localVarResp = this.arraysBrowserSharedGetWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayBrowserData> arraysBrowserSharedGetWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo) throws ApiException {
        Call localVarCall = this.arraysBrowserSharedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysBrowserSharedGetAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, ApiCallback<ArrayBrowserData> _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserSharedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysBrowserSharedSidebarGetCall(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/browser/shared/sidebar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }
        if (sharedTo != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "shared_to", sharedTo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysBrowserSharedSidebarGetValidateBeforeCall(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserSharedSidebarGetCall(fileType, excludeFileType, fileProperty, sharedTo, _callback);
        return localVarCall;
    }

    public ArrayBrowserSidebar arraysBrowserSharedSidebarGet(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo) throws ApiException {
        ApiResponse<ArrayBrowserSidebar> localVarResp = this.arraysBrowserSharedSidebarGetWithHttpInfo(fileType, excludeFileType, fileProperty, sharedTo);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayBrowserSidebar> arraysBrowserSharedSidebarGetWithHttpInfo(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo) throws ApiException {
        Call localVarCall = this.arraysBrowserSharedSidebarGetValidateBeforeCall(fileType, excludeFileType, fileProperty, sharedTo, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysBrowserSharedSidebarGetAsync(List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, ApiCallback<ArrayBrowserSidebar> _callback) throws ApiException {
        Call localVarCall = this.arraysBrowserSharedSidebarGetValidateBeforeCall(fileType, excludeFileType, fileProperty, sharedTo, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call arraysNamespaceArrayEndTimestampsGetCall(String namespace, String array, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/end_timestamps".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arraysNamespaceArrayEndTimestampsGetValidateBeforeCall(String namespace, String array, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling arraysNamespaceArrayEndTimestampsGet(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling arraysNamespaceArrayEndTimestampsGet(Async)");
        }
        Call localVarCall = this.arraysNamespaceArrayEndTimestampsGetCall(namespace, array, page, perPage, _callback);
        return localVarCall;
    }

    public ArrayEndTimestampData arraysNamespaceArrayEndTimestampsGet(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        ApiResponse<ArrayEndTimestampData> localVarResp = this.arraysNamespaceArrayEndTimestampsGetWithHttpInfo(namespace, array, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayEndTimestampData> arraysNamespaceArrayEndTimestampsGetWithHttpInfo(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.arraysNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, null);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arraysNamespaceArrayEndTimestampsGetAsync(String namespace, String array, Integer page, Integer perPage, ApiCallback<ArrayEndTimestampData> _callback) throws ApiException {
        Call localVarCall = this.arraysNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call consolidateArrayCall(String namespace, String array, ArrayConsolidationRequest consolidateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayConsolidationRequest localVarPostBody = consolidateRequest;
        String localVarPath = "/arrays/{namespace}/{array}/consolidate".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call consolidateArrayValidateBeforeCall(String namespace, String array, ArrayConsolidationRequest consolidateRequest, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling consolidateArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling consolidateArray(Async)");
        }
        if (consolidateRequest == null) {
            throw new ApiException("Missing the required parameter 'consolidateRequest' when calling consolidateArray(Async)");
        }
        Call localVarCall = this.consolidateArrayCall(namespace, array, consolidateRequest, _callback);
        return localVarCall;
    }

    public void consolidateArray(String namespace, String array, ArrayConsolidationRequest consolidateRequest) throws ApiException {
        this.consolidateArrayWithHttpInfo(namespace, array, consolidateRequest);
    }

    public ApiResponse<Void> consolidateArrayWithHttpInfo(String namespace, String array, ArrayConsolidationRequest consolidateRequest) throws ApiException {
        Call localVarCall = this.consolidateArrayValidateBeforeCall(namespace, array, consolidateRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call consolidateArrayAsync(String namespace, String array, ArrayConsolidationRequest consolidateRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.consolidateArrayValidateBeforeCall(namespace, array, consolidateRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createArrayCall(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArraySchema localVarPostBody = arraySchema;
        String localVarPath = "/arrays/{namespace}/{array}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createArrayValidateBeforeCall(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling createArray(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling createArray(Async)");
        }
        if (arraySchema == null) {
            throw new ApiException("Missing the required parameter 'arraySchema' when calling createArray(Async)");
        }
        Call localVarCall = this.createArrayCall(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, _callback);
        return localVarCall;
    }

    public void createArray(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME) throws ApiException {
        this.createArrayWithHttpInfo(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME);
    }

    public ApiResponse<Void> createArrayWithHttpInfo(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME) throws ApiException {
        Call localVarCall = this.createArrayValidateBeforeCall(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createArrayAsync(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createArrayValidateBeforeCall(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteArrayCall(String namespace, String array, String contentType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteArrayValidateBeforeCall(String namespace, String array, String contentType, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling deleteArray(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling deleteArray(Async)");
        }
        Call localVarCall = this.deleteArrayCall(namespace, array, contentType, _callback);
        return localVarCall;
    }

    public void deleteArray(String namespace, String array, String contentType) throws ApiException {
        this.deleteArrayWithHttpInfo(namespace, array, contentType);
    }

    public ApiResponse<Void> deleteArrayWithHttpInfo(String namespace, String array, String contentType) throws ApiException {
        Call localVarCall = this.deleteArrayValidateBeforeCall(namespace, array, contentType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteArrayAsync(String namespace, String array, String contentType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteArrayValidateBeforeCall(namespace, array, contentType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deregisterArrayCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/deregister".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deregisterArrayValidateBeforeCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deregisterArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling deregisterArray(Async)");
        }
        Call localVarCall = this.deregisterArrayCall(namespace, array, _callback);
        return localVarCall;
    }

    public void deregisterArray(String namespace, String array) throws ApiException {
        this.deregisterArrayWithHttpInfo(namespace, array);
    }

    public ApiResponse<Void> deregisterArrayWithHttpInfo(String namespace, String array) throws ApiException {
        Call localVarCall = this.deregisterArrayValidateBeforeCall(namespace, array, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deregisterArrayAsync(String namespace, String array, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deregisterArrayValidateBeforeCall(namespace, array, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call fragmentInfoCall(String namespace, String array, String contentType, FragmentInfoRequest fragmentInfoRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FragmentInfoRequest localVarPostBody = fragmentInfoRequest;
        String localVarPath = "/arrays/{namespace}/{array}/fragment_info".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call fragmentInfoValidateBeforeCall(String namespace, String array, String contentType, FragmentInfoRequest fragmentInfoRequest, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling fragmentInfo(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling fragmentInfo(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling fragmentInfo(Async)");
        }
        if (fragmentInfoRequest == null) {
            throw new ApiException("Missing the required parameter 'fragmentInfoRequest' when calling fragmentInfo(Async)");
        }
        Call localVarCall = this.fragmentInfoCall(namespace, array, contentType, fragmentInfoRequest, _callback);
        return localVarCall;
    }

    public FragmentInfo fragmentInfo(String namespace, String array, String contentType, FragmentInfoRequest fragmentInfoRequest) throws ApiException {
        ApiResponse<FragmentInfo> localVarResp = this.fragmentInfoWithHttpInfo(namespace, array, contentType, fragmentInfoRequest);
        return localVarResp.getData();
    }

    public ApiResponse<FragmentInfo> fragmentInfoWithHttpInfo(String namespace, String array, String contentType, FragmentInfoRequest fragmentInfoRequest) throws ApiException {
        Call localVarCall = this.fragmentInfoValidateBeforeCall(namespace, array, contentType, fragmentInfoRequest, null);
        Type localVarReturnType = new TypeToken<FragmentInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call fragmentInfoAsync(String namespace, String array, String contentType, FragmentInfoRequest fragmentInfoRequest, ApiCallback<FragmentInfo> _callback) throws ApiException {
        Call localVarCall = this.fragmentInfoValidateBeforeCall(namespace, array, contentType, fragmentInfoRequest, _callback);
        Type localVarReturnType = new TypeToken<FragmentInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getActivityLogByIdCall(String namespace, String array, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/activity/{id}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getActivityLogByIdValidateBeforeCall(String namespace, String array, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getActivityLogById(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getActivityLogById(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getActivityLogById(Async)");
        }
        Call localVarCall = this.getActivityLogByIdCall(namespace, array, id, _callback);
        return localVarCall;
    }

    public ArrayActivityLog getActivityLogById(String namespace, String array, String id) throws ApiException {
        ApiResponse<ArrayActivityLog> localVarResp = this.getActivityLogByIdWithHttpInfo(namespace, array, id);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayActivityLog> getActivityLogByIdWithHttpInfo(String namespace, String array, String id) throws ApiException {
        Call localVarCall = this.getActivityLogByIdValidateBeforeCall(namespace, array, id, null);
        Type localVarReturnType = new TypeToken<ArrayActivityLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getActivityLogByIdAsync(String namespace, String array, String id, ApiCallback<ArrayActivityLog> _callback) throws ApiException {
        Call localVarCall = this.getActivityLogByIdValidateBeforeCall(namespace, array, id, _callback);
        Type localVarReturnType = new TypeToken<ArrayActivityLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAllArrayMetadataCall(String publicShare, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (publicShare != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("public_share", publicShare));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllArrayMetadataValidateBeforeCall(String publicShare, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllArrayMetadataCall(publicShare, _callback);
        return localVarCall;
    }

    public List<ArrayInfo> getAllArrayMetadata(String publicShare) throws ApiException {
        ApiResponse<List<ArrayInfo>> localVarResp = this.getAllArrayMetadataWithHttpInfo(publicShare);
        return localVarResp.getData();
    }

    public ApiResponse<List<ArrayInfo>> getAllArrayMetadataWithHttpInfo(String publicShare) throws ApiException {
        Call localVarCall = this.getAllArrayMetadataValidateBeforeCall(publicShare, null);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllArrayMetadataAsync(String publicShare, ApiCallback<List<ArrayInfo>> _callback) throws ApiException {
        Call localVarCall = this.getAllArrayMetadataValidateBeforeCall(publicShare, _callback);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayCall(String namespace, String array, String contentType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayValidateBeforeCall(String namespace, String array, String contentType, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArray(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArray(Async)");
        }
        Call localVarCall = this.getArrayCall(namespace, array, contentType, _callback);
        return localVarCall;
    }

    public ArraySchema getArray(String namespace, String array, String contentType) throws ApiException {
        ApiResponse<ArraySchema> localVarResp = this.getArrayWithHttpInfo(namespace, array, contentType);
        return localVarResp.getData();
    }

    public ApiResponse<ArraySchema> getArrayWithHttpInfo(String namespace, String array, String contentType) throws ApiException {
        Call localVarCall = this.getArrayValidateBeforeCall(namespace, array, contentType, null);
        Type localVarReturnType = new TypeToken<ArraySchema>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayAsync(String namespace, String array, String contentType, ApiCallback<ArraySchema> _callback) throws ApiException {
        Call localVarCall = this.getArrayValidateBeforeCall(namespace, array, contentType, _callback);
        Type localVarReturnType = new TypeToken<ArraySchema>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayMaxBufferSizesCall(String namespace, String array, String subarray, String contentType, String xPayer, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/max_buffer_sizes".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (subarray != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subarray", subarray));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayMaxBufferSizesValidateBeforeCall(String namespace, String array, String subarray, String contentType, String xPayer, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMaxBufferSizes(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMaxBufferSizes(Async)");
        }
        if (subarray == null) {
            throw new ApiException("Missing the required parameter 'subarray' when calling getArrayMaxBufferSizes(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArrayMaxBufferSizes(Async)");
        }
        Call localVarCall = this.getArrayMaxBufferSizesCall(namespace, array, subarray, contentType, xPayer, _callback);
        return localVarCall;
    }

    public MaxBufferSizes getArrayMaxBufferSizes(String namespace, String array, String subarray, String contentType, String xPayer) throws ApiException {
        ApiResponse<MaxBufferSizes> localVarResp = this.getArrayMaxBufferSizesWithHttpInfo(namespace, array, subarray, contentType, xPayer);
        return localVarResp.getData();
    }

    public ApiResponse<MaxBufferSizes> getArrayMaxBufferSizesWithHttpInfo(String namespace, String array, String subarray, String contentType, String xPayer) throws ApiException {
        Call localVarCall = this.getArrayMaxBufferSizesValidateBeforeCall(namespace, array, subarray, contentType, xPayer, null);
        Type localVarReturnType = new TypeToken<MaxBufferSizes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayMaxBufferSizesAsync(String namespace, String array, String subarray, String contentType, String xPayer, ApiCallback<MaxBufferSizes> _callback) throws ApiException {
        Call localVarCall = this.getArrayMaxBufferSizesValidateBeforeCall(namespace, array, subarray, contentType, xPayer, _callback);
        Type localVarReturnType = new TypeToken<MaxBufferSizes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayMetaDataJsonCall(String namespace, String array, Integer length, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/metadata_json".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (length != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("length", length));
        }
        if (endTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayMetaDataJsonValidateBeforeCall(String namespace, String array, Integer length, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMetaDataJson(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMetaDataJson(Async)");
        }
        Call localVarCall = this.getArrayMetaDataJsonCall(namespace, array, length, endTimestamp, _callback);
        return localVarCall;
    }

    public Object getArrayMetaDataJson(String namespace, String array, Integer length, Integer endTimestamp) throws ApiException {
        ApiResponse<Object> localVarResp = this.getArrayMetaDataJsonWithHttpInfo(namespace, array, length, endTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getArrayMetaDataJsonWithHttpInfo(String namespace, String array, Integer length, Integer endTimestamp) throws ApiException {
        Call localVarCall = this.getArrayMetaDataJsonValidateBeforeCall(namespace, array, length, endTimestamp, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayMetaDataJsonAsync(String namespace, String array, Integer length, Integer endTimestamp, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getArrayMetaDataJsonValidateBeforeCall(namespace, array, length, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayMetadataCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/metadata".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayMetadataValidateBeforeCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMetadata(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMetadata(Async)");
        }
        Call localVarCall = this.getArrayMetadataCall(namespace, array, _callback);
        return localVarCall;
    }

    public ArrayInfo getArrayMetadata(String namespace, String array) throws ApiException {
        ApiResponse<ArrayInfo> localVarResp = this.getArrayMetadataWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayInfo> getArrayMetadataWithHttpInfo(String namespace, String array) throws ApiException {
        Call localVarCall = this.getArrayMetadataValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayMetadataAsync(String namespace, String array, ApiCallback<ArrayInfo> _callback) throws ApiException {
        Call localVarCall = this.getArrayMetadataValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayMetadataCapnpCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/array_metadata".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/capnp"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayMetadataCapnpValidateBeforeCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMetadataCapnp(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMetadataCapnp(Async)");
        }
        Call localVarCall = this.getArrayMetadataCapnpCall(namespace, array, _callback);
        return localVarCall;
    }

    public ArrayMetadata getArrayMetadataCapnp(String namespace, String array) throws ApiException {
        ApiResponse<ArrayMetadata> localVarResp = this.getArrayMetadataCapnpWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayMetadata> getArrayMetadataCapnpWithHttpInfo(String namespace, String array) throws ApiException {
        Call localVarCall = this.getArrayMetadataCapnpValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<ArrayMetadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayMetadataCapnpAsync(String namespace, String array, ApiCallback<ArrayMetadata> _callback) throws ApiException {
        Call localVarCall = this.getArrayMetadataCapnpValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<ArrayMetadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayNonEmptyDomainCall(String namespace, String array, String contentType, String xPayer, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/non_empty_domain".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayNonEmptyDomainValidateBeforeCall(String namespace, String array, String contentType, String xPayer, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayNonEmptyDomain(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayNonEmptyDomain(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArrayNonEmptyDomain(Async)");
        }
        Call localVarCall = this.getArrayNonEmptyDomainCall(namespace, array, contentType, xPayer, _callback);
        return localVarCall;
    }

    public NonEmptyDomain getArrayNonEmptyDomain(String namespace, String array, String contentType, String xPayer) throws ApiException {
        ApiResponse<NonEmptyDomain> localVarResp = this.getArrayNonEmptyDomainWithHttpInfo(namespace, array, contentType, xPayer);
        return localVarResp.getData();
    }

    public ApiResponse<NonEmptyDomain> getArrayNonEmptyDomainWithHttpInfo(String namespace, String array, String contentType, String xPayer) throws ApiException {
        Call localVarCall = this.getArrayNonEmptyDomainValidateBeforeCall(namespace, array, contentType, xPayer, null);
        Type localVarReturnType = new TypeToken<NonEmptyDomain>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayNonEmptyDomainAsync(String namespace, String array, String contentType, String xPayer, ApiCallback<NonEmptyDomain> _callback) throws ApiException {
        Call localVarCall = this.getArrayNonEmptyDomainValidateBeforeCall(namespace, array, contentType, xPayer, _callback);
        Type localVarReturnType = new TypeToken<NonEmptyDomain>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayNonEmptyDomainJsonCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/non_empty_domain_json".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayNonEmptyDomainJsonValidateBeforeCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayNonEmptyDomainJson(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayNonEmptyDomainJson(Async)");
        }
        Call localVarCall = this.getArrayNonEmptyDomainJsonCall(namespace, array, _callback);
        return localVarCall;
    }

    public Object getArrayNonEmptyDomainJson(String namespace, String array) throws ApiException {
        ApiResponse<Object> localVarResp = this.getArrayNonEmptyDomainJsonWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getArrayNonEmptyDomainJsonWithHttpInfo(String namespace, String array) throws ApiException {
        Call localVarCall = this.getArrayNonEmptyDomainJsonValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayNonEmptyDomainJsonAsync(String namespace, String array, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getArrayNonEmptyDomainJsonValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArraySampleDataCall(String namespace, String array, BigDecimal samples, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/sample".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (samples != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("samples", samples));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArraySampleDataValidateBeforeCall(String namespace, String array, BigDecimal samples, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArraySampleData(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArraySampleData(Async)");
        }
        Call localVarCall = this.getArraySampleDataCall(namespace, array, samples, _callback);
        return localVarCall;
    }

    public ArraySample getArraySampleData(String namespace, String array, BigDecimal samples) throws ApiException {
        ApiResponse<ArraySample> localVarResp = this.getArraySampleDataWithHttpInfo(namespace, array, samples);
        return localVarResp.getData();
    }

    public ApiResponse<ArraySample> getArraySampleDataWithHttpInfo(String namespace, String array, BigDecimal samples) throws ApiException {
        Call localVarCall = this.getArraySampleDataValidateBeforeCall(namespace, array, samples, null);
        Type localVarReturnType = new TypeToken<ArraySample>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArraySampleDataAsync(String namespace, String array, BigDecimal samples, ApiCallback<ArraySample> _callback) throws ApiException {
        Call localVarCall = this.getArraySampleDataValidateBeforeCall(namespace, array, samples, _callback);
        Type localVarReturnType = new TypeToken<ArraySample>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArraySharingPoliciesCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArraySharingPoliciesValidateBeforeCall(String namespace, String array, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArraySharingPolicies(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArraySharingPolicies(Async)");
        }
        Call localVarCall = this.getArraySharingPoliciesCall(namespace, array, _callback);
        return localVarCall;
    }

    public List<ArraySharing> getArraySharingPolicies(String namespace, String array) throws ApiException {
        ApiResponse<List<ArraySharing>> localVarResp = this.getArraySharingPoliciesWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    public ApiResponse<List<ArraySharing>> getArraySharingPoliciesWithHttpInfo(String namespace, String array) throws ApiException {
        Call localVarCall = this.getArraySharingPoliciesValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<List<ArraySharing>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArraySharingPoliciesAsync(String namespace, String array, ApiCallback<List<ArraySharing>> _callback) throws ApiException {
        Call localVarCall = this.getArraySharingPoliciesValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<List<ArraySharing>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArraysInNamespaceCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArraysInNamespaceValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArraysInNamespace(Async)");
        }
        Call localVarCall = this.getArraysInNamespaceCall(namespace, _callback);
        return localVarCall;
    }

    public List<ArrayInfo> getArraysInNamespace(String namespace) throws ApiException {
        ApiResponse<List<ArrayInfo>> localVarResp = this.getArraysInNamespaceWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<List<ArrayInfo>> getArraysInNamespaceWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.getArraysInNamespaceValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArraysInNamespaceAsync(String namespace, ApiCallback<List<ArrayInfo>> _callback) throws ApiException {
        Call localVarCall = this.getArraysInNamespaceValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFragmentEndTimestampCall(String namespace, String array, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/fragment_end_timestamp".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (endTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFragmentEndTimestampValidateBeforeCall(String namespace, String array, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getFragmentEndTimestamp(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getFragmentEndTimestamp(Async)");
        }
        Call localVarCall = this.getFragmentEndTimestampCall(namespace, array, endTimestamp, _callback);
        return localVarCall;
    }

    public Integer getFragmentEndTimestamp(String namespace, String array, Integer endTimestamp) throws ApiException {
        ApiResponse<Integer> localVarResp = this.getFragmentEndTimestampWithHttpInfo(namespace, array, endTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<Integer> getFragmentEndTimestampWithHttpInfo(String namespace, String array, Integer endTimestamp) throws ApiException {
        Call localVarCall = this.getFragmentEndTimestampValidateBeforeCall(namespace, array, endTimestamp, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFragmentEndTimestampAsync(String namespace, String array, Integer endTimestamp, ApiCallback<Integer> _callback) throws ApiException {
        Call localVarCall = this.getFragmentEndTimestampValidateBeforeCall(namespace, array, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLastAccessedArraysCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/last_accessed";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLastAccessedArraysValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getLastAccessedArraysCall(_callback);
        return localVarCall;
    }

    public List<LastAccessedArray> getLastAccessedArrays() throws ApiException {
        ApiResponse<List<LastAccessedArray>> localVarResp = this.getLastAccessedArraysWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<LastAccessedArray>> getLastAccessedArraysWithHttpInfo() throws ApiException {
        Call localVarCall = this.getLastAccessedArraysValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<LastAccessedArray>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLastAccessedArraysAsync(ApiCallback<List<LastAccessedArray>> _callback) throws ApiException {
        Call localVarCall = this.getLastAccessedArraysValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<LastAccessedArray>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call registerArrayCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayInfoUpdate localVarPostBody = arrayMetadata;
        String localVarPath = "/arrays/{namespace}/{array}/register".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call registerArrayValidateBeforeCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling registerArray(Async)");
        }
        if (arrayMetadata == null) {
            throw new ApiException("Missing the required parameter 'arrayMetadata' when calling registerArray(Async)");
        }
        Call localVarCall = this.registerArrayCall(namespace, array, arrayMetadata, _callback);
        return localVarCall;
    }

    public ArrayInfo registerArray(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        ApiResponse<ArrayInfo> localVarResp = this.registerArrayWithHttpInfo(namespace, array, arrayMetadata);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayInfo> registerArrayWithHttpInfo(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        Call localVarCall = this.registerArrayValidateBeforeCall(namespace, array, arrayMetadata, null);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call registerArrayAsync(String namespace, String array, ArrayInfoUpdate arrayMetadata, ApiCallback<ArrayInfo> _callback) throws ApiException {
        Call localVarCall = this.registerArrayValidateBeforeCall(namespace, array, arrayMetadata, _callback);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call shareArrayCall(String namespace, String array, ArraySharing arraySharing, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArraySharing localVarPostBody = arraySharing;
        String localVarPath = "/arrays/{namespace}/{array}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call shareArrayValidateBeforeCall(String namespace, String array, ArraySharing arraySharing, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling shareArray(Async)");
        }
        if (arraySharing == null) {
            throw new ApiException("Missing the required parameter 'arraySharing' when calling shareArray(Async)");
        }
        Call localVarCall = this.shareArrayCall(namespace, array, arraySharing, _callback);
        return localVarCall;
    }

    public void shareArray(String namespace, String array, ArraySharing arraySharing) throws ApiException {
        this.shareArrayWithHttpInfo(namespace, array, arraySharing);
    }

    public ApiResponse<Void> shareArrayWithHttpInfo(String namespace, String array, ArraySharing arraySharing) throws ApiException {
        Call localVarCall = this.shareArrayValidateBeforeCall(namespace, array, arraySharing, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call shareArrayAsync(String namespace, String array, ArraySharing arraySharing, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.shareArrayValidateBeforeCall(namespace, array, arraySharing, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateArrayMetadataCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayInfoUpdate localVarPostBody = arrayMetadata;
        String localVarPath = "/arrays/{namespace}/{array}/metadata".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateArrayMetadataValidateBeforeCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateArrayMetadata(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling updateArrayMetadata(Async)");
        }
        if (arrayMetadata == null) {
            throw new ApiException("Missing the required parameter 'arrayMetadata' when calling updateArrayMetadata(Async)");
        }
        Call localVarCall = this.updateArrayMetadataCall(namespace, array, arrayMetadata, _callback);
        return localVarCall;
    }

    public void updateArrayMetadata(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        this.updateArrayMetadataWithHttpInfo(namespace, array, arrayMetadata);
    }

    public ApiResponse<Void> updateArrayMetadataWithHttpInfo(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        Call localVarCall = this.updateArrayMetadataValidateBeforeCall(namespace, array, arrayMetadata, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateArrayMetadataAsync(String namespace, String array, ArrayInfoUpdate arrayMetadata, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateArrayMetadataValidateBeforeCall(namespace, array, arrayMetadata, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateArrayMetadataCapnpCall(String namespace, String array, ArrayMetadata arrayMetadataEntries, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayMetadata localVarPostBody = arrayMetadataEntries;
        String localVarPath = "/arrays/{namespace}/{array}/array_metadata".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/capnp"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateArrayMetadataCapnpValidateBeforeCall(String namespace, String array, ArrayMetadata arrayMetadataEntries, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateArrayMetadataCapnp(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling updateArrayMetadataCapnp(Async)");
        }
        if (arrayMetadataEntries == null) {
            throw new ApiException("Missing the required parameter 'arrayMetadataEntries' when calling updateArrayMetadataCapnp(Async)");
        }
        Call localVarCall = this.updateArrayMetadataCapnpCall(namespace, array, arrayMetadataEntries, _callback);
        return localVarCall;
    }

    public void updateArrayMetadataCapnp(String namespace, String array, ArrayMetadata arrayMetadataEntries) throws ApiException {
        this.updateArrayMetadataCapnpWithHttpInfo(namespace, array, arrayMetadataEntries);
    }

    public ApiResponse<Void> updateArrayMetadataCapnpWithHttpInfo(String namespace, String array, ArrayMetadata arrayMetadataEntries) throws ApiException {
        Call localVarCall = this.updateArrayMetadataCapnpValidateBeforeCall(namespace, array, arrayMetadataEntries, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateArrayMetadataCapnpAsync(String namespace, String array, ArrayMetadata arrayMetadataEntries, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateArrayMetadataCapnpValidateBeforeCall(namespace, array, arrayMetadataEntries, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call vacuumArrayCall(String namespace, String array, ArrayVacuumRequest vaccumRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayVacuumRequest localVarPostBody = vaccumRequest;
        String localVarPath = "/arrays/{namespace}/{array}/vacuum".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call vacuumArrayValidateBeforeCall(String namespace, String array, ArrayVacuumRequest vaccumRequest, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling vacuumArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling vacuumArray(Async)");
        }
        if (vaccumRequest == null) {
            throw new ApiException("Missing the required parameter 'vaccumRequest' when calling vacuumArray(Async)");
        }
        Call localVarCall = this.vacuumArrayCall(namespace, array, vaccumRequest, _callback);
        return localVarCall;
    }

    public void vacuumArray(String namespace, String array, ArrayVacuumRequest vaccumRequest) throws ApiException {
        this.vacuumArrayWithHttpInfo(namespace, array, vaccumRequest);
    }

    public ApiResponse<Void> vacuumArrayWithHttpInfo(String namespace, String array, ArrayVacuumRequest vaccumRequest) throws ApiException {
        Call localVarCall = this.vacuumArrayValidateBeforeCall(namespace, array, vaccumRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call vacuumArrayAsync(String namespace, String array, ArrayVacuumRequest vaccumRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.vacuumArrayValidateBeforeCall(namespace, array, vaccumRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

