/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.GroupActivityResponse;
import io.tiledb.cloud.rest_api.model.GroupBrowserData;
import io.tiledb.cloud.rest_api.model.GroupBrowserFilterData;
import io.tiledb.cloud.rest_api.model.GroupChanges;
import io.tiledb.cloud.rest_api.model.GroupContents;
import io.tiledb.cloud.rest_api.model.GroupContentsFilterData;
import io.tiledb.cloud.rest_api.model.GroupCreate;
import io.tiledb.cloud.rest_api.model.GroupInfo;
import io.tiledb.cloud.rest_api.model.GroupRegister;
import io.tiledb.cloud.rest_api.model.GroupSharing;
import io.tiledb.cloud.rest_api.model.GroupSharingRequest;
import io.tiledb.cloud.rest_api.model.GroupUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class GroupsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call changeGroupContentsCall(String groupNamespace, String groupName, GroupChanges groupChanges, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupChanges localVarPostBody = groupChanges;
        String localVarPath = "/groups/{group_namespace}/{group_name}/contents".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call changeGroupContentsValidateBeforeCall(String groupNamespace, String groupName, GroupChanges groupChanges, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling changeGroupContents(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling changeGroupContents(Async)");
        }
        Call localVarCall = this.changeGroupContentsCall(groupNamespace, groupName, groupChanges, _callback);
        return localVarCall;
    }

    public void changeGroupContents(String groupNamespace, String groupName, GroupChanges groupChanges) throws ApiException {
        this.changeGroupContentsWithHttpInfo(groupNamespace, groupName, groupChanges);
    }

    public ApiResponse<Void> changeGroupContentsWithHttpInfo(String groupNamespace, String groupName, GroupChanges groupChanges) throws ApiException {
        Call localVarCall = this.changeGroupContentsValidateBeforeCall(groupNamespace, groupName, groupChanges, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call changeGroupContentsAsync(String groupNamespace, String groupName, GroupChanges groupChanges, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.changeGroupContentsValidateBeforeCall(groupNamespace, groupName, groupChanges, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createGroupCall(String namespace, GroupCreate groupCreate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupCreate localVarPostBody = groupCreate;
        String localVarPath = "/groups/{namespace}/create".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupValidateBeforeCall(String namespace, GroupCreate groupCreate, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createGroup(Async)");
        }
        Call localVarCall = this.createGroupCall(namespace, groupCreate, _callback);
        return localVarCall;
    }

    public void createGroup(String namespace, GroupCreate groupCreate) throws ApiException {
        this.createGroupWithHttpInfo(namespace, groupCreate);
    }

    public ApiResponse<Void> createGroupWithHttpInfo(String namespace, GroupCreate groupCreate) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(namespace, groupCreate, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createGroupAsync(String namespace, GroupCreate groupCreate, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(namespace, groupCreate, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteGroupCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling deleteGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling deleteGroup(Async)");
        }
        Call localVarCall = this.deleteGroupCall(groupNamespace, groupName, _callback);
        return localVarCall;
    }

    public void deleteGroup(String groupNamespace, String groupName) throws ApiException {
        this.deleteGroupWithHttpInfo(groupNamespace, groupName);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupNamespace, groupName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupAsync(String groupNamespace, String groupName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupNamespace, groupName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getGroupCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupValidateBeforeCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroup(Async)");
        }
        Call localVarCall = this.getGroupCall(groupNamespace, groupName, _callback);
        return localVarCall;
    }

    public GroupInfo getGroup(String groupNamespace, String groupName) throws ApiException {
        ApiResponse<GroupInfo> localVarResp = this.getGroupWithHttpInfo(groupNamespace, groupName);
        return localVarResp.getData();
    }

    public ApiResponse<GroupInfo> getGroupWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupNamespace, groupName, null);
        Type localVarReturnType = new TypeToken<GroupInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupAsync(String groupNamespace, String groupName, ApiCallback<GroupInfo> _callback) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupNamespace, groupName, _callback);
        Type localVarReturnType = new TypeToken<GroupInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupActivityCall(String groupNamespace, String groupName, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}/content_activity".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupActivityValidateBeforeCall(String groupNamespace, String groupName, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupActivity(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupActivity(Async)");
        }
        Call localVarCall = this.getGroupActivityCall(groupNamespace, groupName, page, perPage, _callback);
        return localVarCall;
    }

    public GroupActivityResponse getGroupActivity(String groupNamespace, String groupName, Integer page, Integer perPage) throws ApiException {
        ApiResponse<GroupActivityResponse> localVarResp = this.getGroupActivityWithHttpInfo(groupNamespace, groupName, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<GroupActivityResponse> getGroupActivityWithHttpInfo(String groupNamespace, String groupName, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.getGroupActivityValidateBeforeCall(groupNamespace, groupName, page, perPage, null);
        Type localVarReturnType = new TypeToken<GroupActivityResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupActivityAsync(String groupNamespace, String groupName, Integer page, Integer perPage, ApiCallback<GroupActivityResponse> _callback) throws ApiException {
        Call localVarCall = this.getGroupActivityValidateBeforeCall(groupNamespace, groupName, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<GroupActivityResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupContentsCall(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}/contents".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (memberType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "member_type", memberType));
        }
        if (excludeMemberType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_member_type", excludeMemberType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupContentsValidateBeforeCall(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupContents(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupContents(Async)");
        }
        Call localVarCall = this.getGroupContentsCall(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType, _callback);
        return localVarCall;
    }

    public GroupContents getGroupContents(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType) throws ApiException {
        ApiResponse<GroupContents> localVarResp = this.getGroupContentsWithHttpInfo(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContents> getGroupContentsWithHttpInfo(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType) throws ApiException {
        Call localVarCall = this.getGroupContentsValidateBeforeCall(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType, null);
        Type localVarReturnType = new TypeToken<GroupContents>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupContentsAsync(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType, ApiCallback<GroupContents> _callback) throws ApiException {
        Call localVarCall = this.getGroupContentsValidateBeforeCall(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType, _callback);
        Type localVarReturnType = new TypeToken<GroupContents>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupSharingPoliciesCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}/share".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupSharingPoliciesValidateBeforeCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupSharingPolicies(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupSharingPolicies(Async)");
        }
        Call localVarCall = this.getGroupSharingPoliciesCall(groupNamespace, groupName, _callback);
        return localVarCall;
    }

    public List<GroupSharing> getGroupSharingPolicies(String groupNamespace, String groupName) throws ApiException {
        ApiResponse<List<GroupSharing>> localVarResp = this.getGroupSharingPoliciesWithHttpInfo(groupNamespace, groupName);
        return localVarResp.getData();
    }

    public ApiResponse<List<GroupSharing>> getGroupSharingPoliciesWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        Call localVarCall = this.getGroupSharingPoliciesValidateBeforeCall(groupNamespace, groupName, null);
        Type localVarReturnType = new TypeToken<List<GroupSharing>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupSharingPoliciesAsync(String groupNamespace, String groupName, ApiCallback<List<GroupSharing>> _callback) throws ApiException {
        Call localVarCall = this.getGroupSharingPoliciesValidateBeforeCall(groupNamespace, groupName, _callback);
        Type localVarReturnType = new TypeToken<List<GroupSharing>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call groupsBrowserOwnedFiltersGetCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/browser/owned/filters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call groupsBrowserOwnedFiltersGetValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.groupsBrowserOwnedFiltersGetCall(namespace, _callback);
        return localVarCall;
    }

    public GroupBrowserFilterData groupsBrowserOwnedFiltersGet(String namespace) throws ApiException {
        ApiResponse<GroupBrowserFilterData> localVarResp = this.groupsBrowserOwnedFiltersGetWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<GroupBrowserFilterData> groupsBrowserOwnedFiltersGetWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.groupsBrowserOwnedFiltersGetValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call groupsBrowserOwnedFiltersGetAsync(String namespace, ApiCallback<GroupBrowserFilterData> _callback) throws ApiException {
        Call localVarCall = this.groupsBrowserOwnedFiltersGetValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call groupsBrowserPublicFiltersGetCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/browser/public/filters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call groupsBrowserPublicFiltersGetValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.groupsBrowserPublicFiltersGetCall(_callback);
        return localVarCall;
    }

    public GroupBrowserFilterData groupsBrowserPublicFiltersGet() throws ApiException {
        ApiResponse<GroupBrowserFilterData> localVarResp = this.groupsBrowserPublicFiltersGetWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<GroupBrowserFilterData> groupsBrowserPublicFiltersGetWithHttpInfo() throws ApiException {
        Call localVarCall = this.groupsBrowserPublicFiltersGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call groupsBrowserPublicFiltersGetAsync(ApiCallback<GroupBrowserFilterData> _callback) throws ApiException {
        Call localVarCall = this.groupsBrowserPublicFiltersGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call groupsBrowserSharedFiltersGetCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/browser/shared/filters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call groupsBrowserSharedFiltersGetValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.groupsBrowserSharedFiltersGetCall(namespace, _callback);
        return localVarCall;
    }

    public GroupBrowserFilterData groupsBrowserSharedFiltersGet(String namespace) throws ApiException {
        ApiResponse<GroupBrowserFilterData> localVarResp = this.groupsBrowserSharedFiltersGetWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<GroupBrowserFilterData> groupsBrowserSharedFiltersGetWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.groupsBrowserSharedFiltersGetValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call groupsBrowserSharedFiltersGetAsync(String namespace, ApiCallback<GroupBrowserFilterData> _callback) throws ApiException {
        Call localVarCall = this.groupsBrowserSharedFiltersGetValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call groupsGroupNamespaceGroupNameContentsFiltersGetCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}/contents/filters".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call groupsGroupNamespaceGroupNameContentsFiltersGetValidateBeforeCall(String groupNamespace, String groupName, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling groupsGroupNamespaceGroupNameContentsFiltersGet(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling groupsGroupNamespaceGroupNameContentsFiltersGet(Async)");
        }
        Call localVarCall = this.groupsGroupNamespaceGroupNameContentsFiltersGetCall(groupNamespace, groupName, _callback);
        return localVarCall;
    }

    public GroupContentsFilterData groupsGroupNamespaceGroupNameContentsFiltersGet(String groupNamespace, String groupName) throws ApiException {
        ApiResponse<GroupContentsFilterData> localVarResp = this.groupsGroupNamespaceGroupNameContentsFiltersGetWithHttpInfo(groupNamespace, groupName);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContentsFilterData> groupsGroupNamespaceGroupNameContentsFiltersGetWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        Call localVarCall = this.groupsGroupNamespaceGroupNameContentsFiltersGetValidateBeforeCall(groupNamespace, groupName, null);
        Type localVarReturnType = new TypeToken<GroupContentsFilterData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call groupsGroupNamespaceGroupNameContentsFiltersGetAsync(String groupNamespace, String groupName, ApiCallback<GroupContentsFilterData> _callback) throws ApiException {
        Call localVarCall = this.groupsGroupNamespaceGroupNameContentsFiltersGetValidateBeforeCall(groupNamespace, groupName, _callback);
        Type localVarReturnType = new TypeToken<GroupContentsFilterData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listOwnedGroupsCall(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/browser/owned";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (groupType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("group_type", groupType));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (permissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", permissions));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (flat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flat", flat));
        }
        if (parent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parent", parent));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOwnedGroupsValidateBeforeCall(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOwnedGroupsCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        return localVarCall;
    }

    public GroupBrowserData listOwnedGroups(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        ApiResponse<GroupBrowserData> localVarResp = this.listOwnedGroupsWithHttpInfo(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent);
        return localVarResp.getData();
    }

    public ApiResponse<GroupBrowserData> listOwnedGroupsWithHttpInfo(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        Call localVarCall = this.listOwnedGroupsValidateBeforeCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, null);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOwnedGroupsAsync(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, ApiCallback<GroupBrowserData> _callback) throws ApiException {
        Call localVarCall = this.listOwnedGroupsValidateBeforeCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listPublicGroupsCall(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/browser/public";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (groupType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("group_type", groupType));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (permissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", permissions));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (flat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flat", flat));
        }
        if (parent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parent", parent));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPublicGroupsValidateBeforeCall(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listPublicGroupsCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        return localVarCall;
    }

    public GroupBrowserData listPublicGroups(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        ApiResponse<GroupBrowserData> localVarResp = this.listPublicGroupsWithHttpInfo(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent);
        return localVarResp.getData();
    }

    public ApiResponse<GroupBrowserData> listPublicGroupsWithHttpInfo(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        Call localVarCall = this.listPublicGroupsValidateBeforeCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, null);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listPublicGroupsAsync(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, ApiCallback<GroupBrowserData> _callback) throws ApiException {
        Call localVarCall = this.listPublicGroupsValidateBeforeCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSharedGroupsCall(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/browser/shared";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (groupType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("group_type", groupType));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if (permissions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", permissions));
        }
        if (tag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tag", tag));
        }
        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }
        if (flat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flat", flat));
        }
        if (parent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parent", parent));
        }
        if (sharedTo != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "shared_to", sharedTo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSharedGroupsValidateBeforeCall(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSharedGroupsCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo, _callback);
        return localVarCall;
    }

    public GroupBrowserData listSharedGroups(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo) throws ApiException {
        ApiResponse<GroupBrowserData> localVarResp = this.listSharedGroupsWithHttpInfo(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo);
        return localVarResp.getData();
    }

    public ApiResponse<GroupBrowserData> listSharedGroupsWithHttpInfo(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo) throws ApiException {
        Call localVarCall = this.listSharedGroupsValidateBeforeCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo, null);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSharedGroupsAsync(Integer page, Integer perPage, String groupType, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo, ApiCallback<GroupBrowserData> _callback) throws ApiException {
        Call localVarCall = this.listSharedGroupsValidateBeforeCall(page, perPage, groupType, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call registerGroupCall(String namespace, String array, GroupRegister groupRegister, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupRegister localVarPostBody = groupRegister;
        String localVarPath = "/groups/{namespace}/{array}/register".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call registerGroupValidateBeforeCall(String namespace, String array, GroupRegister groupRegister, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerGroup(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling registerGroup(Async)");
        }
        Call localVarCall = this.registerGroupCall(namespace, array, groupRegister, _callback);
        return localVarCall;
    }

    public void registerGroup(String namespace, String array, GroupRegister groupRegister) throws ApiException {
        this.registerGroupWithHttpInfo(namespace, array, groupRegister);
    }

    public ApiResponse<Void> registerGroupWithHttpInfo(String namespace, String array, GroupRegister groupRegister) throws ApiException {
        Call localVarCall = this.registerGroupValidateBeforeCall(namespace, array, groupRegister, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call registerGroupAsync(String namespace, String array, GroupRegister groupRegister, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.registerGroupValidateBeforeCall(namespace, array, groupRegister, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call shareGroupCall(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupSharingRequest localVarPostBody = groupSharingRequest;
        String localVarPath = "/groups/{group_namespace}/{group_name}/share".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call shareGroupValidateBeforeCall(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling shareGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling shareGroup(Async)");
        }
        if (groupSharingRequest == null) {
            throw new ApiException("Missing the required parameter 'groupSharingRequest' when calling shareGroup(Async)");
        }
        Call localVarCall = this.shareGroupCall(groupNamespace, groupName, groupSharingRequest, _callback);
        return localVarCall;
    }

    public void shareGroup(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest) throws ApiException {
        this.shareGroupWithHttpInfo(groupNamespace, groupName, groupSharingRequest);
    }

    public ApiResponse<Void> shareGroupWithHttpInfo(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest) throws ApiException {
        Call localVarCall = this.shareGroupValidateBeforeCall(groupNamespace, groupName, groupSharingRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call shareGroupAsync(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.shareGroupValidateBeforeCall(groupNamespace, groupName, groupSharingRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateGroupCall(String groupNamespace, String groupName, GroupUpdate groupUpdate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupUpdate localVarPostBody = groupUpdate;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateGroupValidateBeforeCall(String groupNamespace, String groupName, GroupUpdate groupUpdate, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling updateGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling updateGroup(Async)");
        }
        Call localVarCall = this.updateGroupCall(groupNamespace, groupName, groupUpdate, _callback);
        return localVarCall;
    }

    public void updateGroup(String groupNamespace, String groupName, GroupUpdate groupUpdate) throws ApiException {
        this.updateGroupWithHttpInfo(groupNamespace, groupName, groupUpdate);
    }

    public ApiResponse<Void> updateGroupWithHttpInfo(String groupNamespace, String groupName, GroupUpdate groupUpdate) throws ApiException {
        Call localVarCall = this.updateGroupValidateBeforeCall(groupNamespace, groupName, groupUpdate, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateGroupAsync(String groupNamespace, String groupName, GroupUpdate groupUpdate, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateGroupValidateBeforeCall(groupNamespace, groupName, groupUpdate, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

