/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.InvitationArrayShareEmail;
import io.tiledb.cloud.rest_api.model.InvitationData;
import io.tiledb.cloud.rest_api.model.InvitationGroupShareEmail;
import io.tiledb.cloud.rest_api.model.InvitationOrganizationJoinEmail;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class InvitationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InvitationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvitationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call acceptInvitationCall(String invitation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invitations/{invitation}".replaceAll("\\{invitation\\}", this.localVarApiClient.escapeString(invitation.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call acceptInvitationValidateBeforeCall(String invitation, ApiCallback _callback) throws ApiException {
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling acceptInvitation(Async)");
        }
        Call localVarCall = this.acceptInvitationCall(invitation, _callback);
        return localVarCall;
    }

    public void acceptInvitation(String invitation) throws ApiException {
        this.acceptInvitationWithHttpInfo(invitation);
    }

    public ApiResponse<Void> acceptInvitationWithHttpInfo(String invitation) throws ApiException {
        Call localVarCall = this.acceptInvitationValidateBeforeCall(invitation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call acceptInvitationAsync(String invitation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.acceptInvitationValidateBeforeCall(invitation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call cancelJoinOrganizationCall(String invitation, String organization, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invitations/{invitation}/{organization}/join".replaceAll("\\{invitation\\}", this.localVarApiClient.escapeString(invitation.toString())).replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelJoinOrganizationValidateBeforeCall(String invitation, String organization, ApiCallback _callback) throws ApiException {
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling cancelJoinOrganization(Async)");
        }
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling cancelJoinOrganization(Async)");
        }
        Call localVarCall = this.cancelJoinOrganizationCall(invitation, organization, _callback);
        return localVarCall;
    }

    public void cancelJoinOrganization(String invitation, String organization) throws ApiException {
        this.cancelJoinOrganizationWithHttpInfo(invitation, organization);
    }

    public ApiResponse<Void> cancelJoinOrganizationWithHttpInfo(String invitation, String organization) throws ApiException {
        Call localVarCall = this.cancelJoinOrganizationValidateBeforeCall(invitation, organization, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call cancelJoinOrganizationAsync(String invitation, String organization, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.cancelJoinOrganizationValidateBeforeCall(invitation, organization, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call cancelShareArrayByInviteCall(String namespace, String invitation, String array, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invitations/{invitation}/{namespace}/{array}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{invitation\\}", this.localVarApiClient.escapeString(invitation.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelShareArrayByInviteValidateBeforeCall(String namespace, String invitation, String array, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling cancelShareArrayByInvite(Async)");
        }
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling cancelShareArrayByInvite(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling cancelShareArrayByInvite(Async)");
        }
        Call localVarCall = this.cancelShareArrayByInviteCall(namespace, invitation, array, _callback);
        return localVarCall;
    }

    public void cancelShareArrayByInvite(String namespace, String invitation, String array) throws ApiException {
        this.cancelShareArrayByInviteWithHttpInfo(namespace, invitation, array);
    }

    public ApiResponse<Void> cancelShareArrayByInviteWithHttpInfo(String namespace, String invitation, String array) throws ApiException {
        Call localVarCall = this.cancelShareArrayByInviteValidateBeforeCall(namespace, invitation, array, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call cancelShareArrayByInviteAsync(String namespace, String invitation, String array, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.cancelShareArrayByInviteValidateBeforeCall(namespace, invitation, array, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call cancelShareGroupByInviteCall(String namespace, String invitation, String groupName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invitations/group/{invitation}/{namespace}/{group_name}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{invitation\\}", this.localVarApiClient.escapeString(invitation.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelShareGroupByInviteValidateBeforeCall(String namespace, String invitation, String groupName, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling cancelShareGroupByInvite(Async)");
        }
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling cancelShareGroupByInvite(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling cancelShareGroupByInvite(Async)");
        }
        Call localVarCall = this.cancelShareGroupByInviteCall(namespace, invitation, groupName, _callback);
        return localVarCall;
    }

    public void cancelShareGroupByInvite(String namespace, String invitation, String groupName) throws ApiException {
        this.cancelShareGroupByInviteWithHttpInfo(namespace, invitation, groupName);
    }

    public ApiResponse<Void> cancelShareGroupByInviteWithHttpInfo(String namespace, String invitation, String groupName) throws ApiException {
        Call localVarCall = this.cancelShareGroupByInviteValidateBeforeCall(namespace, invitation, groupName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call cancelShareGroupByInviteAsync(String namespace, String invitation, String groupName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.cancelShareGroupByInviteValidateBeforeCall(namespace, invitation, groupName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call fetchInvitationsCall(String organization, String array, String group, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invitations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (organization != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("organization", organization));
        }
        if (array != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("array", array));
        }
        if (group != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("group", group));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call fetchInvitationsValidateBeforeCall(String organization, String array, String group, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.fetchInvitationsCall(organization, array, group, start, end, page, perPage, type, status, orderby, _callback);
        return localVarCall;
    }

    public InvitationData fetchInvitations(String organization, String array, String group, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby) throws ApiException {
        ApiResponse<InvitationData> localVarResp = this.fetchInvitationsWithHttpInfo(organization, array, group, start, end, page, perPage, type, status, orderby);
        return localVarResp.getData();
    }

    public ApiResponse<InvitationData> fetchInvitationsWithHttpInfo(String organization, String array, String group, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby) throws ApiException {
        Call localVarCall = this.fetchInvitationsValidateBeforeCall(organization, array, group, start, end, page, perPage, type, status, orderby, null);
        Type localVarReturnType = new TypeToken<InvitationData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call fetchInvitationsAsync(String organization, String array, String group, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby, ApiCallback<InvitationData> _callback) throws ApiException {
        Call localVarCall = this.fetchInvitationsValidateBeforeCall(organization, array, group, start, end, page, perPage, type, status, orderby, _callback);
        Type localVarReturnType = new TypeToken<InvitationData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call joinOrganizationCall(String organization, InvitationOrganizationJoinEmail emailInvite, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InvitationOrganizationJoinEmail localVarPostBody = emailInvite;
        String localVarPath = "/invitations/{organization}/join".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call joinOrganizationValidateBeforeCall(String organization, InvitationOrganizationJoinEmail emailInvite, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling joinOrganization(Async)");
        }
        if (emailInvite == null) {
            throw new ApiException("Missing the required parameter 'emailInvite' when calling joinOrganization(Async)");
        }
        Call localVarCall = this.joinOrganizationCall(organization, emailInvite, _callback);
        return localVarCall;
    }

    public void joinOrganization(String organization, InvitationOrganizationJoinEmail emailInvite) throws ApiException {
        this.joinOrganizationWithHttpInfo(organization, emailInvite);
    }

    public ApiResponse<Void> joinOrganizationWithHttpInfo(String organization, InvitationOrganizationJoinEmail emailInvite) throws ApiException {
        Call localVarCall = this.joinOrganizationValidateBeforeCall(organization, emailInvite, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call joinOrganizationAsync(String organization, InvitationOrganizationJoinEmail emailInvite, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.joinOrganizationValidateBeforeCall(organization, emailInvite, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call shareArrayByInviteCall(String namespace, String array, InvitationArrayShareEmail emailInvite, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InvitationArrayShareEmail localVarPostBody = emailInvite;
        String localVarPath = "/invitations/{namespace}/{array}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call shareArrayByInviteValidateBeforeCall(String namespace, String array, InvitationArrayShareEmail emailInvite, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareArrayByInvite(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling shareArrayByInvite(Async)");
        }
        if (emailInvite == null) {
            throw new ApiException("Missing the required parameter 'emailInvite' when calling shareArrayByInvite(Async)");
        }
        Call localVarCall = this.shareArrayByInviteCall(namespace, array, emailInvite, _callback);
        return localVarCall;
    }

    public void shareArrayByInvite(String namespace, String array, InvitationArrayShareEmail emailInvite) throws ApiException {
        this.shareArrayByInviteWithHttpInfo(namespace, array, emailInvite);
    }

    public ApiResponse<Void> shareArrayByInviteWithHttpInfo(String namespace, String array, InvitationArrayShareEmail emailInvite) throws ApiException {
        Call localVarCall = this.shareArrayByInviteValidateBeforeCall(namespace, array, emailInvite, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call shareArrayByInviteAsync(String namespace, String array, InvitationArrayShareEmail emailInvite, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.shareArrayByInviteValidateBeforeCall(namespace, array, emailInvite, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call shareGroupByInviteCall(String namespace, String group, InvitationGroupShareEmail emailInvite, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InvitationGroupShareEmail localVarPostBody = emailInvite;
        String localVarPath = "/invitations/group/{namespace}/{group}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{group\\}", this.localVarApiClient.escapeString(group.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call shareGroupByInviteValidateBeforeCall(String namespace, String group, InvitationGroupShareEmail emailInvite, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareGroupByInvite(Async)");
        }
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling shareGroupByInvite(Async)");
        }
        if (emailInvite == null) {
            throw new ApiException("Missing the required parameter 'emailInvite' when calling shareGroupByInvite(Async)");
        }
        Call localVarCall = this.shareGroupByInviteCall(namespace, group, emailInvite, _callback);
        return localVarCall;
    }

    public void shareGroupByInvite(String namespace, String group, InvitationGroupShareEmail emailInvite) throws ApiException {
        this.shareGroupByInviteWithHttpInfo(namespace, group, emailInvite);
    }

    public ApiResponse<Void> shareGroupByInviteWithHttpInfo(String namespace, String group, InvitationGroupShareEmail emailInvite) throws ApiException {
        Call localVarCall = this.shareGroupByInviteValidateBeforeCall(namespace, group, emailInvite, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call shareGroupByInviteAsync(String namespace, String group, InvitationGroupShareEmail emailInvite, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.shareGroupByInviteValidateBeforeCall(namespace, group, emailInvite, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

