/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.ArrayInfoUpdate;
import io.tiledb.cloud.rest_api.model.FileUploaded;
import io.tiledb.cloud.rest_api.model.NotebookCopied;
import io.tiledb.cloud.rest_api.model.NotebookCopy;
import io.tiledb.cloud.rest_api.model.NotebookStatus;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NotebookApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NotebookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotebookApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getNotebookServerStatusCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/notebooks/server/{namespace}/status".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNotebookServerStatusValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNotebookServerStatus(Async)");
        }
        Call localVarCall = this.getNotebookServerStatusCall(namespace, _callback);
        return localVarCall;
    }

    public NotebookStatus getNotebookServerStatus(String namespace) throws ApiException {
        ApiResponse<NotebookStatus> localVarResp = this.getNotebookServerStatusWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<NotebookStatus> getNotebookServerStatusWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.getNotebookServerStatusValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<NotebookStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNotebookServerStatusAsync(String namespace, ApiCallback<NotebookStatus> _callback) throws ApiException {
        Call localVarCall = this.getNotebookServerStatusValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<NotebookStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call handleCopyNotebookCall(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NotebookCopy localVarPostBody = notebookCopy;
        String localVarPath = "/notebooks/{namespace}/{array}/copy".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (endTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleCopyNotebookValidateBeforeCall(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling handleCopyNotebook(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling handleCopyNotebook(Async)");
        }
        if (notebookCopy == null) {
            throw new ApiException("Missing the required parameter 'notebookCopy' when calling handleCopyNotebook(Async)");
        }
        Call localVarCall = this.handleCopyNotebookCall(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        return localVarCall;
    }

    public NotebookCopied handleCopyNotebook(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        ApiResponse<NotebookCopied> localVarResp = this.handleCopyNotebookWithHttpInfo(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<NotebookCopied> handleCopyNotebookWithHttpInfo(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        Call localVarCall = this.handleCopyNotebookValidateBeforeCall(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, null);
        Type localVarReturnType = new TypeToken<NotebookCopied>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call handleCopyNotebookAsync(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, ApiCallback<NotebookCopied> _callback) throws ApiException {
        Call localVarCall = this.handleCopyNotebookValidateBeforeCall(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<NotebookCopied>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call handleUploadNotebookCall(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/notebooks/{namespace}/upload".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (inputFile != null) {
            localVarFormParams.put("input_file", inputFile);
        }
        if (outputUri != null) {
            localVarFormParams.put("output_uri", outputUri);
        }
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleUploadNotebookValidateBeforeCall(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling handleUploadNotebook(Async)");
        }
        if (inputFile == null) {
            throw new ApiException("Missing the required parameter 'inputFile' when calling handleUploadNotebook(Async)");
        }
        Call localVarCall = this.handleUploadNotebookCall(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name, _callback);
        return localVarCall;
    }

    public FileUploaded handleUploadNotebook(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name) throws ApiException {
        ApiResponse<FileUploaded> localVarResp = this.handleUploadNotebookWithHttpInfo(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name);
        return localVarResp.getData();
    }

    public ApiResponse<FileUploaded> handleUploadNotebookWithHttpInfo(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name) throws ApiException {
        Call localVarCall = this.handleUploadNotebookValidateBeforeCall(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name, null);
        Type localVarReturnType = new TypeToken<FileUploaded>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call handleUploadNotebookAsync(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name, ApiCallback<FileUploaded> _callback) throws ApiException {
        Call localVarCall = this.handleUploadNotebookValidateBeforeCall(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name, _callback);
        Type localVarReturnType = new TypeToken<FileUploaded>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call shutdownNotebookServerCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/notebooks/server/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call shutdownNotebookServerValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shutdownNotebookServer(Async)");
        }
        Call localVarCall = this.shutdownNotebookServerCall(namespace, _callback);
        return localVarCall;
    }

    public void shutdownNotebookServer(String namespace) throws ApiException {
        this.shutdownNotebookServerWithHttpInfo(namespace);
    }

    public ApiResponse<Void> shutdownNotebookServerWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.shutdownNotebookServerValidateBeforeCall(namespace, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call shutdownNotebookServerAsync(String namespace, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.shutdownNotebookServerValidateBeforeCall(namespace, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateNotebookNameCall(String namespace, String array, ArrayInfoUpdate notebookMetadata, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayInfoUpdate localVarPostBody = notebookMetadata;
        String localVarPath = "/notebooks/{namespace}/{array}/rename".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNotebookNameValidateBeforeCall(String namespace, String array, ArrayInfoUpdate notebookMetadata, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateNotebookName(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling updateNotebookName(Async)");
        }
        if (notebookMetadata == null) {
            throw new ApiException("Missing the required parameter 'notebookMetadata' when calling updateNotebookName(Async)");
        }
        Call localVarCall = this.updateNotebookNameCall(namespace, array, notebookMetadata, _callback);
        return localVarCall;
    }

    public void updateNotebookName(String namespace, String array, ArrayInfoUpdate notebookMetadata) throws ApiException {
        this.updateNotebookNameWithHttpInfo(namespace, array, notebookMetadata);
    }

    public ApiResponse<Void> updateNotebookNameWithHttpInfo(String namespace, String array, ArrayInfoUpdate notebookMetadata) throws ApiException {
        Call localVarCall = this.updateNotebookNameValidateBeforeCall(namespace, array, notebookMetadata, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateNotebookNameAsync(String namespace, String array, ArrayInfoUpdate notebookMetadata, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateNotebookNameValidateBeforeCall(namespace, array, notebookMetadata, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

