/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.AWSAccessCredentials;
import io.tiledb.cloud.rest_api.model.DomainCheckResult;
import io.tiledb.cloud.rest_api.model.Organization;
import io.tiledb.cloud.rest_api.model.OrganizationUser;
import io.tiledb.cloud.rest_api.model.SSODomainConfig;
import io.tiledb.cloud.rest_api.model.SSODomainConfigResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class OrganizationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrganizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrganizationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addAWSAccessCredentialsCall(String namespace, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AWSAccessCredentials localVarPostBody = awsAccessCredentials;
        String localVarPath = "/credentials/{namespace}/aws".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAWSAccessCredentialsValidateBeforeCall(String namespace, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling addAWSAccessCredentials(Async)");
        }
        if (awsAccessCredentials == null) {
            throw new ApiException("Missing the required parameter 'awsAccessCredentials' when calling addAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.addAWSAccessCredentialsCall(namespace, awsAccessCredentials, _callback);
        return localVarCall;
    }

    public void addAWSAccessCredentials(String namespace, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        this.addAWSAccessCredentialsWithHttpInfo(namespace, awsAccessCredentials);
    }

    public ApiResponse<Void> addAWSAccessCredentialsWithHttpInfo(String namespace, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        Call localVarCall = this.addAWSAccessCredentialsValidateBeforeCall(namespace, awsAccessCredentials, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call addAWSAccessCredentialsAsync(String namespace, AWSAccessCredentials awsAccessCredentials, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addAWSAccessCredentialsValidateBeforeCall(namespace, awsAccessCredentials, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call addUserToOrganizationCall(String organization, OrganizationUser user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrganizationUser localVarPostBody = user;
        String localVarPath = "/organizations/{organization}/user".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addUserToOrganizationValidateBeforeCall(String organization, OrganizationUser user, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling addUserToOrganization(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling addUserToOrganization(Async)");
        }
        Call localVarCall = this.addUserToOrganizationCall(organization, user, _callback);
        return localVarCall;
    }

    public void addUserToOrganization(String organization, OrganizationUser user) throws ApiException {
        this.addUserToOrganizationWithHttpInfo(organization, user);
    }

    public ApiResponse<Void> addUserToOrganizationWithHttpInfo(String organization, OrganizationUser user) throws ApiException {
        Call localVarCall = this.addUserToOrganizationValidateBeforeCall(organization, user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call addUserToOrganizationAsync(String organization, OrganizationUser user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addUserToOrganizationValidateBeforeCall(organization, user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call checkAWSAccessCredentialsCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/aws".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkAWSAccessCredentialsValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling checkAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.checkAWSAccessCredentialsCall(namespace, _callback);
        return localVarCall;
    }

    public List<AWSAccessCredentials> checkAWSAccessCredentials(String namespace) throws ApiException {
        ApiResponse<List<AWSAccessCredentials>> localVarResp = this.checkAWSAccessCredentialsWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<List<AWSAccessCredentials>> checkAWSAccessCredentialsWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<List<AWSAccessCredentials>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call checkAWSAccessCredentialsAsync(String namespace, ApiCallback<List<AWSAccessCredentials>> _callback) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<List<AWSAccessCredentials>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call checkAWSAccessCredentialsByNameCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/aws/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkAWSAccessCredentialsByNameValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling checkAWSAccessCredentialsByName(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling checkAWSAccessCredentialsByName(Async)");
        }
        Call localVarCall = this.checkAWSAccessCredentialsByNameCall(namespace, name, _callback);
        return localVarCall;
    }

    public AWSAccessCredentials checkAWSAccessCredentialsByName(String namespace, String name) throws ApiException {
        ApiResponse<AWSAccessCredentials> localVarResp = this.checkAWSAccessCredentialsByNameWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    public ApiResponse<AWSAccessCredentials> checkAWSAccessCredentialsByNameWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsByNameValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<AWSAccessCredentials>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call checkAWSAccessCredentialsByNameAsync(String namespace, String name, ApiCallback<AWSAccessCredentials> _callback) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsByNameValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<AWSAccessCredentials>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call checkSSODomainCall(String organization, String uuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/sso_domains/{uuid}/run_check".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{uuid\\}", this.localVarApiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkSSODomainValidateBeforeCall(String organization, String uuid, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling checkSSODomain(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling checkSSODomain(Async)");
        }
        Call localVarCall = this.checkSSODomainCall(organization, uuid, _callback);
        return localVarCall;
    }

    public DomainCheckResult checkSSODomain(String organization, String uuid) throws ApiException {
        ApiResponse<DomainCheckResult> localVarResp = this.checkSSODomainWithHttpInfo(organization, uuid);
        return localVarResp.getData();
    }

    public ApiResponse<DomainCheckResult> checkSSODomainWithHttpInfo(String organization, String uuid) throws ApiException {
        Call localVarCall = this.checkSSODomainValidateBeforeCall(organization, uuid, null);
        Type localVarReturnType = new TypeToken<DomainCheckResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call checkSSODomainAsync(String organization, String uuid, ApiCallback<DomainCheckResult> _callback) throws ApiException {
        Call localVarCall = this.checkSSODomainValidateBeforeCall(organization, uuid, _callback);
        Type localVarReturnType = new TypeToken<DomainCheckResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createOrganizationCall(Organization organization, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Organization localVarPostBody = organization;
        String localVarPath = "/organization";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrganizationValidateBeforeCall(Organization organization, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling createOrganization(Async)");
        }
        Call localVarCall = this.createOrganizationCall(organization, _callback);
        return localVarCall;
    }

    public void createOrganization(Organization organization) throws ApiException {
        this.createOrganizationWithHttpInfo(organization);
    }

    public ApiResponse<Void> createOrganizationWithHttpInfo(Organization organization) throws ApiException {
        Call localVarCall = this.createOrganizationValidateBeforeCall(organization, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createOrganizationAsync(Organization organization, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createOrganizationValidateBeforeCall(organization, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createSSODomainCall(String organization, SSODomainConfig config, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SSODomainConfig localVarPostBody = config;
        String localVarPath = "/organizations/{organization}/sso_domain".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSSODomainValidateBeforeCall(String organization, SSODomainConfig config, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling createSSODomain(Async)");
        }
        if (config == null) {
            throw new ApiException("Missing the required parameter 'config' when calling createSSODomain(Async)");
        }
        Call localVarCall = this.createSSODomainCall(organization, config, _callback);
        return localVarCall;
    }

    public SSODomainConfig createSSODomain(String organization, SSODomainConfig config) throws ApiException {
        ApiResponse<SSODomainConfig> localVarResp = this.createSSODomainWithHttpInfo(organization, config);
        return localVarResp.getData();
    }

    public ApiResponse<SSODomainConfig> createSSODomainWithHttpInfo(String organization, SSODomainConfig config) throws ApiException {
        Call localVarCall = this.createSSODomainValidateBeforeCall(organization, config, null);
        Type localVarReturnType = new TypeToken<SSODomainConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSSODomainAsync(String organization, SSODomainConfig config, ApiCallback<SSODomainConfig> _callback) throws ApiException {
        Call localVarCall = this.createSSODomainValidateBeforeCall(organization, config, _callback);
        Type localVarReturnType = new TypeToken<SSODomainConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAWSAccessCredentialsCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/aws/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAWSAccessCredentialsValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteAWSAccessCredentials(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.deleteAWSAccessCredentialsCall(namespace, name, _callback);
        return localVarCall;
    }

    public void deleteAWSAccessCredentials(String namespace, String name) throws ApiException {
        this.deleteAWSAccessCredentialsWithHttpInfo(namespace, name);
    }

    public ApiResponse<Void> deleteAWSAccessCredentialsWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.deleteAWSAccessCredentialsValidateBeforeCall(namespace, name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAWSAccessCredentialsAsync(String namespace, String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAWSAccessCredentialsValidateBeforeCall(namespace, name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteOrganizationCall(String organization, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOrganizationValidateBeforeCall(String organization, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling deleteOrganization(Async)");
        }
        Call localVarCall = this.deleteOrganizationCall(organization, _callback);
        return localVarCall;
    }

    public void deleteOrganization(String organization) throws ApiException {
        this.deleteOrganizationWithHttpInfo(organization);
    }

    public ApiResponse<Void> deleteOrganizationWithHttpInfo(String organization) throws ApiException {
        Call localVarCall = this.deleteOrganizationValidateBeforeCall(organization, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteOrganizationAsync(String organization, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOrganizationValidateBeforeCall(organization, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteSSODomainCall(String organization, String uuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/sso_domains/{uuid}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{uuid\\}", this.localVarApiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSSODomainValidateBeforeCall(String organization, String uuid, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling deleteSSODomain(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteSSODomain(Async)");
        }
        Call localVarCall = this.deleteSSODomainCall(organization, uuid, _callback);
        return localVarCall;
    }

    public void deleteSSODomain(String organization, String uuid) throws ApiException {
        this.deleteSSODomainWithHttpInfo(organization, uuid);
    }

    public ApiResponse<Void> deleteSSODomainWithHttpInfo(String organization, String uuid) throws ApiException {
        Call localVarCall = this.deleteSSODomainValidateBeforeCall(organization, uuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSSODomainAsync(String organization, String uuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSSODomainValidateBeforeCall(organization, uuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserFromOrganizationCall(String organization, String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/{username}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserFromOrganizationValidateBeforeCall(String organization, String username, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling deleteUserFromOrganization(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling deleteUserFromOrganization(Async)");
        }
        Call localVarCall = this.deleteUserFromOrganizationCall(organization, username, _callback);
        return localVarCall;
    }

    public void deleteUserFromOrganization(String organization, String username) throws ApiException {
        this.deleteUserFromOrganizationWithHttpInfo(organization, username);
    }

    public ApiResponse<Void> deleteUserFromOrganizationWithHttpInfo(String organization, String username) throws ApiException {
        Call localVarCall = this.deleteUserFromOrganizationValidateBeforeCall(organization, username, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserFromOrganizationAsync(String organization, String username, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserFromOrganizationValidateBeforeCall(organization, username, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllOrganizationsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllOrganizationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllOrganizationsCall(_callback);
        return localVarCall;
    }

    public List<Organization> getAllOrganizations() throws ApiException {
        ApiResponse<List<Organization>> localVarResp = this.getAllOrganizationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Organization>> getAllOrganizationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAllOrganizationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Organization>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllOrganizationsAsync(ApiCallback<List<Organization>> _callback) throws ApiException {
        Call localVarCall = this.getAllOrganizationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Organization>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrganizationCall(String organization, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrganizationValidateBeforeCall(String organization, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling getOrganization(Async)");
        }
        Call localVarCall = this.getOrganizationCall(organization, _callback);
        return localVarCall;
    }

    public Organization getOrganization(String organization) throws ApiException {
        ApiResponse<Organization> localVarResp = this.getOrganizationWithHttpInfo(organization);
        return localVarResp.getData();
    }

    public ApiResponse<Organization> getOrganizationWithHttpInfo(String organization) throws ApiException {
        Call localVarCall = this.getOrganizationValidateBeforeCall(organization, null);
        Type localVarReturnType = new TypeToken<Organization>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrganizationAsync(String organization, ApiCallback<Organization> _callback) throws ApiException {
        Call localVarCall = this.getOrganizationValidateBeforeCall(organization, _callback);
        Type localVarReturnType = new TypeToken<Organization>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrganizationUserCall(String organization, String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/{username}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrganizationUserValidateBeforeCall(String organization, String username, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling getOrganizationUser(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling getOrganizationUser(Async)");
        }
        Call localVarCall = this.getOrganizationUserCall(organization, username, _callback);
        return localVarCall;
    }

    public OrganizationUser getOrganizationUser(String organization, String username) throws ApiException {
        ApiResponse<OrganizationUser> localVarResp = this.getOrganizationUserWithHttpInfo(organization, username);
        return localVarResp.getData();
    }

    public ApiResponse<OrganizationUser> getOrganizationUserWithHttpInfo(String organization, String username) throws ApiException {
        Call localVarCall = this.getOrganizationUserValidateBeforeCall(organization, username, null);
        Type localVarReturnType = new TypeToken<OrganizationUser>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrganizationUserAsync(String organization, String username, ApiCallback<OrganizationUser> _callback) throws ApiException {
        Call localVarCall = this.getOrganizationUserValidateBeforeCall(organization, username, _callback);
        Type localVarReturnType = new TypeToken<OrganizationUser>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSSODomainCall(String organization, String uuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/sso_domains/{uuid}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{uuid\\}", this.localVarApiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSSODomainValidateBeforeCall(String organization, String uuid, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling getSSODomain(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getSSODomain(Async)");
        }
        Call localVarCall = this.getSSODomainCall(organization, uuid, _callback);
        return localVarCall;
    }

    public SSODomainConfig getSSODomain(String organization, String uuid) throws ApiException {
        ApiResponse<SSODomainConfig> localVarResp = this.getSSODomainWithHttpInfo(organization, uuid);
        return localVarResp.getData();
    }

    public ApiResponse<SSODomainConfig> getSSODomainWithHttpInfo(String organization, String uuid) throws ApiException {
        Call localVarCall = this.getSSODomainValidateBeforeCall(organization, uuid, null);
        Type localVarReturnType = new TypeToken<SSODomainConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSSODomainAsync(String organization, String uuid, ApiCallback<SSODomainConfig> _callback) throws ApiException {
        Call localVarCall = this.getSSODomainValidateBeforeCall(organization, uuid, _callback);
        Type localVarReturnType = new TypeToken<SSODomainConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSSODomainsCall(String organization, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/sso_domains".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSSODomainsValidateBeforeCall(String organization, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling getSSODomains(Async)");
        }
        Call localVarCall = this.getSSODomainsCall(organization, _callback);
        return localVarCall;
    }

    public SSODomainConfigResponse getSSODomains(String organization) throws ApiException {
        ApiResponse<SSODomainConfigResponse> localVarResp = this.getSSODomainsWithHttpInfo(organization);
        return localVarResp.getData();
    }

    public ApiResponse<SSODomainConfigResponse> getSSODomainsWithHttpInfo(String organization) throws ApiException {
        Call localVarCall = this.getSSODomainsValidateBeforeCall(organization, null);
        Type localVarReturnType = new TypeToken<SSODomainConfigResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSSODomainsAsync(String organization, ApiCallback<SSODomainConfigResponse> _callback) throws ApiException {
        Call localVarCall = this.getSSODomainsValidateBeforeCall(organization, _callback);
        Type localVarReturnType = new TypeToken<SSODomainConfigResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAWSAccessCredentialsCall(String namespace, String name, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AWSAccessCredentials localVarPostBody = awsAccessCredentials;
        String localVarPath = "/credentials/{namespace}/aws/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAWSAccessCredentialsValidateBeforeCall(String namespace, String name, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateAWSAccessCredentials(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateAWSAccessCredentials(Async)");
        }
        if (awsAccessCredentials == null) {
            throw new ApiException("Missing the required parameter 'awsAccessCredentials' when calling updateAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.updateAWSAccessCredentialsCall(namespace, name, awsAccessCredentials, _callback);
        return localVarCall;
    }

    public void updateAWSAccessCredentials(String namespace, String name, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        this.updateAWSAccessCredentialsWithHttpInfo(namespace, name, awsAccessCredentials);
    }

    public ApiResponse<Void> updateAWSAccessCredentialsWithHttpInfo(String namespace, String name, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        Call localVarCall = this.updateAWSAccessCredentialsValidateBeforeCall(namespace, name, awsAccessCredentials, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateAWSAccessCredentialsAsync(String namespace, String name, AWSAccessCredentials awsAccessCredentials, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateAWSAccessCredentialsValidateBeforeCall(namespace, name, awsAccessCredentials, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateOrganizationCall(String organization, Organization organizationDetails, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Organization localVarPostBody = organizationDetails;
        String localVarPath = "/organizations/{organization}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrganizationValidateBeforeCall(String organization, Organization organizationDetails, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling updateOrganization(Async)");
        }
        if (organizationDetails == null) {
            throw new ApiException("Missing the required parameter 'organizationDetails' when calling updateOrganization(Async)");
        }
        Call localVarCall = this.updateOrganizationCall(organization, organizationDetails, _callback);
        return localVarCall;
    }

    public void updateOrganization(String organization, Organization organizationDetails) throws ApiException {
        this.updateOrganizationWithHttpInfo(organization, organizationDetails);
    }

    public ApiResponse<Void> updateOrganizationWithHttpInfo(String organization, Organization organizationDetails) throws ApiException {
        Call localVarCall = this.updateOrganizationValidateBeforeCall(organization, organizationDetails, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateOrganizationAsync(String organization, Organization organizationDetails, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateOrganizationValidateBeforeCall(organization, organizationDetails, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateSSODomainCall(String organization, String uuid, SSODomainConfig config, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SSODomainConfig localVarPostBody = config;
        String localVarPath = "/organizations/{organization}/sso_domains/{uuid}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{uuid\\}", this.localVarApiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSSODomainValidateBeforeCall(String organization, String uuid, SSODomainConfig config, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling updateSSODomain(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateSSODomain(Async)");
        }
        if (config == null) {
            throw new ApiException("Missing the required parameter 'config' when calling updateSSODomain(Async)");
        }
        Call localVarCall = this.updateSSODomainCall(organization, uuid, config, _callback);
        return localVarCall;
    }

    public SSODomainConfig updateSSODomain(String organization, String uuid, SSODomainConfig config) throws ApiException {
        ApiResponse<SSODomainConfig> localVarResp = this.updateSSODomainWithHttpInfo(organization, uuid, config);
        return localVarResp.getData();
    }

    public ApiResponse<SSODomainConfig> updateSSODomainWithHttpInfo(String organization, String uuid, SSODomainConfig config) throws ApiException {
        Call localVarCall = this.updateSSODomainValidateBeforeCall(organization, uuid, config, null);
        Type localVarReturnType = new TypeToken<SSODomainConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSSODomainAsync(String organization, String uuid, SSODomainConfig config, ApiCallback<SSODomainConfig> _callback) throws ApiException {
        Call localVarCall = this.updateSSODomainValidateBeforeCall(organization, uuid, config, _callback);
        Type localVarReturnType = new TypeToken<SSODomainConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateUserInOrganizationCall(String organization, String username, OrganizationUser user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrganizationUser localVarPostBody = user;
        String localVarPath = "/organizations/{organization}/{username}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUserInOrganizationValidateBeforeCall(String organization, String username, OrganizationUser user, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling updateUserInOrganization(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling updateUserInOrganization(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling updateUserInOrganization(Async)");
        }
        Call localVarCall = this.updateUserInOrganizationCall(organization, username, user, _callback);
        return localVarCall;
    }

    public void updateUserInOrganization(String organization, String username, OrganizationUser user) throws ApiException {
        this.updateUserInOrganizationWithHttpInfo(organization, username, user);
    }

    public ApiResponse<Void> updateUserInOrganizationWithHttpInfo(String organization, String username, OrganizationUser user) throws ApiException {
        Call localVarCall = this.updateUserInOrganizationValidateBeforeCall(organization, username, user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateUserInOrganizationAsync(String organization, String username, OrganizationUser user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateUserInOrganizationValidateBeforeCall(organization, username, user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

