/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.Query;
import io.tiledb.cloud.rest_api.model.QueryJson;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class QueryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public QueryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call finalizeQueryCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Query localVarPostBody = query;
        String localVarPath = "/arrays/{namespace}/{array}/query/finalize".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (openAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_at", openAt));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call finalizeQueryValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling finalizeQuery(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling finalizeQuery(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling finalizeQuery(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling finalizeQuery(Async)");
        }
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling finalizeQuery(Async)");
        }
        Call localVarCall = this.finalizeQueryCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        return localVarCall;
    }

    public Query finalizeQuery(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        ApiResponse<Query> localVarResp = this.finalizeQueryWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt);
        return localVarResp.getData();
    }

    public ApiResponse<Query> finalizeQueryWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        Call localVarCall = this.finalizeQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, null);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call finalizeQueryAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback<Query> _callback) throws ApiException {
        Call localVarCall = this.finalizeQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEstResultSizesCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Query localVarPostBody = query;
        String localVarPath = "/arrays/{namespace}/{array}/query/est_result_sizes".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (openAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_at", openAt));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEstResultSizesValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getEstResultSizes(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getEstResultSizes(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getEstResultSizes(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getEstResultSizes(Async)");
        }
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling getEstResultSizes(Async)");
        }
        Call localVarCall = this.getEstResultSizesCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        return localVarCall;
    }

    public Query getEstResultSizes(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        ApiResponse<Query> localVarResp = this.getEstResultSizesWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt);
        return localVarResp.getData();
    }

    public ApiResponse<Query> getEstResultSizesWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        Call localVarCall = this.getEstResultSizesValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, null);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEstResultSizesAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback<Query> _callback) throws ApiException {
        Call localVarCall = this.getEstResultSizesValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFileCall(String namespace, String array, String contentType, String xPayer, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/query/get_file".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/x-ipynb+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFileValidateBeforeCall(String namespace, String array, String contentType, String xPayer, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getFile(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getFile(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getFile(Async)");
        }
        Call localVarCall = this.getFileCall(namespace, array, contentType, xPayer, _callback);
        return localVarCall;
    }

    public File getFile(String namespace, String array, String contentType, String xPayer) throws ApiException {
        ApiResponse<File> localVarResp = this.getFileWithHttpInfo(namespace, array, contentType, xPayer);
        return localVarResp.getData();
    }

    public ApiResponse<File> getFileWithHttpInfo(String namespace, String array, String contentType, String xPayer) throws ApiException {
        Call localVarCall = this.getFileValidateBeforeCall(namespace, array, contentType, xPayer, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFileAsync(String namespace, String array, String contentType, String xPayer, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getFileValidateBeforeCall(namespace, array, contentType, xPayer, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitQueryCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Query localVarPostBody = query;
        String localVarPath = "/arrays/{namespace}/{array}/query/submit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (openAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_at", openAt));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitQueryValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitQuery(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitQuery(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling submitQuery(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling submitQuery(Async)");
        }
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling submitQuery(Async)");
        }
        Call localVarCall = this.submitQueryCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        return localVarCall;
    }

    public Query submitQuery(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        ApiResponse<Query> localVarResp = this.submitQueryWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt);
        return localVarResp.getData();
    }

    public ApiResponse<Query> submitQueryWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        Call localVarCall = this.submitQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, null);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitQueryAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, ApiCallback<Query> _callback) throws ApiException {
        Call localVarCall = this.submitQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitQueryJsonCall(String namespace, String array, String contentType, QueryJson queryJson, String xPayer, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        QueryJson localVarPostBody = queryJson;
        String localVarPath = "/arrays/{namespace}/{array}/query/submit_query_json".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitQueryJsonValidateBeforeCall(String namespace, String array, String contentType, QueryJson queryJson, String xPayer, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitQueryJson(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitQueryJson(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling submitQueryJson(Async)");
        }
        if (queryJson == null) {
            throw new ApiException("Missing the required parameter 'queryJson' when calling submitQueryJson(Async)");
        }
        Call localVarCall = this.submitQueryJsonCall(namespace, array, contentType, queryJson, xPayer, _callback);
        return localVarCall;
    }

    public Object submitQueryJson(String namespace, String array, String contentType, QueryJson queryJson, String xPayer) throws ApiException {
        ApiResponse<Object> localVarResp = this.submitQueryJsonWithHttpInfo(namespace, array, contentType, queryJson, xPayer);
        return localVarResp.getData();
    }

    public ApiResponse<Object> submitQueryJsonWithHttpInfo(String namespace, String array, String contentType, QueryJson queryJson, String xPayer) throws ApiException {
        Call localVarCall = this.submitQueryJsonValidateBeforeCall(namespace, array, contentType, queryJson, xPayer, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitQueryJsonAsync(String namespace, String array, String contentType, QueryJson queryJson, String xPayer, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.submitQueryJsonValidateBeforeCall(namespace, array, contentType, queryJson, xPayer, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

