/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.SQLParameters;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SqlApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SqlApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SqlApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call runSQLCall(String namespace, SQLParameters sql, String acceptEncoding, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SQLParameters localVarPostBody = sql;
        String localVarPath = "/sql/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call runSQLValidateBeforeCall(String namespace, SQLParameters sql, String acceptEncoding, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling runSQL(Async)");
        }
        if (sql == null) {
            throw new ApiException("Missing the required parameter 'sql' when calling runSQL(Async)");
        }
        Call localVarCall = this.runSQLCall(namespace, sql, acceptEncoding, _callback);
        return localVarCall;
    }

    public ApiResponse<byte[]> runSQLWithHttpInfoBytes(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        Call localVarCall = this.runSQLValidateBeforeCall(namespace, sql, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public byte[] runSQLBytes(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        ApiResponse<byte[]> localVarResp = this.runSQLWithHttpInfoBytes(namespace, sql, acceptEncoding);
        return localVarResp.getData();
    }

    public List<Object> runSQL(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        ApiResponse<List<Object>> localVarResp = this.runSQLWithHttpInfo(namespace, sql, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<List<Object>> runSQLWithHttpInfo(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        Call localVarCall = this.runSQLValidateBeforeCall(namespace, sql, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call runSQLAsync(String namespace, SQLParameters sql, String acceptEncoding, ApiCallback<List<Object>> _callback) throws ApiException {
        Call localVarCall = this.runSQLValidateBeforeCall(namespace, sql, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

