/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.TaskGraphClientNodeStatus;
import io.tiledb.cloud.rest_api.model.TaskGraphLog;
import io.tiledb.cloud.rest_api.model.TaskGraphLogsData;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TaskGraphLogsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TaskGraphLogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskGraphLogsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTaskGraphLogCall(String namespace, TaskGraphLog log, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TaskGraphLog localVarPostBody = log;
        String localVarPath = "/taskgraphs/{namespace}/log".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTaskGraphLogValidateBeforeCall(String namespace, TaskGraphLog log, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createTaskGraphLog(Async)");
        }
        if (log == null) {
            throw new ApiException("Missing the required parameter 'log' when calling createTaskGraphLog(Async)");
        }
        Call localVarCall = this.createTaskGraphLogCall(namespace, log, _callback);
        return localVarCall;
    }

    public TaskGraphLog createTaskGraphLog(String namespace, TaskGraphLog log) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.createTaskGraphLogWithHttpInfo(namespace, log);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> createTaskGraphLogWithHttpInfo(String namespace, TaskGraphLog log) throws ApiException {
        Call localVarCall = this.createTaskGraphLogValidateBeforeCall(namespace, log, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTaskGraphLogAsync(String namespace, TaskGraphLog log, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.createTaskGraphLogValidateBeforeCall(namespace, log, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTaskGraphLogCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/logs/{id}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaskGraphLogValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getTaskGraphLog(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTaskGraphLog(Async)");
        }
        Call localVarCall = this.getTaskGraphLogCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraphLog getTaskGraphLog(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.getTaskGraphLogWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> getTaskGraphLogWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.getTaskGraphLogValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTaskGraphLogAsync(String namespace, String id, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.getTaskGraphLogValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTaskGraphLogsCall(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (createdBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_by", createdBy));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTaskGraphLogsValidateBeforeCall(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listTaskGraphLogsCall(namespace, createdBy, search, startTime, endTime, page, perPage, _callback);
        return localVarCall;
    }

    public TaskGraphLogsData listTaskGraphLogs(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage) throws ApiException {
        ApiResponse<TaskGraphLogsData> localVarResp = this.listTaskGraphLogsWithHttpInfo(namespace, createdBy, search, startTime, endTime, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLogsData> listTaskGraphLogsWithHttpInfo(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.listTaskGraphLogsValidateBeforeCall(namespace, createdBy, search, startTime, endTime, page, perPage, null);
        Type localVarReturnType = new TypeToken<TaskGraphLogsData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTaskGraphLogsAsync(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage, ApiCallback<TaskGraphLogsData> _callback) throws ApiException {
        Call localVarCall = this.listTaskGraphLogsValidateBeforeCall(namespace, createdBy, search, startTime, endTime, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLogsData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call reportClientNodeCall(String namespace, String id, TaskGraphClientNodeStatus report, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TaskGraphClientNodeStatus localVarPostBody = report;
        String localVarPath = "/taskgraphs/{namespace}/logs/{id}/report_client_node".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call reportClientNodeValidateBeforeCall(String namespace, String id, TaskGraphClientNodeStatus report, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling reportClientNode(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling reportClientNode(Async)");
        }
        if (report == null) {
            throw new ApiException("Missing the required parameter 'report' when calling reportClientNode(Async)");
        }
        Call localVarCall = this.reportClientNodeCall(namespace, id, report, _callback);
        return localVarCall;
    }

    public void reportClientNode(String namespace, String id, TaskGraphClientNodeStatus report) throws ApiException {
        this.reportClientNodeWithHttpInfo(namespace, id, report);
    }

    public ApiResponse<Void> reportClientNodeWithHttpInfo(String namespace, String id, TaskGraphClientNodeStatus report) throws ApiException {
        Call localVarCall = this.reportClientNodeValidateBeforeCall(namespace, id, report, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call reportClientNodeAsync(String namespace, String id, TaskGraphClientNodeStatus report, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.reportClientNodeValidateBeforeCall(namespace, id, report, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call resubmitTaskGraphExecutionCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/executions/{id}/resubmit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resubmitTaskGraphExecutionValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling resubmitTaskGraphExecution(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling resubmitTaskGraphExecution(Async)");
        }
        Call localVarCall = this.resubmitTaskGraphExecutionCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraphLog resubmitTaskGraphExecution(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.resubmitTaskGraphExecutionWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> resubmitTaskGraphExecutionWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.resubmitTaskGraphExecutionValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resubmitTaskGraphExecutionAsync(String namespace, String id, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.resubmitTaskGraphExecutionValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call retryTaskGraphExecutionCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/executions/{id}/retry".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retryTaskGraphExecutionValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling retryTaskGraphExecution(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling retryTaskGraphExecution(Async)");
        }
        Call localVarCall = this.retryTaskGraphExecutionCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraphLog retryTaskGraphExecution(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.retryTaskGraphExecutionWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> retryTaskGraphExecutionWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.retryTaskGraphExecutionValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retryTaskGraphExecutionAsync(String namespace, String id, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.retryTaskGraphExecutionValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call stopTaskGraphExecutionCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/executions/{id}/stop".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stopTaskGraphExecutionValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling stopTaskGraphExecution(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling stopTaskGraphExecution(Async)");
        }
        Call localVarCall = this.stopTaskGraphExecutionCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraphLog stopTaskGraphExecution(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.stopTaskGraphExecutionWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> stopTaskGraphExecutionWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.stopTaskGraphExecutionValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call stopTaskGraphExecutionAsync(String namespace, String id, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.stopTaskGraphExecutionValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitTaskGraphCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/graphs/{id}/submit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitTaskGraphValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitTaskGraph(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling submitTaskGraph(Async)");
        }
        Call localVarCall = this.submitTaskGraphCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraphLog submitTaskGraph(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.submitTaskGraphWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> submitTaskGraphWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.submitTaskGraphValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitTaskGraphAsync(String namespace, String id, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.submitTaskGraphValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTaskGraphLogCall(String namespace, String id, TaskGraphLog log, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TaskGraphLog localVarPostBody = log;
        String localVarPath = "/taskgraphs/{namespace}/logs/{id}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTaskGraphLogValidateBeforeCall(String namespace, String id, TaskGraphLog log, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateTaskGraphLog(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateTaskGraphLog(Async)");
        }
        if (log == null) {
            throw new ApiException("Missing the required parameter 'log' when calling updateTaskGraphLog(Async)");
        }
        Call localVarCall = this.updateTaskGraphLogCall(namespace, id, log, _callback);
        return localVarCall;
    }

    public void updateTaskGraphLog(String namespace, String id, TaskGraphLog log) throws ApiException {
        this.updateTaskGraphLogWithHttpInfo(namespace, id, log);
    }

    public ApiResponse<Void> updateTaskGraphLogWithHttpInfo(String namespace, String id, TaskGraphLog log) throws ApiException {
        Call localVarCall = this.updateTaskGraphLogValidateBeforeCall(namespace, id, log, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateTaskGraphLogAsync(String namespace, String id, TaskGraphLog log, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateTaskGraphLogValidateBeforeCall(namespace, id, log, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

