/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.TaskGraph;
import io.tiledb.cloud.rest_api.model.TaskGraphLog;
import io.tiledb.cloud.rest_api.model.TaskGraphs;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TaskGraphsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TaskGraphsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskGraphsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTaskGraphCall(String namespace, TaskGraph graph, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TaskGraph localVarPostBody = graph;
        String localVarPath = "/taskgraphs/{namespace}/graphs".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTaskGraphValidateBeforeCall(String namespace, TaskGraph graph, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createTaskGraph(Async)");
        }
        if (graph == null) {
            throw new ApiException("Missing the required parameter 'graph' when calling createTaskGraph(Async)");
        }
        Call localVarCall = this.createTaskGraphCall(namespace, graph, _callback);
        return localVarCall;
    }

    public TaskGraph createTaskGraph(String namespace, TaskGraph graph) throws ApiException {
        ApiResponse<TaskGraph> localVarResp = this.createTaskGraphWithHttpInfo(namespace, graph);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraph> createTaskGraphWithHttpInfo(String namespace, TaskGraph graph) throws ApiException {
        Call localVarCall = this.createTaskGraphValidateBeforeCall(namespace, graph, null);
        Type localVarReturnType = new TypeToken<TaskGraph>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTaskGraphAsync(String namespace, TaskGraph graph, ApiCallback<TaskGraph> _callback) throws ApiException {
        Call localVarCall = this.createTaskGraphValidateBeforeCall(namespace, graph, _callback);
        Type localVarReturnType = new TypeToken<TaskGraph>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTaskGraphCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/graphs/{id}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaskGraphValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getTaskGraph(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTaskGraph(Async)");
        }
        Call localVarCall = this.getTaskGraphCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraph getTaskGraph(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraph> localVarResp = this.getTaskGraphWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraph> getTaskGraphWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.getTaskGraphValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraph>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTaskGraphAsync(String namespace, String id, ApiCallback<TaskGraph> _callback) throws ApiException {
        Call localVarCall = this.getTaskGraphValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraph>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTaskGraphsCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/graphs".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTaskGraphsValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listTaskGraphs(Async)");
        }
        Call localVarCall = this.listTaskGraphsCall(namespace, _callback);
        return localVarCall;
    }

    public TaskGraphs listTaskGraphs(String namespace) throws ApiException {
        ApiResponse<TaskGraphs> localVarResp = this.listTaskGraphsWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphs> listTaskGraphsWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.listTaskGraphsValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<TaskGraphs>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTaskGraphsAsync(String namespace, ApiCallback<TaskGraphs> _callback) throws ApiException {
        Call localVarCall = this.listTaskGraphsValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphs>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitTaskGraphCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/taskgraphs/{namespace}/graphs/{id}/submit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitTaskGraphValidateBeforeCall(String namespace, String id, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitTaskGraph(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling submitTaskGraph(Async)");
        }
        Call localVarCall = this.submitTaskGraphCall(namespace, id, _callback);
        return localVarCall;
    }

    public TaskGraphLog submitTaskGraph(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = this.submitTaskGraphWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskGraphLog> submitTaskGraphWithHttpInfo(String namespace, String id) throws ApiException {
        Call localVarCall = this.submitTaskGraphValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitTaskGraphAsync(String namespace, String id, ApiCallback<TaskGraphLog> _callback) throws ApiException {
        Call localVarCall = this.submitTaskGraphValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTaskGraphCall(String namespace, String id, TaskGraph graph, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TaskGraph localVarPostBody = graph;
        String localVarPath = "/taskgraphs/{namespace}/graphs/{id}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTaskGraphValidateBeforeCall(String namespace, String id, TaskGraph graph, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateTaskGraph(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateTaskGraph(Async)");
        }
        if (graph == null) {
            throw new ApiException("Missing the required parameter 'graph' when calling updateTaskGraph(Async)");
        }
        Call localVarCall = this.updateTaskGraphCall(namespace, id, graph, _callback);
        return localVarCall;
    }

    public void updateTaskGraph(String namespace, String id, TaskGraph graph) throws ApiException {
        this.updateTaskGraphWithHttpInfo(namespace, id, graph);
    }

    public ApiResponse<Void> updateTaskGraphWithHttpInfo(String namespace, String id, TaskGraph graph) throws ApiException {
        Call localVarCall = this.updateTaskGraphValidateBeforeCall(namespace, id, graph, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateTaskGraphAsync(String namespace, String id, TaskGraph graph, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateTaskGraphValidateBeforeCall(namespace, id, graph, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

