/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.ArrayTask;
import io.tiledb.cloud.rest_api.model.ArrayTaskData;
import io.tiledb.cloud.rest_api.model.SQLParameters;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class TasksApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TasksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TasksApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call runSQLCall(String namespace, SQLParameters sql, String acceptEncoding, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SQLParameters localVarPostBody = sql;
        String localVarPath = "/sql/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call runSQLValidateBeforeCall(String namespace, SQLParameters sql, String acceptEncoding, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling runSQL(Async)");
        }
        if (sql == null) {
            throw new ApiException("Missing the required parameter 'sql' when calling runSQL(Async)");
        }
        Call localVarCall = this.runSQLCall(namespace, sql, acceptEncoding, _callback);
        return localVarCall;
    }

    public List<Object> runSQL(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        ApiResponse<List<Object>> localVarResp = this.runSQLWithHttpInfo(namespace, sql, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<List<Object>> runSQLWithHttpInfo(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        Call localVarCall = this.runSQLValidateBeforeCall(namespace, sql, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call runSQLAsync(String namespace, SQLParameters sql, String acceptEncoding, ApiCallback<List<Object>> _callback) throws ApiException {
        Call localVarCall = this.runSQLValidateBeforeCall(namespace, sql, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call taskIdGetCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call taskIdGetValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling taskIdGet(Async)");
        }
        Call localVarCall = this.taskIdGetCall(id, _callback);
        return localVarCall;
    }

    public ArrayTask taskIdGet(String id) throws ApiException {
        ApiResponse<ArrayTask> localVarResp = this.taskIdGetWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayTask> taskIdGetWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.taskIdGetValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ArrayTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call taskIdGetAsync(String id, ApiCallback<ArrayTask> _callback) throws ApiException {
        Call localVarCall = this.taskIdGetValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ArrayTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call taskIdResultGetCall(String id, String acceptEncoding, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/result".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call taskIdResultGetValidateBeforeCall(String id, String acceptEncoding, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling taskIdResultGet(Async)");
        }
        Call localVarCall = this.taskIdResultGetCall(id, acceptEncoding, _callback);
        return localVarCall;
    }

    public String taskIdResultGet(String id, String acceptEncoding) throws ApiException {
        ApiResponse<String> localVarResp = this.taskIdResultGetWithHttpInfo(id, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<String> taskIdResultGetWithHttpInfo(String id, String acceptEncoding) throws ApiException {
        Call localVarCall = this.taskIdResultGetValidateBeforeCall(id, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call taskIdResultGetAsync(String id, String acceptEncoding, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.taskIdResultGetValidateBeforeCall(id, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tasksGetCall(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/tasks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (createdBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_by", createdBy));
        }
        if (array != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("array", array));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (excludeType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude_type", excludeType));
        }
        if (fileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }
        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (orderby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderby", orderby));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call tasksGetValidateBeforeCall(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.tasksGetCall(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby, _callback);
        return localVarCall;
    }

    public ArrayTaskData tasksGet(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby) throws ApiException {
        ApiResponse<ArrayTaskData> localVarResp = this.tasksGetWithHttpInfo(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayTaskData> tasksGetWithHttpInfo(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby) throws ApiException {
        Call localVarCall = this.tasksGetValidateBeforeCall(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby, null);
        Type localVarReturnType = new TypeToken<ArrayTaskData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call tasksGetAsync(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby, ApiCallback<ArrayTaskData> _callback) throws ApiException {
        Call localVarCall = this.tasksGetValidateBeforeCall(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby, _callback);
        Type localVarReturnType = new TypeToken<ArrayTaskData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

