/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.ArrayEndTimestampData;
import io.tiledb.cloud.rest_api.model.GenericUDF;
import io.tiledb.cloud.rest_api.model.MultiArrayUDF;
import io.tiledb.cloud.rest_api.model.UDFCopied;
import io.tiledb.cloud.rest_api.model.UDFCopy;
import io.tiledb.cloud.rest_api.model.UDFInfo;
import io.tiledb.cloud.rest_api.model.UDFInfoUpdate;
import io.tiledb.cloud.rest_api.model.UDFSharing;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class UdfApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UdfApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UdfApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteUDFInfoCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/udf/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUDFInfoValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteUDFInfo(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteUDFInfo(Async)");
        }
        Call localVarCall = this.deleteUDFInfoCall(namespace, name, _callback);
        return localVarCall;
    }

    public byte[] submitGenericUDFBytes(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<byte[]> localVarResp = this.submitGenericUDFWithHttpInfoBytes(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<byte[]> submitGenericUDFWithHttpInfoBytes(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Object submitGenericUDFObj(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<Object> localVarResp = this.submitGenericUDFWithHttpInfoObj(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public String submitMultiArrayUDFString(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<String> localVarResp = this.submitMultiArrayUDFWithHttpInfoString(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<String> submitMultiArrayUDFWithHttpInfoString(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitMultiArrayUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public byte[] submitMultiArrayUDFBytes(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<byte[]> localVarResp = this.submitMultiArrayUDFWithHttpInfoBytes(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public String submitUDFString(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        ApiResponse<String> localVarResp = this.submitUDFWithHttpInfoString(namespace, array, udf, xPayer, acceptEncoding, v2);
        return localVarResp.getData();
    }

    public ApiResponse<String> submitUDFWithHttpInfoString(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        Call localVarCall = this.submitUDFValidateBeforeCall(namespace, array, udf, xPayer, acceptEncoding, v2, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public byte[] submitUDFBytes(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        ApiResponse<byte[]> localVarResp = this.submitUDFWithHttpInfoBytes(namespace, array, udf, xPayer, acceptEncoding, v2);
        return localVarResp.getData();
    }

    public ApiResponse<byte[]> submitUDFWithHttpInfoBytes(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        Call localVarCall = this.submitUDFValidateBeforeCall(namespace, array, udf, xPayer, acceptEncoding, v2, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<byte[]> submitMultiArrayUDFWithHttpInfoBytes(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitMultiArrayUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<Object> submitGenericUDFWithHttpInfoObj(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public void deleteUDFInfo(String namespace, String name) throws ApiException {
        this.deleteUDFInfoWithHttpInfo(namespace, name);
    }

    public ApiResponse<String> submitGenericUDFWithHttpInfoString(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public String submitGenericUDFString(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<String> localVarResp = this.submitGenericUDFWithHttpInfoString(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<Void> deleteUDFInfoWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.deleteUDFInfoValidateBeforeCall(namespace, name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUDFInfoAsync(String namespace, String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUDFInfoValidateBeforeCall(namespace, name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getUDFInfoCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/udf/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUDFInfoValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getUDFInfo(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getUDFInfo(Async)");
        }
        Call localVarCall = this.getUDFInfoCall(namespace, name, _callback);
        return localVarCall;
    }

    public UDFInfo getUDFInfo(String namespace, String name) throws ApiException {
        ApiResponse<UDFInfo> localVarResp = this.getUDFInfoWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    public ApiResponse<UDFInfo> getUDFInfoWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.getUDFInfoValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<UDFInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUDFInfoAsync(String namespace, String name, ApiCallback<UDFInfo> _callback) throws ApiException {
        Call localVarCall = this.getUDFInfoValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<UDFInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUDFInfoSharingPoliciesCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/udf/{namespace}/{name}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUDFInfoSharingPoliciesValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getUDFInfoSharingPolicies(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getUDFInfoSharingPolicies(Async)");
        }
        Call localVarCall = this.getUDFInfoSharingPoliciesCall(namespace, name, _callback);
        return localVarCall;
    }

    public List<UDFSharing> getUDFInfoSharingPolicies(String namespace, String name) throws ApiException {
        ApiResponse<List<UDFSharing>> localVarResp = this.getUDFInfoSharingPoliciesWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    public ApiResponse<List<UDFSharing>> getUDFInfoSharingPoliciesWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.getUDFInfoSharingPoliciesValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<List<UDFSharing>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUDFInfoSharingPoliciesAsync(String namespace, String name, ApiCallback<List<UDFSharing>> _callback) throws ApiException {
        Call localVarCall = this.getUDFInfoSharingPoliciesValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<List<UDFSharing>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call handleCopyUDFCall(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UDFCopy localVarPostBody = udFCopy;
        String localVarPath = "/udf/{namespace}/{name}/copy".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (endTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleCopyUDFValidateBeforeCall(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling handleCopyUDF(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling handleCopyUDF(Async)");
        }
        if (udFCopy == null) {
            throw new ApiException("Missing the required parameter 'udFCopy' when calling handleCopyUDF(Async)");
        }
        Call localVarCall = this.handleCopyUDFCall(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        return localVarCall;
    }

    public UDFCopied handleCopyUDF(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        ApiResponse<UDFCopied> localVarResp = this.handleCopyUDFWithHttpInfo(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<UDFCopied> handleCopyUDFWithHttpInfo(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        Call localVarCall = this.handleCopyUDFValidateBeforeCall(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, null);
        Type localVarReturnType = new TypeToken<UDFCopied>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call handleCopyUDFAsync(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, ApiCallback<UDFCopied> _callback) throws ApiException {
        Call localVarCall = this.handleCopyUDFValidateBeforeCall(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<UDFCopied>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call registerUDFInfoCall(String namespace, String name, UDFInfoUpdate udf, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UDFInfoUpdate localVarPostBody = udf;
        String localVarPath = "/udf/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call registerUDFInfoValidateBeforeCall(String namespace, String name, UDFInfoUpdate udf, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerUDFInfo(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling registerUDFInfo(Async)");
        }
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling registerUDFInfo(Async)");
        }
        Call localVarCall = this.registerUDFInfoCall(namespace, name, udf, _callback);
        return localVarCall;
    }

    public void registerUDFInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        this.registerUDFInfoWithHttpInfo(namespace, name, udf);
    }

    public ApiResponse<Void> registerUDFInfoWithHttpInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        Call localVarCall = this.registerUDFInfoValidateBeforeCall(namespace, name, udf, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call registerUDFInfoAsync(String namespace, String name, UDFInfoUpdate udf, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.registerUDFInfoValidateBeforeCall(namespace, name, udf, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call shareUDFInfoCall(String namespace, String name, UDFSharing udfSharing, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UDFSharing localVarPostBody = udfSharing;
        String localVarPath = "/udf/{namespace}/{name}/share".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call shareUDFInfoValidateBeforeCall(String namespace, String name, UDFSharing udfSharing, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareUDFInfo(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling shareUDFInfo(Async)");
        }
        if (udfSharing == null) {
            throw new ApiException("Missing the required parameter 'udfSharing' when calling shareUDFInfo(Async)");
        }
        Call localVarCall = this.shareUDFInfoCall(namespace, name, udfSharing, _callback);
        return localVarCall;
    }

    public void shareUDFInfo(String namespace, String name, UDFSharing udfSharing) throws ApiException {
        this.shareUDFInfoWithHttpInfo(namespace, name, udfSharing);
    }

    public ApiResponse<Void> shareUDFInfoWithHttpInfo(String namespace, String name, UDFSharing udfSharing) throws ApiException {
        Call localVarCall = this.shareUDFInfoValidateBeforeCall(namespace, name, udfSharing, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call shareUDFInfoAsync(String namespace, String name, UDFSharing udfSharing, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.shareUDFInfoValidateBeforeCall(namespace, name, udfSharing, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call submitGenericUDFCall(String namespace, GenericUDF udf, String acceptEncoding, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GenericUDF localVarPostBody = udf;
        String localVarPath = "/udfs/generic/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitGenericUDFValidateBeforeCall(String namespace, GenericUDF udf, String acceptEncoding, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitGenericUDF(Async)");
        }
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling submitGenericUDF(Async)");
        }
        Call localVarCall = this.submitGenericUDFCall(namespace, udf, acceptEncoding, _callback);
        return localVarCall;
    }

    public File submitGenericUDF(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<File> localVarResp = this.submitGenericUDFWithHttpInfo(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<File> submitGenericUDFWithHttpInfo(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitGenericUDFAsync(String namespace, GenericUDF udf, String acceptEncoding, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitMultiArrayUDFCall(String namespace, MultiArrayUDF udf, String acceptEncoding, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MultiArrayUDF localVarPostBody = udf;
        String localVarPath = "/udfs/arrays/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitMultiArrayUDFValidateBeforeCall(String namespace, MultiArrayUDF udf, String acceptEncoding, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitMultiArrayUDF(Async)");
        }
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling submitMultiArrayUDF(Async)");
        }
        Call localVarCall = this.submitMultiArrayUDFCall(namespace, udf, acceptEncoding, _callback);
        return localVarCall;
    }

    public File submitMultiArrayUDF(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<File> localVarResp = this.submitMultiArrayUDFWithHttpInfo(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    public ApiResponse<File> submitMultiArrayUDFWithHttpInfo(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        Call localVarCall = this.submitMultiArrayUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitMultiArrayUDFAsync(String namespace, MultiArrayUDF udf, String acceptEncoding, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.submitMultiArrayUDFValidateBeforeCall(namespace, udf, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitUDFCall(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MultiArrayUDF localVarPostBody = udf;
        String localVarPath = "/arrays/{namespace}/{array}/udf/submit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (v2 != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("v2", v2));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitUDFValidateBeforeCall(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitUDF(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitUDF(Async)");
        }
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling submitUDF(Async)");
        }
        Call localVarCall = this.submitUDFCall(namespace, array, udf, xPayer, acceptEncoding, v2, _callback);
        return localVarCall;
    }

    public File submitUDF(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        ApiResponse<File> localVarResp = this.submitUDFWithHttpInfo(namespace, array, udf, xPayer, acceptEncoding, v2);
        return localVarResp.getData();
    }

    public ApiResponse<File> submitUDFWithHttpInfo(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        Call localVarCall = this.submitUDFValidateBeforeCall(namespace, array, udf, xPayer, acceptEncoding, v2, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitUDFAsync(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.submitUDFValidateBeforeCall(namespace, array, udf, xPayer, acceptEncoding, v2, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call udfNamespaceArrayEndTimestampsGetCall(String namespace, String array, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/udf/{namespace}/{array}/end_timestamps".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call udfNamespaceArrayEndTimestampsGetValidateBeforeCall(String namespace, String array, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling udfNamespaceArrayEndTimestampsGet(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling udfNamespaceArrayEndTimestampsGet(Async)");
        }
        Call localVarCall = this.udfNamespaceArrayEndTimestampsGetCall(namespace, array, page, perPage, _callback);
        return localVarCall;
    }

    public ArrayEndTimestampData udfNamespaceArrayEndTimestampsGet(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        ApiResponse<ArrayEndTimestampData> localVarResp = this.udfNamespaceArrayEndTimestampsGetWithHttpInfo(namespace, array, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayEndTimestampData> udfNamespaceArrayEndTimestampsGetWithHttpInfo(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.udfNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, null);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call udfNamespaceArrayEndTimestampsGetAsync(String namespace, String array, Integer page, Integer perPage, ApiCallback<ArrayEndTimestampData> _callback) throws ApiException {
        Call localVarCall = this.udfNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateUDFInfoCall(String namespace, String name, UDFInfoUpdate udf, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UDFInfoUpdate localVarPostBody = udf;
        String localVarPath = "/udf/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUDFInfoValidateBeforeCall(String namespace, String name, UDFInfoUpdate udf, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateUDFInfo(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateUDFInfo(Async)");
        }
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling updateUDFInfo(Async)");
        }
        Call localVarCall = this.updateUDFInfoCall(namespace, name, udf, _callback);
        return localVarCall;
    }

    public void updateUDFInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        this.updateUDFInfoWithHttpInfo(namespace, name, udf);
    }

    public ApiResponse<Void> updateUDFInfoWithHttpInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        Call localVarCall = this.updateUDFInfoValidateBeforeCall(namespace, name, udf, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateUDFInfoAsync(String namespace, String name, UDFInfoUpdate udf, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateUDFInfoValidateBeforeCall(namespace, name, udf, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

