/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.AWSAccessCredentials;
import io.tiledb.cloud.rest_api.model.OrganizationUser;
import io.tiledb.cloud.rest_api.model.ResetUserPasswordRequest;
import io.tiledb.cloud.rest_api.model.Token;
import io.tiledb.cloud.rest_api.model.TokenRequest;
import io.tiledb.cloud.rest_api.model.TokenScope;
import io.tiledb.cloud.rest_api.model.User;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class UserApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addAWSAccessCredentialsCall(String namespace, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AWSAccessCredentials localVarPostBody = awsAccessCredentials;
        String localVarPath = "/credentials/{namespace}/aws".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAWSAccessCredentialsValidateBeforeCall(String namespace, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling addAWSAccessCredentials(Async)");
        }
        if (awsAccessCredentials == null) {
            throw new ApiException("Missing the required parameter 'awsAccessCredentials' when calling addAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.addAWSAccessCredentialsCall(namespace, awsAccessCredentials, _callback);
        return localVarCall;
    }

    public void addAWSAccessCredentials(String namespace, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        this.addAWSAccessCredentialsWithHttpInfo(namespace, awsAccessCredentials);
    }

    public ApiResponse<Void> addAWSAccessCredentialsWithHttpInfo(String namespace, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        Call localVarCall = this.addAWSAccessCredentialsValidateBeforeCall(namespace, awsAccessCredentials, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call addAWSAccessCredentialsAsync(String namespace, AWSAccessCredentials awsAccessCredentials, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addAWSAccessCredentialsValidateBeforeCall(namespace, awsAccessCredentials, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call addUserToOrganizationCall(String organization, OrganizationUser user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrganizationUser localVarPostBody = user;
        String localVarPath = "/organizations/{organization}/user".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addUserToOrganizationValidateBeforeCall(String organization, OrganizationUser user, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling addUserToOrganization(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling addUserToOrganization(Async)");
        }
        Call localVarCall = this.addUserToOrganizationCall(organization, user, _callback);
        return localVarCall;
    }

    public void addUserToOrganization(String organization, OrganizationUser user) throws ApiException {
        this.addUserToOrganizationWithHttpInfo(organization, user);
    }

    public ApiResponse<Void> addUserToOrganizationWithHttpInfo(String organization, OrganizationUser user) throws ApiException {
        Call localVarCall = this.addUserToOrganizationValidateBeforeCall(organization, user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call addUserToOrganizationAsync(String organization, OrganizationUser user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addUserToOrganizationValidateBeforeCall(organization, user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call checkAWSAccessCredentialsCall(String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/aws".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkAWSAccessCredentialsValidateBeforeCall(String namespace, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling checkAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.checkAWSAccessCredentialsCall(namespace, _callback);
        return localVarCall;
    }

    public List<AWSAccessCredentials> checkAWSAccessCredentials(String namespace) throws ApiException {
        ApiResponse<List<AWSAccessCredentials>> localVarResp = this.checkAWSAccessCredentialsWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    public ApiResponse<List<AWSAccessCredentials>> checkAWSAccessCredentialsWithHttpInfo(String namespace) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<List<AWSAccessCredentials>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call checkAWSAccessCredentialsAsync(String namespace, ApiCallback<List<AWSAccessCredentials>> _callback) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<List<AWSAccessCredentials>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call checkAWSAccessCredentialsByNameCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/aws/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkAWSAccessCredentialsByNameValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling checkAWSAccessCredentialsByName(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling checkAWSAccessCredentialsByName(Async)");
        }
        Call localVarCall = this.checkAWSAccessCredentialsByNameCall(namespace, name, _callback);
        return localVarCall;
    }

    public AWSAccessCredentials checkAWSAccessCredentialsByName(String namespace, String name) throws ApiException {
        ApiResponse<AWSAccessCredentials> localVarResp = this.checkAWSAccessCredentialsByNameWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    public ApiResponse<AWSAccessCredentials> checkAWSAccessCredentialsByNameWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsByNameValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<AWSAccessCredentials>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call checkAWSAccessCredentialsByNameAsync(String namespace, String name, ApiCallback<AWSAccessCredentials> _callback) throws ApiException {
        Call localVarCall = this.checkAWSAccessCredentialsByNameValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<AWSAccessCredentials>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call confirmEmailCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user/confirm_email";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call confirmEmailValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.confirmEmailCall(_callback);
        return localVarCall;
    }

    public void confirmEmail() throws ApiException {
        this.confirmEmailWithHttpInfo();
    }

    public ApiResponse<Void> confirmEmailWithHttpInfo() throws ApiException {
        Call localVarCall = this.confirmEmailValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call confirmEmailAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.confirmEmailValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createUserCall(User user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        User localVarPostBody = user;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserValidateBeforeCall(User user, ApiCallback _callback) throws ApiException {
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling createUser(Async)");
        }
        Call localVarCall = this.createUserCall(user, _callback);
        return localVarCall;
    }

    public void createUser(User user) throws ApiException {
        this.createUserWithHttpInfo(user);
    }

    public ApiResponse<Void> createUserWithHttpInfo(User user) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUserAsync(User user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteAWSAccessCredentialsCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/aws/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAWSAccessCredentialsValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteAWSAccessCredentials(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.deleteAWSAccessCredentialsCall(namespace, name, _callback);
        return localVarCall;
    }

    public void deleteAWSAccessCredentials(String namespace, String name) throws ApiException {
        this.deleteAWSAccessCredentialsWithHttpInfo(namespace, name);
    }

    public ApiResponse<Void> deleteAWSAccessCredentialsWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.deleteAWSAccessCredentialsValidateBeforeCall(namespace, name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAWSAccessCredentialsAsync(String namespace, String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAWSAccessCredentialsValidateBeforeCall(namespace, name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserCall(String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{username}".replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(String username, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling deleteUser(Async)");
        }
        Call localVarCall = this.deleteUserCall(username, _callback);
        return localVarCall;
    }

    public void deleteUser(String username) throws ApiException {
        this.deleteUserWithHttpInfo(username);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(String username) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(username, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserAsync(String username, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(username, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserFromOrganizationCall(String organization, String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/{username}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserFromOrganizationValidateBeforeCall(String organization, String username, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling deleteUserFromOrganization(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling deleteUserFromOrganization(Async)");
        }
        Call localVarCall = this.deleteUserFromOrganizationCall(organization, username, _callback);
        return localVarCall;
    }

    public void deleteUserFromOrganization(String organization, String username) throws ApiException {
        this.deleteUserFromOrganizationWithHttpInfo(organization, username);
    }

    public ApiResponse<Void> deleteUserFromOrganizationWithHttpInfo(String organization, String username) throws ApiException {
        Call localVarCall = this.deleteUserFromOrganizationValidateBeforeCall(organization, username, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserFromOrganizationAsync(String organization, String username, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserFromOrganizationValidateBeforeCall(organization, username, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getOrganizationUserCall(String organization, String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/organizations/{organization}/{username}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrganizationUserValidateBeforeCall(String organization, String username, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling getOrganizationUser(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling getOrganizationUser(Async)");
        }
        Call localVarCall = this.getOrganizationUserCall(organization, username, _callback);
        return localVarCall;
    }

    public OrganizationUser getOrganizationUser(String organization, String username) throws ApiException {
        ApiResponse<OrganizationUser> localVarResp = this.getOrganizationUserWithHttpInfo(organization, username);
        return localVarResp.getData();
    }

    public ApiResponse<OrganizationUser> getOrganizationUserWithHttpInfo(String organization, String username) throws ApiException {
        Call localVarCall = this.getOrganizationUserValidateBeforeCall(organization, username, null);
        Type localVarReturnType = new TypeToken<OrganizationUser>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrganizationUserAsync(String organization, String username, ApiCallback<OrganizationUser> _callback) throws ApiException {
        Call localVarCall = this.getOrganizationUserValidateBeforeCall(organization, username, _callback);
        Type localVarReturnType = new TypeToken<OrganizationUser>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSessionCall(String rememberMe, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/session";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rememberMe != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("remember_me", rememberMe));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSessionValidateBeforeCall(String rememberMe, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getSessionCall(rememberMe, _callback);
        return localVarCall;
    }

    public Token getSession(String rememberMe) throws ApiException {
        ApiResponse<Token> localVarResp = this.getSessionWithHttpInfo(rememberMe);
        return localVarResp.getData();
    }

    public ApiResponse<Token> getSessionWithHttpInfo(String rememberMe) throws ApiException {
        Call localVarCall = this.getSessionValidateBeforeCall(rememberMe, null);
        Type localVarReturnType = new TypeToken<Token>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSessionAsync(String rememberMe, ApiCallback<Token> _callback) throws ApiException {
        Call localVarCall = this.getSessionValidateBeforeCall(rememberMe, _callback);
        Type localVarReturnType = new TypeToken<Token>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTokenScopesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/tokens/scopes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTokenScopesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTokenScopesCall(_callback);
        return localVarCall;
    }

    public List<TokenScope> getTokenScopes() throws ApiException {
        ApiResponse<List<TokenScope>> localVarResp = this.getTokenScopesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<TokenScope>> getTokenScopesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getTokenScopesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<TokenScope>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTokenScopesAsync(ApiCallback<List<TokenScope>> _callback) throws ApiException {
        Call localVarCall = this.getTokenScopesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<TokenScope>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUserCall(_callback);
        return localVarCall;
    }

    public User getUser() throws ApiException {
        ApiResponse<User> localVarResp = this.getUserWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<User> getUserWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserAsync(ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserWithUsernameCall(String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{username}".replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserWithUsernameValidateBeforeCall(String username, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling getUserWithUsername(Async)");
        }
        Call localVarCall = this.getUserWithUsernameCall(username, _callback);
        return localVarCall;
    }

    public User getUserWithUsername(String username) throws ApiException {
        ApiResponse<User> localVarResp = this.getUserWithUsernameWithHttpInfo(username);
        return localVarResp.getData();
    }

    public ApiResponse<User> getUserWithUsernameWithHttpInfo(String username) throws ApiException {
        Call localVarCall = this.getUserWithUsernameValidateBeforeCall(username, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserWithUsernameAsync(String username, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.getUserWithUsernameValidateBeforeCall(username, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call requestTokenCall(TokenRequest tokenRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TokenRequest localVarPostBody = tokenRequest;
        String localVarPath = "/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call requestTokenValidateBeforeCall(TokenRequest tokenRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.requestTokenCall(tokenRequest, _callback);
        return localVarCall;
    }

    public Token requestToken(TokenRequest tokenRequest) throws ApiException {
        ApiResponse<Token> localVarResp = this.requestTokenWithHttpInfo(tokenRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Token> requestTokenWithHttpInfo(TokenRequest tokenRequest) throws ApiException {
        Call localVarCall = this.requestTokenValidateBeforeCall(tokenRequest, null);
        Type localVarReturnType = new TypeToken<Token>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call requestTokenAsync(TokenRequest tokenRequest, ApiCallback<Token> _callback) throws ApiException {
        Call localVarCall = this.requestTokenValidateBeforeCall(tokenRequest, _callback);
        Type localVarReturnType = new TypeToken<Token>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetUserPasswordCall(ResetUserPasswordRequest user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetUserPasswordRequest localVarPostBody = user;
        String localVarPath = "/user/password_reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetUserPasswordValidateBeforeCall(ResetUserPasswordRequest user, ApiCallback _callback) throws ApiException {
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling resetUserPassword(Async)");
        }
        Call localVarCall = this.resetUserPasswordCall(user, _callback);
        return localVarCall;
    }

    public void resetUserPassword(ResetUserPasswordRequest user) throws ApiException {
        this.resetUserPasswordWithHttpInfo(user);
    }

    public ApiResponse<Void> resetUserPasswordWithHttpInfo(ResetUserPasswordRequest user) throws ApiException {
        Call localVarCall = this.resetUserPasswordValidateBeforeCall(user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetUserPasswordAsync(ResetUserPasswordRequest user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetUserPasswordValidateBeforeCall(user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call revokeTokenCall(String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/tokens/{token}".replaceAll("\\{token\\}", this.localVarApiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeTokenValidateBeforeCall(String token, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling revokeToken(Async)");
        }
        Call localVarCall = this.revokeTokenCall(token, _callback);
        return localVarCall;
    }

    public void revokeToken(String token) throws ApiException {
        this.revokeTokenWithHttpInfo(token);
    }

    public ApiResponse<Void> revokeTokenWithHttpInfo(String token) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeTokenAsync(String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call tokensGetCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call tokensGetValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.tokensGetCall(_callback);
        return localVarCall;
    }

    public List<Token> tokensGet() throws ApiException {
        ApiResponse<List<Token>> localVarResp = this.tokensGetWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Token>> tokensGetWithHttpInfo() throws ApiException {
        Call localVarCall = this.tokensGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Token>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call tokensGetAsync(ApiCallback<List<Token>> _callback) throws ApiException {
        Call localVarCall = this.tokensGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Token>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tokensSessionGetCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/tokens/session";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call tokensSessionGetValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.tokensSessionGetCall(_callback);
        return localVarCall;
    }

    public List<Token> tokensSessionGet() throws ApiException {
        ApiResponse<List<Token>> localVarResp = this.tokensSessionGetWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Token>> tokensSessionGetWithHttpInfo() throws ApiException {
        Call localVarCall = this.tokensSessionGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Token>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call tokensSessionGetAsync(ApiCallback<List<Token>> _callback) throws ApiException {
        Call localVarCall = this.tokensSessionGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Token>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAWSAccessCredentialsCall(String namespace, String name, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AWSAccessCredentials localVarPostBody = awsAccessCredentials;
        String localVarPath = "/credentials/{namespace}/aws/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAWSAccessCredentialsValidateBeforeCall(String namespace, String name, AWSAccessCredentials awsAccessCredentials, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateAWSAccessCredentials(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateAWSAccessCredentials(Async)");
        }
        if (awsAccessCredentials == null) {
            throw new ApiException("Missing the required parameter 'awsAccessCredentials' when calling updateAWSAccessCredentials(Async)");
        }
        Call localVarCall = this.updateAWSAccessCredentialsCall(namespace, name, awsAccessCredentials, _callback);
        return localVarCall;
    }

    public void updateAWSAccessCredentials(String namespace, String name, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        this.updateAWSAccessCredentialsWithHttpInfo(namespace, name, awsAccessCredentials);
    }

    public ApiResponse<Void> updateAWSAccessCredentialsWithHttpInfo(String namespace, String name, AWSAccessCredentials awsAccessCredentials) throws ApiException {
        Call localVarCall = this.updateAWSAccessCredentialsValidateBeforeCall(namespace, name, awsAccessCredentials, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateAWSAccessCredentialsAsync(String namespace, String name, AWSAccessCredentials awsAccessCredentials, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateAWSAccessCredentialsValidateBeforeCall(namespace, name, awsAccessCredentials, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateUserCall(String username, User user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        User localVarPostBody = user;
        String localVarPath = "/users/{username}".replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUserValidateBeforeCall(String username, User user, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling updateUser(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling updateUser(Async)");
        }
        Call localVarCall = this.updateUserCall(username, user, _callback);
        return localVarCall;
    }

    public void updateUser(String username, User user) throws ApiException {
        this.updateUserWithHttpInfo(username, user);
    }

    public ApiResponse<Void> updateUserWithHttpInfo(String username, User user) throws ApiException {
        Call localVarCall = this.updateUserValidateBeforeCall(username, user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateUserAsync(String username, User user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateUserValidateBeforeCall(username, user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateUserInOrganizationCall(String organization, String username, OrganizationUser user, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrganizationUser localVarPostBody = user;
        String localVarPath = "/organizations/{organization}/{username}".replaceAll("\\{organization\\}", this.localVarApiClient.escapeString(organization.toString())).replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUserInOrganizationValidateBeforeCall(String organization, String username, OrganizationUser user, ApiCallback _callback) throws ApiException {
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling updateUserInOrganization(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling updateUserInOrganization(Async)");
        }
        if (user == null) {
            throw new ApiException("Missing the required parameter 'user' when calling updateUserInOrganization(Async)");
        }
        Call localVarCall = this.updateUserInOrganizationCall(organization, username, user, _callback);
        return localVarCall;
    }

    public void updateUserInOrganization(String organization, String username, OrganizationUser user) throws ApiException {
        this.updateUserInOrganizationWithHttpInfo(organization, username, user);
    }

    public ApiResponse<Void> updateUserInOrganizationWithHttpInfo(String organization, String username, OrganizationUser user) throws ApiException {
        Call localVarCall = this.updateUserInOrganizationValidateBeforeCall(organization, username, user, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateUserInOrganizationAsync(String organization, String username, OrganizationUser user, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateUserInOrganizationValidateBeforeCall(organization, username, user, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

