/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Model representing aws keys or service role, service roles are currently ignored, but will be preferred option in the future")
public class AWSAccessCredentials {
    public static final String SERIALIZED_NAME_SECRET_ACCESS_KEY = "secret_access_key";
    @SerializedName(value="secret_access_key")
    private String secretAccessKey;
    public static final String SERIALIZED_NAME_ACCESS_KEY_ID = "access_key_id";
    @SerializedName(value="access_key_id")
    private String accessKeyId;
    public static final String SERIALIZED_NAME_SERVICE_ROLE_ARN = "service_role_arn";
    @SerializedName(value="service_role_arn")
    private String serviceRoleArn;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    private Boolean _default;
    public static final String SERIALIZED_NAME_BUCKETS = "buckets";
    @SerializedName(value="buckets")
    private List<String> buckets = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AWSAccessCredentials() {
    }

    public AWSAccessCredentials(OffsetDateTime createdAt, OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public AWSAccessCredentials secretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="aws secret access key, never returned in get requests")
    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public AWSAccessCredentials accessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="aws access key")
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public AWSAccessCredentials serviceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="aws service role to use for access")
    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public AWSAccessCredentials name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="human readable name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AWSAccessCredentials _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="true if this is the default credential to be used within this namespace")
    public Boolean getDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public AWSAccessCredentials buckets(List<String> buckets) {
        this.buckets = buckets;
        return this;
    }

    public AWSAccessCredentials addBucketsItem(String bucketsItem) {
        if (this.buckets == null) {
            this.buckets = new ArrayList<String>();
        }
        this.buckets.add(bucketsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="a whitelist of one or more buckets this key should access")
    public List<String> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(List<String> buckets) {
        this.buckets = buckets;
    }

    @Nullable
    @ApiModelProperty(value="Time when UDF dependencies were created (rfc3339)")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="Time when UDF dependencies was last updated (rfc3339)")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public AWSAccessCredentials putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccessCredentials awSAccessCredentials = (AWSAccessCredentials)o;
        return Objects.equals(this.secretAccessKey, awSAccessCredentials.secretAccessKey) && Objects.equals(this.accessKeyId, awSAccessCredentials.accessKeyId) && Objects.equals(this.serviceRoleArn, awSAccessCredentials.serviceRoleArn) && Objects.equals(this.name, awSAccessCredentials.name) && Objects.equals(this._default, awSAccessCredentials._default) && Objects.equals(this.buckets, awSAccessCredentials.buckets) && Objects.equals(this.createdAt, awSAccessCredentials.createdAt) && Objects.equals(this.updatedAt, awSAccessCredentials.updatedAt) && Objects.equals(this.additionalProperties, awSAccessCredentials.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.secretAccessKey, this.accessKeyId, this.serviceRoleArn, this.name, this._default, this.buckets, this.createdAt, this.updatedAt, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccessCredentials {\n");
        sb.append("    secretAccessKey: ").append(this.toIndentedString(this.secretAccessKey)).append("\n");
        sb.append("    accessKeyId: ").append(this.toIndentedString(this.accessKeyId)).append("\n");
        sb.append("    serviceRoleArn: ").append(this.toIndentedString(this.serviceRoleArn)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    buckets: ").append(this.toIndentedString(this.buckets)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AWSAccessCredentials is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY) != null && !jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secret_access_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_key_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_ROLE_ARN) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_ROLE_ARN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERVICE_ROLE_ARN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `service_role_arn` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_ROLE_ARN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUCKETS) != null && !jsonObj.get(SERIALIZED_NAME_BUCKETS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BUCKETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `buckets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUCKETS).toString()));
        }
    }

    public static AWSAccessCredentials fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, AWSAccessCredentials.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SECRET_ACCESS_KEY);
        openapiFields.add(SERIALIZED_NAME_ACCESS_KEY_ID);
        openapiFields.add(SERIALIZED_NAME_SERVICE_ROLE_ARN);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_BUCKETS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AWSAccessCredentials.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AWSAccessCredentials> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(AWSAccessCredentials.class));
            return new TypeAdapter<AWSAccessCredentials>(){

                @Override
                public void write(JsonWriter out, AWSAccessCredentials value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public AWSAccessCredentials read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AWSAccessCredentials.validateJsonObject(jsonObj);
                    AWSAccessCredentials instance = (AWSAccessCredentials)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

