/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ActivityEventType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Actvity of an Array")
public class ArrayActivityLog {
    public static final String SERIALIZED_NAME_EVENT_AT = "event_at";
    @SerializedName(value="event_at")
    private OffsetDateTime eventAt;
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private ActivityEventType action;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_BYTES_SENT = "bytes_sent";
    @SerializedName(value="bytes_sent")
    private Integer bytesSent;
    public static final String SERIALIZED_NAME_BYTES_RECEIVED = "bytes_received";
    @SerializedName(value="bytes_received")
    private Integer bytesReceived;
    public static final String SERIALIZED_NAME_ARRAY_TASK_ID = "array_task_id";
    @SerializedName(value="array_task_id")
    private String arrayTaskId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_QUERY_RANGES = "query_ranges";
    @SerializedName(value="query_ranges")
    private String queryRanges;
    public static final String SERIALIZED_NAME_QUERY_STATS = "query_stats";
    @SerializedName(value="query_stats")
    private String queryStats;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ArrayActivityLog eventAt(OffsetDateTime eventAt) {
        this.eventAt = eventAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="time event took place (RFC3339)")
    public OffsetDateTime getEventAt() {
        return this.eventAt;
    }

    public void setEventAt(OffsetDateTime eventAt) {
        this.eventAt = eventAt;
    }

    public ArrayActivityLog action(ActivityEventType action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ActivityEventType getAction() {
        return this.action;
    }

    public void setAction(ActivityEventType action) {
        this.action = action;
    }

    public ArrayActivityLog username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user1", value="User who performed action")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ArrayActivityLog bytesSent(Integer bytesSent) {
        this.bytesSent = bytesSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="Bytes sent to client")
    public Integer getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(Integer bytesSent) {
        this.bytesSent = bytesSent;
    }

    public ArrayActivityLog bytesReceived(Integer bytesReceived) {
        this.bytesReceived = bytesReceived;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="Bytes recieved from client")
    public Integer getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(Integer bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public ArrayActivityLog arrayTaskId(String arrayTaskId) {
        this.arrayTaskId = arrayTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="UUID of associated array task")
    public String getArrayTaskId() {
        return this.arrayTaskId;
    }

    public void setArrayTaskId(String arrayTaskId) {
        this.arrayTaskId = arrayTaskId;
    }

    public ArrayActivityLog id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="ID of the activity")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ArrayActivityLog queryRanges(String queryRanges) {
        this.queryRanges = queryRanges;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"rows\":[{\"start\": 1, \"end\": 1},{\"start\": 3, \"end\": 4}],\"cols\":[{\"start\": 1, \"end\": 4}]}", value="ranges for query")
    public String getQueryRanges() {
        return this.queryRanges;
    }

    public void setQueryRanges(String queryRanges) {
        this.queryRanges = queryRanges;
    }

    public ArrayActivityLog queryStats(String queryStats) {
        this.queryStats = queryStats;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"timers\": {\"Context.StorageManager.read_load_array_schema_from_uri.sum\": 0.0255293, \"...\": \"...\"}, \"counters\": {\"Context.StorageManager.read_unfiltered_byte_num\": 191, \"...\": \"...\"}}", value="stats for query")
    public String getQueryStats() {
        return this.queryStats;
    }

    public void setQueryStats(String queryStats) {
        this.queryStats = queryStats;
    }

    public ArrayActivityLog putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayActivityLog arrayActivityLog = (ArrayActivityLog)o;
        return Objects.equals(this.eventAt, arrayActivityLog.eventAt) && Objects.equals((Object)this.action, (Object)arrayActivityLog.action) && Objects.equals(this.username, arrayActivityLog.username) && Objects.equals(this.bytesSent, arrayActivityLog.bytesSent) && Objects.equals(this.bytesReceived, arrayActivityLog.bytesReceived) && Objects.equals(this.arrayTaskId, arrayActivityLog.arrayTaskId) && Objects.equals(this.id, arrayActivityLog.id) && Objects.equals(this.queryRanges, arrayActivityLog.queryRanges) && Objects.equals(this.queryStats, arrayActivityLog.queryStats) && Objects.equals(this.additionalProperties, arrayActivityLog.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventAt, this.action, this.username, this.bytesSent, this.bytesReceived, this.arrayTaskId, this.id, this.queryRanges, this.queryStats, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayActivityLog {\n");
        sb.append("    eventAt: ").append(this.toIndentedString(this.eventAt)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    bytesSent: ").append(this.toIndentedString(this.bytesSent)).append("\n");
        sb.append("    bytesReceived: ").append(this.toIndentedString(this.bytesReceived)).append("\n");
        sb.append("    arrayTaskId: ").append(this.toIndentedString(this.arrayTaskId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    queryRanges: ").append(this.toIndentedString(this.queryRanges)).append("\n");
        sb.append("    queryStats: ").append(this.toIndentedString(this.queryStats)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayActivityLog is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_TASK_ID) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_TASK_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_TASK_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_task_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_TASK_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUERY_RANGES) != null && !jsonObj.get(SERIALIZED_NAME_QUERY_RANGES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QUERY_RANGES).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `query_ranges` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUERY_RANGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUERY_STATS) != null && !jsonObj.get(SERIALIZED_NAME_QUERY_STATS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QUERY_STATS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `query_stats` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUERY_STATS).toString()));
        }
    }

    public static ArrayActivityLog fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ArrayActivityLog.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EVENT_AT);
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_BYTES_SENT);
        openapiFields.add(SERIALIZED_NAME_BYTES_RECEIVED);
        openapiFields.add(SERIALIZED_NAME_ARRAY_TASK_ID);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_QUERY_RANGES);
        openapiFields.add(SERIALIZED_NAME_QUERY_STATS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ArrayActivityLog.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ArrayActivityLog> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ArrayActivityLog.class));
            return new TypeAdapter<ArrayActivityLog>(){

                @Override
                public void write(JsonWriter out, ArrayActivityLog value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ArrayActivityLog read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ArrayActivityLog.validateJsonObject(jsonObj);
                    ArrayActivityLog instance = (ArrayActivityLog)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

