/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArrayActions;
import io.tiledb.cloud.rest_api.model.ArrayType;
import io.tiledb.cloud.rest_api.model.FileType;
import io.tiledb.cloud.rest_api.model.Pricing;
import io.tiledb.cloud.rest_api.model.Subscription;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="metadata of an array")
public class ArrayInfo {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_FILE_TYPE = "file_type";
    @SerializedName(value="file_type")
    private FileType fileType;
    public static final String SERIALIZED_NAME_FILE_PROPERTIES = "file_properties";
    @SerializedName(value="file_properties")
    private Map<String, String> fileProperties = null;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private BigDecimal size;
    public static final String SERIALIZED_NAME_LAST_ACCESSED = "last_accessed";
    @SerializedName(value="last_accessed")
    private OffsetDateTime lastAccessed;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
    @SerializedName(value="allowed_actions")
    private List<ArrayActions> allowedActions = null;
    public static final String SERIALIZED_NAME_PRICING = "pricing";
    @SerializedName(value="pricing")
    private List<Pricing> pricing = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private List<Subscription> subscriptions = null;
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME = "access_credentials_name";
    @SerializedName(value="access_credentials_name")
    private String accessCredentialsName;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private ArrayType type;
    public static final String SERIALIZED_NAME_SHARE_COUNT = "share_count";
    @SerializedName(value="share_count")
    private BigDecimal shareCount;
    public static final String SERIALIZED_NAME_PUBLIC_SHARE = "public_share";
    @SerializedName(value="public_share")
    private Boolean publicShare;
    public static final String SERIALIZED_NAME_NAMESPACE_SUBSCRIBED = "namespace_subscribed";
    @SerializedName(value="namespace_subscribed")
    private Boolean namespaceSubscribed;
    public static final String SERIALIZED_NAME_TILEDB_URI = "tiledb_uri";
    @SerializedName(value="tiledb_uri")
    private String tiledbUri;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
    @SerializedName(value="license_id")
    private String licenseId;
    public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
    @SerializedName(value="license_text")
    private String licenseText;
    public static final String SERIALIZED_NAME_READ_ONLY = "read_only";
    @SerializedName(value="read_only")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_IS_FAVORITE = "is_favorite";
    @SerializedName(value="is_favorite")
    private Boolean isFavorite;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ArrayInfo() {
    }

    public ArrayInfo(Boolean namespaceSubscribed) {
        this();
        this.namespaceSubscribed = namespaceSubscribed;
    }

    public ArrayInfo id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of registered array")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ArrayInfo fileType(FileType fileType) {
        this.fileType = fileType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public ArrayInfo fileProperties(Map<String, String> fileProperties) {
        this.fileProperties = fileProperties;
        return this;
    }

    public ArrayInfo putFilePropertiesItem(String key, String filePropertiesItem) {
        if (this.fileProperties == null) {
            this.fileProperties = new HashMap<String, String>();
        }
        this.fileProperties.put(key, filePropertiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="map of file properties created for this array")
    public Map<String, String> getFileProperties() {
        return this.fileProperties;
    }

    public void setFileProperties(Map<String, String> fileProperties) {
        this.fileProperties = fileProperties;
    }

    public ArrayInfo uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="s3://bucket/array", value="uri of array")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ArrayInfo namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user1", value="namespace array is in")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ArrayInfo size(BigDecimal size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1024.0", value="size in bytes of array")
    public BigDecimal getSize() {
        return this.size;
    }

    public void setSize(BigDecimal size) {
        this.size = size;
    }

    public ArrayInfo lastAccessed(OffsetDateTime lastAccessed) {
        this.lastAccessed = lastAccessed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime array was last accessed in UTC")
    public OffsetDateTime getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(OffsetDateTime lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public ArrayInfo description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description of array")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayInfo name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="myarray1", value="name of array")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayInfo allowedActions(List<ArrayActions> allowedActions) {
        this.allowedActions = allowedActions;
        return this;
    }

    public ArrayInfo addAllowedActionsItem(ArrayActions allowedActionsItem) {
        if (this.allowedActions == null) {
            this.allowedActions = new ArrayList<ArrayActions>();
        }
        this.allowedActions.add(allowedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of actions user is allowed to do on this array")
    public List<ArrayActions> getAllowedActions() {
        return this.allowedActions;
    }

    public void setAllowedActions(List<ArrayActions> allowedActions) {
        this.allowedActions = allowedActions;
    }

    public ArrayInfo pricing(List<Pricing> pricing) {
        this.pricing = pricing;
        return this;
    }

    public ArrayInfo addPricingItem(Pricing pricingItem) {
        if (this.pricing == null) {
            this.pricing = new ArrayList<Pricing>();
        }
        this.pricing.add(pricingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of pricing created for this array")
    public List<Pricing> getPricing() {
        return this.pricing;
    }

    public void setPricing(List<Pricing> pricing) {
        this.pricing = pricing;
    }

    public ArrayInfo subscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public ArrayInfo addSubscriptionsItem(Subscription subscriptionsItem) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        this.subscriptions.add(subscriptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of subscriptions created for this array")
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public ArrayInfo logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="logo (base64 encoded) for the array. Optional")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public ArrayInfo accessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the name of the access credentials to use. if unset, the default credentials will be used")
    public String getAccessCredentialsName() {
        return this.accessCredentialsName;
    }

    public void setAccessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
    }

    public ArrayInfo type(ArrayType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayType getType() {
        return this.type;
    }

    public void setType(ArrayType type) {
        this.type = type;
    }

    public ArrayInfo shareCount(BigDecimal shareCount) {
        this.shareCount = shareCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="number of unique namespaces this array is shared with")
    public BigDecimal getShareCount() {
        return this.shareCount;
    }

    public void setShareCount(BigDecimal shareCount) {
        this.shareCount = shareCount;
    }

    public ArrayInfo publicShare(Boolean publicShare) {
        this.publicShare = publicShare;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Suggests if the array was shared to public by owner")
    public Boolean getPublicShare() {
        return this.publicShare;
    }

    public void setPublicShare(Boolean publicShare) {
        this.publicShare = publicShare;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Depends on the namespace asking, denotes the existence of subscription of namespace to this array")
    public Boolean getNamespaceSubscribed() {
        return this.namespaceSubscribed;
    }

    public ArrayInfo tiledbUri(String tiledbUri) {
        this.tiledbUri = tiledbUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="uri for access through TileDB cloud")
    public String getTiledbUri() {
        return this.tiledbUri;
    }

    public void setTiledbUri(String tiledbUri) {
        this.tiledbUri = tiledbUri;
    }

    public ArrayInfo tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ArrayInfo addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="optional tags for array")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ArrayInfo licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License identifier from SPDX License List or Custom")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public ArrayInfo licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License text")
    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public ArrayInfo readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Suggests if the array is in read_only mode")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ArrayInfo isFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates whether the array is in user favorites")
    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public ArrayInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayInfo arrayInfo = (ArrayInfo)o;
        return Objects.equals(this.id, arrayInfo.id) && Objects.equals((Object)this.fileType, (Object)arrayInfo.fileType) && Objects.equals(this.fileProperties, arrayInfo.fileProperties) && Objects.equals(this.uri, arrayInfo.uri) && Objects.equals(this.namespace, arrayInfo.namespace) && Objects.equals(this.size, arrayInfo.size) && Objects.equals(this.lastAccessed, arrayInfo.lastAccessed) && Objects.equals(this.description, arrayInfo.description) && Objects.equals(this.name, arrayInfo.name) && Objects.equals(this.allowedActions, arrayInfo.allowedActions) && Objects.equals(this.pricing, arrayInfo.pricing) && Objects.equals(this.subscriptions, arrayInfo.subscriptions) && Objects.equals(this.logo, arrayInfo.logo) && Objects.equals(this.accessCredentialsName, arrayInfo.accessCredentialsName) && Objects.equals((Object)this.type, (Object)arrayInfo.type) && Objects.equals(this.shareCount, arrayInfo.shareCount) && Objects.equals(this.publicShare, arrayInfo.publicShare) && Objects.equals(this.namespaceSubscribed, arrayInfo.namespaceSubscribed) && Objects.equals(this.tiledbUri, arrayInfo.tiledbUri) && Objects.equals(this.tags, arrayInfo.tags) && Objects.equals(this.licenseId, arrayInfo.licenseId) && Objects.equals(this.licenseText, arrayInfo.licenseText) && Objects.equals(this.readOnly, arrayInfo.readOnly) && Objects.equals(this.isFavorite, arrayInfo.isFavorite) && Objects.equals(this.additionalProperties, arrayInfo.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.fileType, this.fileProperties, this.uri, this.namespace, this.size, this.lastAccessed, this.description, this.name, this.allowedActions, this.pricing, this.subscriptions, this.logo, this.accessCredentialsName, this.type, this.shareCount, this.publicShare, this.namespaceSubscribed, this.tiledbUri, this.tags, this.licenseId, this.licenseText, this.readOnly, this.isFavorite, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    fileProperties: ").append(this.toIndentedString(this.fileProperties)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    lastAccessed: ").append(this.toIndentedString(this.lastAccessed)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    allowedActions: ").append(this.toIndentedString(this.allowedActions)).append("\n");
        sb.append("    pricing: ").append(this.toIndentedString(this.pricing)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    accessCredentialsName: ").append(this.toIndentedString(this.accessCredentialsName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    shareCount: ").append(this.toIndentedString(this.shareCount)).append("\n");
        sb.append("    publicShare: ").append(this.toIndentedString(this.publicShare)).append("\n");
        sb.append("    namespaceSubscribed: ").append(this.toIndentedString(this.namespaceSubscribed)).append("\n");
        sb.append("    tiledbUri: ").append(this.toIndentedString(this.tiledbUri)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    isFavorite: ").append(this.toIndentedString(this.isFavorite)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysubscriptions;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).toString()));
        }
        JsonArray jsonArraypricing = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRICING);
        if (jsonArraypricing != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRICING).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `pricing` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING).toString()));
            }
            for (int i = 0; i < jsonArraypricing.size(); ++i) {
                Pricing.validateJsonObject(jsonArraypricing.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraysubscriptions = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBSCRIPTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subscriptions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).toString()));
            }
            for (int i = 0; i < jsonArraysubscriptions.size(); ++i) {
                Subscription.validateJsonObject(jsonArraysubscriptions.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGO) != null && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILEDB_URI) != null && !jsonObj.get(SERIALIZED_NAME_TILEDB_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TILEDB_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tiledb_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILEDB_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_ID) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).toString()));
        }
    }

    public static ArrayInfo fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ArrayInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_FILE_TYPE);
        openapiFields.add(SERIALIZED_NAME_FILE_PROPERTIES);
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_LAST_ACCESSED);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_PRICING);
        openapiFields.add(SERIALIZED_NAME_SUBSCRIPTIONS);
        openapiFields.add(SERIALIZED_NAME_LOGO);
        openapiFields.add(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_SHARE_COUNT);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_SHARE);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE_SUBSCRIBED);
        openapiFields.add(SERIALIZED_NAME_TILEDB_URI);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_LICENSE_ID);
        openapiFields.add(SERIALIZED_NAME_LICENSE_TEXT);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_IS_FAVORITE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ArrayInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ArrayInfo> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ArrayInfo.class));
            return new TypeAdapter<ArrayInfo>(){

                @Override
                public void write(JsonWriter out, ArrayInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ArrayInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ArrayInfo.validateJsonObject(jsonObj);
                    ArrayInfo instance = (ArrayInfo)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

