/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArrayActivityLog;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.ArrayTaskStatus;
import io.tiledb.cloud.rest_api.model.ArrayTaskType;
import io.tiledb.cloud.rest_api.model.DomainArray;
import io.tiledb.cloud.rest_api.model.Querytype;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Synchronous Task to Run")
public class ArrayTask {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ARRAY_METADATA = "array_metadata";
    @SerializedName(value="array_metadata")
    private ArrayInfo arrayMetadata;
    public static final String SERIALIZED_NAME_SUBARRAY = "subarray";
    @SerializedName(value="subarray")
    private DomainArray subarray;
    public static final String SERIALIZED_NAME_MEMORY = "memory";
    @SerializedName(value="memory")
    private Integer memory;
    public static final String SERIALIZED_NAME_CPU = "cpu";
    @SerializedName(value="cpu")
    private Integer cpu;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private ArrayTaskStatus status;
    public static final String SERIALIZED_NAME_STATUS_MESSAGE = "status_message";
    @SerializedName(value="status_message")
    private String statusMessage;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_FINISH_TIME = "finish_time";
    @SerializedName(value="finish_time")
    private OffsetDateTime finishTime;
    public static final String SERIALIZED_NAME_COST = "cost";
    @SerializedName(value="cost")
    private Double cost;
    public static final String SERIALIZED_NAME_EGRESS_COST = "egress_cost";
    @SerializedName(value="egress_cost")
    private Double egressCost;
    public static final String SERIALIZED_NAME_ACCESS_COST = "access_cost";
    @SerializedName(value="access_cost")
    private Double accessCost;
    public static final String SERIALIZED_NAME_QUERY_TYPE = "query_type";
    @SerializedName(value="query_type")
    private Querytype queryType;
    public static final String SERIALIZED_NAME_UDF_CODE = "udf_code";
    @SerializedName(value="udf_code")
    private String udfCode;
    public static final String SERIALIZED_NAME_UDF_LANGUAGE = "udf_language";
    @SerializedName(value="udf_language")
    private String udfLanguage;
    public static final String SERIALIZED_NAME_SQL_QUERY = "sql_query";
    @SerializedName(value="sql_query")
    private String sqlQuery;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private ArrayTaskType type;
    public static final String SERIALIZED_NAME_ACTIVITY = "activity";
    @SerializedName(value="activity")
    private List<ArrayActivityLog> activity = null;
    public static final String SERIALIZED_NAME_LOGS = "logs";
    @SerializedName(value="logs")
    private String logs;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private BigDecimal duration;
    public static final String SERIALIZED_NAME_SQL_INIT_COMMANDS = "sql_init_commands";
    @SerializedName(value="sql_init_commands")
    private List<String> sqlInitCommands = null;
    public static final String SERIALIZED_NAME_SQL_PARAMETERS = "sql_parameters";
    @SerializedName(value="sql_parameters")
    private List<Object> sqlParameters = null;
    public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
    @SerializedName(value="result_format")
    private ResultFormat resultFormat;
    public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
    @SerializedName(value="task_graph_uuid")
    private String taskGraphUuid;
    public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
    @SerializedName(value="client_node_uuid")
    private String clientNodeUuid;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ArrayTask id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="task ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ArrayTask name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="subarray-multiplier", value="Optional task name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayTask username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="demo", value="username that executed this task")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ArrayTask description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Return attr a1 in the subarray bounded by coordinates and multiply attr1 by 2", value="Optional task description (Tasks purpose)")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayTask arrayMetadata(ArrayInfo arrayMetadata) {
        this.arrayMetadata = arrayMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayInfo getArrayMetadata() {
        return this.arrayMetadata;
    }

    public void setArrayMetadata(ArrayInfo arrayMetadata) {
        this.arrayMetadata = arrayMetadata;
    }

    public ArrayTask subarray(DomainArray subarray) {
        this.subarray = subarray;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DomainArray getSubarray() {
        return this.subarray;
    }

    public void setSubarray(DomainArray subarray) {
        this.subarray = subarray;
    }

    public ArrayTask memory(Integer memory) {
        this.memory = memory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="memory allocated to task in bytes")
    public Integer getMemory() {
        return this.memory;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public ArrayTask cpu(Integer cpu) {
        this.cpu = cpu;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4000", value="millicpu allocated to task")
    public Integer getCpu() {
        return this.cpu;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public ArrayTask namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="organization1", value="namespace task is tied to")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ArrayTask status(ArrayTaskStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayTaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(ArrayTaskStatus status) {
        this.status = status;
    }

    public ArrayTask statusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason the array task status is in the state")
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public ArrayTask startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Start time RFC3339 for job")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public ArrayTask finishTime(OffsetDateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Finish time RFC3339 for job")
    public OffsetDateTime getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(OffsetDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public ArrayTask cost(Double cost) {
        this.cost = cost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.12", value="Total accumulated for task in USD, example is $0.12")
    public Double getCost() {
        return this.cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public ArrayTask egressCost(Double egressCost) {
        this.egressCost = egressCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.12", value="Total accumulated for egress task in USD, example is $0.12")
    public Double getEgressCost() {
        return this.egressCost;
    }

    public void setEgressCost(Double egressCost) {
        this.egressCost = egressCost;
    }

    public ArrayTask accessCost(Double accessCost) {
        this.accessCost = accessCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.12", value="Cost accumulated for access task in USD, example is $0.12")
    public Double getAccessCost() {
        return this.accessCost;
    }

    public void setAccessCost(Double accessCost) {
        this.accessCost = accessCost;
    }

    public ArrayTask queryType(Querytype queryType) {
        this.queryType = queryType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Querytype getQueryType() {
        return this.queryType;
    }

    public void setQueryType(Querytype queryType) {
        this.queryType = queryType;
    }

    public ArrayTask udfCode(String udfCode) {
        this.udfCode = udfCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional actual code that is going to be executed")
    public String getUdfCode() {
        return this.udfCode;
    }

    public void setUdfCode(String udfCode) {
        this.udfCode = udfCode;
    }

    public ArrayTask udfLanguage(String udfLanguage) {
        this.udfLanguage = udfLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional actual language used to express udf_code")
    public String getUdfLanguage() {
        return this.udfLanguage;
    }

    public void setUdfLanguage(String udfLanguage) {
        this.udfLanguage = udfLanguage;
    }

    public ArrayTask sqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional actual sql query that is going to be executed")
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public ArrayTask type(ArrayTaskType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayTaskType getType() {
        return this.type;
    }

    public void setType(ArrayTaskType type) {
        this.type = type;
    }

    public ArrayTask activity(List<ArrayActivityLog> activity) {
        this.activity = activity;
        return this;
    }

    public ArrayTask addActivityItem(ArrayActivityLog activityItem) {
        if (this.activity == null) {
            this.activity = new ArrayList<ArrayActivityLog>();
        }
        this.activity.add(activityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array activity logs for task")
    public List<ArrayActivityLog> getActivity() {
        return this.activity;
    }

    public void setActivity(List<ArrayActivityLog> activity) {
        this.activity = activity;
    }

    public ArrayTask logs(String logs) {
        this.logs = logs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="logs from array task")
    public String getLogs() {
        return this.logs;
    }

    public void setLogs(String logs) {
        this.logs = logs;
    }

    public ArrayTask duration(BigDecimal duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3.41E+11", value="duration in nanoseconds of an array task")
    public BigDecimal getDuration() {
        return this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public ArrayTask sqlInitCommands(List<String> sqlInitCommands) {
        this.sqlInitCommands = sqlInitCommands;
        return this;
    }

    public ArrayTask addSqlInitCommandsItem(String sqlInitCommandsItem) {
        if (this.sqlInitCommands == null) {
            this.sqlInitCommands = new ArrayList<String>();
        }
        this.sqlInitCommands.add(sqlInitCommandsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SQL queries or commands to run before main sql query")
    public List<String> getSqlInitCommands() {
        return this.sqlInitCommands;
    }

    public void setSqlInitCommands(List<String> sqlInitCommands) {
        this.sqlInitCommands = sqlInitCommands;
    }

    public ArrayTask sqlParameters(List<Object> sqlParameters) {
        this.sqlParameters = sqlParameters;
        return this;
    }

    public ArrayTask addSqlParametersItem(Object sqlParametersItem) {
        if (this.sqlParameters == null) {
            this.sqlParameters = new ArrayList<Object>();
        }
        this.sqlParameters.add(sqlParametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SQL query parameters")
    public List<Object> getSqlParameters() {
        return this.sqlParameters;
    }

    public void setSqlParameters(List<Object> sqlParameters) {
        this.sqlParameters = sqlParameters;
    }

    public ArrayTask resultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public ArrayTask taskGraphUuid(String taskGraphUuid) {
        this.taskGraphUuid = taskGraphUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the ID of the log for the task graph that this was part of. ")
    public String getTaskGraphUuid() {
        return this.taskGraphUuid;
    }

    public void setTaskGraphUuid(String taskGraphUuid) {
        this.taskGraphUuid = taskGraphUuid;
    }

    public ArrayTask clientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the client-defined ID of the node within this task's graph. ")
    public String getClientNodeUuid() {
        return this.clientNodeUuid;
    }

    public void setClientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
    }

    public ArrayTask putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTask arrayTask = (ArrayTask)o;
        return Objects.equals(this.id, arrayTask.id) && Objects.equals(this.name, arrayTask.name) && Objects.equals(this.username, arrayTask.username) && Objects.equals(this.description, arrayTask.description) && Objects.equals(this.arrayMetadata, arrayTask.arrayMetadata) && Objects.equals(this.subarray, arrayTask.subarray) && Objects.equals(this.memory, arrayTask.memory) && Objects.equals(this.cpu, arrayTask.cpu) && Objects.equals(this.namespace, arrayTask.namespace) && Objects.equals((Object)this.status, (Object)arrayTask.status) && Objects.equals(this.statusMessage, arrayTask.statusMessage) && Objects.equals(this.startTime, arrayTask.startTime) && Objects.equals(this.finishTime, arrayTask.finishTime) && Objects.equals(this.cost, arrayTask.cost) && Objects.equals(this.egressCost, arrayTask.egressCost) && Objects.equals(this.accessCost, arrayTask.accessCost) && Objects.equals((Object)this.queryType, (Object)arrayTask.queryType) && Objects.equals(this.udfCode, arrayTask.udfCode) && Objects.equals(this.udfLanguage, arrayTask.udfLanguage) && Objects.equals(this.sqlQuery, arrayTask.sqlQuery) && Objects.equals((Object)this.type, (Object)arrayTask.type) && Objects.equals(this.activity, arrayTask.activity) && Objects.equals(this.logs, arrayTask.logs) && Objects.equals(this.duration, arrayTask.duration) && Objects.equals(this.sqlInitCommands, arrayTask.sqlInitCommands) && Objects.equals(this.sqlParameters, arrayTask.sqlParameters) && Objects.equals((Object)this.resultFormat, (Object)arrayTask.resultFormat) && Objects.equals(this.taskGraphUuid, arrayTask.taskGraphUuid) && Objects.equals(this.clientNodeUuid, arrayTask.clientNodeUuid) && Objects.equals(this.additionalProperties, arrayTask.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.username, this.description, this.arrayMetadata, this.subarray, this.memory, this.cpu, this.namespace, this.status, this.statusMessage, this.startTime, this.finishTime, this.cost, this.egressCost, this.accessCost, this.queryType, this.udfCode, this.udfLanguage, this.sqlQuery, this.type, this.activity, this.logs, this.duration, this.sqlInitCommands, this.sqlParameters, this.resultFormat, this.taskGraphUuid, this.clientNodeUuid, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayTask {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    arrayMetadata: ").append(this.toIndentedString(this.arrayMetadata)).append("\n");
        sb.append("    subarray: ").append(this.toIndentedString(this.subarray)).append("\n");
        sb.append("    memory: ").append(this.toIndentedString(this.memory)).append("\n");
        sb.append("    cpu: ").append(this.toIndentedString(this.cpu)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusMessage: ").append(this.toIndentedString(this.statusMessage)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    finishTime: ").append(this.toIndentedString(this.finishTime)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    egressCost: ").append(this.toIndentedString(this.egressCost)).append("\n");
        sb.append("    accessCost: ").append(this.toIndentedString(this.accessCost)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    udfCode: ").append(this.toIndentedString(this.udfCode)).append("\n");
        sb.append("    udfLanguage: ").append(this.toIndentedString(this.udfLanguage)).append("\n");
        sb.append("    sqlQuery: ").append(this.toIndentedString(this.sqlQuery)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    activity: ").append(this.toIndentedString(this.activity)).append("\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    sqlInitCommands: ").append(this.toIndentedString(this.sqlInitCommands)).append("\n");
        sb.append("    sqlParameters: ").append(this.toIndentedString(this.sqlParameters)).append("\n");
        sb.append("    resultFormat: ").append(this.toIndentedString((Object)this.resultFormat)).append("\n");
        sb.append("    taskGraphUuid: ").append(this.toIndentedString(this.taskGraphUuid)).append("\n");
        sb.append("    clientNodeUuid: ").append(this.toIndentedString(this.clientNodeUuid)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayTask is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_METADATA).isJsonNull()) {
            ArrayInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBARRAY) != null && !jsonObj.get(SERIALIZED_NAME_SUBARRAY).isJsonNull()) {
            DomainArray.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBARRAY));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status_message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UDF_CODE) != null && !jsonObj.get(SERIALIZED_NAME_UDF_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UDF_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `udf_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UDF_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UDF_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_UDF_LANGUAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UDF_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `udf_language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UDF_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SQL_QUERY) != null && !jsonObj.get(SERIALIZED_NAME_SQL_QUERY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SQL_QUERY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sql_query` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SQL_QUERY).toString()));
        }
        JsonArray jsonArrayactivity = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACTIVITY);
        if (jsonArrayactivity != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACTIVITY).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `activity` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIVITY).toString()));
            }
            for (int i = 0; i < jsonArrayactivity.size(); ++i) {
                ArrayActivityLog.validateJsonObject(jsonArrayactivity.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGS) != null && !jsonObj.get(SERIALIZED_NAME_LOGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `logs` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SQL_INIT_COMMANDS) != null && !jsonObj.get(SERIALIZED_NAME_SQL_INIT_COMMANDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SQL_INIT_COMMANDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sql_init_commands` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SQL_INIT_COMMANDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SQL_PARAMETERS) != null && !jsonObj.get(SERIALIZED_NAME_SQL_PARAMETERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SQL_PARAMETERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sql_parameters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SQL_PARAMETERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID) != null && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).toString()));
        }
    }

    public static ArrayTask fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ArrayTask.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ARRAY_METADATA);
        openapiFields.add(SERIALIZED_NAME_SUBARRAY);
        openapiFields.add(SERIALIZED_NAME_MEMORY);
        openapiFields.add(SERIALIZED_NAME_CPU);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STATUS_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiFields.add(SERIALIZED_NAME_FINISH_TIME);
        openapiFields.add(SERIALIZED_NAME_COST);
        openapiFields.add(SERIALIZED_NAME_EGRESS_COST);
        openapiFields.add(SERIALIZED_NAME_ACCESS_COST);
        openapiFields.add(SERIALIZED_NAME_QUERY_TYPE);
        openapiFields.add(SERIALIZED_NAME_UDF_CODE);
        openapiFields.add(SERIALIZED_NAME_UDF_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_SQL_QUERY);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_ACTIVITY);
        openapiFields.add(SERIALIZED_NAME_LOGS);
        openapiFields.add(SERIALIZED_NAME_DURATION);
        openapiFields.add(SERIALIZED_NAME_SQL_INIT_COMMANDS);
        openapiFields.add(SERIALIZED_NAME_SQL_PARAMETERS);
        openapiFields.add(SERIALIZED_NAME_RESULT_FORMAT);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_UUID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_NODE_UUID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ArrayTask.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ArrayTask> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ArrayTask.class));
            return new TypeAdapter<ArrayTask>(){

                @Override
                public void write(JsonWriter out, ArrayTask value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ArrayTask read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ArrayTask.validateJsonObject(jsonObj);
                    ArrayTask instance = (ArrayTask)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

