/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object for ui array tasks browser page")
public class ArrayTaskBrowserSidebar {
    public static final String SERIALIZED_NAME_ORGANIZATIONS = "organizations";
    @SerializedName(value="organizations")
    private List<String> organizations = null;
    public static final String SERIALIZED_NAME_RESULT_COUNT_FOR_ALL = "result_count_for_all";
    @SerializedName(value="result_count_for_all")
    private Integer resultCountForAll;
    public static final String SERIALIZED_NAME_RESULT_COUNT_BY_NAMESPACE = "result_count_by_namespace";
    @SerializedName(value="result_count_by_namespace")
    private Object resultCountByNamespace;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ArrayTaskBrowserSidebar organizations(List<String> organizations) {
        this.organizations = organizations;
        return this;
    }

    public ArrayTaskBrowserSidebar addOrganizationsItem(String organizationsItem) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(organizationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of all unique organizations the user is part of that have array tasks")
    public List<String> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(List<String> organizations) {
        this.organizations = organizations;
    }

    public ArrayTaskBrowserSidebar resultCountForAll(Integer resultCountForAll) {
        this.resultCountForAll = resultCountForAll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A count of \"all\"")
    public Integer getResultCountForAll() {
        return this.resultCountForAll;
    }

    public void setResultCountForAll(Integer resultCountForAll) {
        this.resultCountForAll = resultCountForAll;
    }

    public ArrayTaskBrowserSidebar resultCountByNamespace(Object resultCountByNamespace) {
        this.resultCountByNamespace = resultCountByNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map that includes the result count by namespace")
    public Object getResultCountByNamespace() {
        return this.resultCountByNamespace;
    }

    public void setResultCountByNamespace(Object resultCountByNamespace) {
        this.resultCountByNamespace = resultCountByNamespace;
    }

    public ArrayTaskBrowserSidebar putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTaskBrowserSidebar arrayTaskBrowserSidebar = (ArrayTaskBrowserSidebar)o;
        return Objects.equals(this.organizations, arrayTaskBrowserSidebar.organizations) && Objects.equals(this.resultCountForAll, arrayTaskBrowserSidebar.resultCountForAll) && Objects.equals(this.resultCountByNamespace, arrayTaskBrowserSidebar.resultCountByNamespace) && Objects.equals(this.additionalProperties, arrayTaskBrowserSidebar.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.organizations, this.resultCountForAll, this.resultCountByNamespace, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayTaskBrowserSidebar {\n");
        sb.append("    organizations: ").append(this.toIndentedString(this.organizations)).append("\n");
        sb.append("    resultCountForAll: ").append(this.toIndentedString(this.resultCountForAll)).append("\n");
        sb.append("    resultCountByNamespace: ").append(this.toIndentedString(this.resultCountByNamespace)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayTaskBrowserSidebar is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORGANIZATIONS) != null && !jsonObj.get(SERIALIZED_NAME_ORGANIZATIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORGANIZATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `organizations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATIONS).toString()));
        }
    }

    public static ArrayTaskBrowserSidebar fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ArrayTaskBrowserSidebar.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ORGANIZATIONS);
        openapiFields.add(SERIALIZED_NAME_RESULT_COUNT_FOR_ALL);
        openapiFields.add(SERIALIZED_NAME_RESULT_COUNT_BY_NAMESPACE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ArrayTaskBrowserSidebar.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ArrayTaskBrowserSidebar> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ArrayTaskBrowserSidebar.class));
            return new TypeAdapter<ArrayTaskBrowserSidebar>(){

                @Override
                public void write(JsonWriter out, ArrayTaskBrowserSidebar value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ArrayTaskBrowserSidebar read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ArrayTaskBrowserSidebar.validateJsonObject(jsonObj);
                    ArrayTaskBrowserSidebar instance = (ArrayTaskBrowserSidebar)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

