/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.StorageLocation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Custom storage locations on a per\u2013asset type basis. If any is unset, a suffix of the owning (user/organization) `default_s3_path` is used. ")
public class AssetLocations {
    public static final String SERIALIZED_NAME_ARRAYS = "arrays";
    @SerializedName(value="arrays")
    private StorageLocation arrays;
    public static final String SERIALIZED_NAME_FILES = "files";
    @SerializedName(value="files")
    private StorageLocation files;
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private StorageLocation groups;
    public static final String SERIALIZED_NAME_ML_MODELS = "ml_models";
    @SerializedName(value="ml_models")
    private StorageLocation mlModels;
    public static final String SERIALIZED_NAME_NOTEBOOKS = "notebooks";
    @SerializedName(value="notebooks")
    private StorageLocation notebooks;
    public static final String SERIALIZED_NAME_TASK_GRAPHS = "task_graphs";
    @SerializedName(value="task_graphs")
    private StorageLocation taskGraphs;
    public static final String SERIALIZED_NAME_UDFS = "udfs";
    @SerializedName(value="udfs")
    private StorageLocation udfs;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AssetLocations arrays(StorageLocation arrays) {
        this.arrays = arrays;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getArrays() {
        return this.arrays;
    }

    public void setArrays(StorageLocation arrays) {
        this.arrays = arrays;
    }

    public AssetLocations files(StorageLocation files) {
        this.files = files;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getFiles() {
        return this.files;
    }

    public void setFiles(StorageLocation files) {
        this.files = files;
    }

    public AssetLocations groups(StorageLocation groups2) {
        this.groups = groups2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getGroups() {
        return this.groups;
    }

    public void setGroups(StorageLocation groups2) {
        this.groups = groups2;
    }

    public AssetLocations mlModels(StorageLocation mlModels) {
        this.mlModels = mlModels;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getMlModels() {
        return this.mlModels;
    }

    public void setMlModels(StorageLocation mlModels) {
        this.mlModels = mlModels;
    }

    public AssetLocations notebooks(StorageLocation notebooks) {
        this.notebooks = notebooks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getNotebooks() {
        return this.notebooks;
    }

    public void setNotebooks(StorageLocation notebooks) {
        this.notebooks = notebooks;
    }

    public AssetLocations taskGraphs(StorageLocation taskGraphs) {
        this.taskGraphs = taskGraphs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getTaskGraphs() {
        return this.taskGraphs;
    }

    public void setTaskGraphs(StorageLocation taskGraphs) {
        this.taskGraphs = taskGraphs;
    }

    public AssetLocations udfs(StorageLocation udfs) {
        this.udfs = udfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StorageLocation getUdfs() {
        return this.udfs;
    }

    public void setUdfs(StorageLocation udfs) {
        this.udfs = udfs;
    }

    public AssetLocations putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetLocations assetLocations = (AssetLocations)o;
        return Objects.equals(this.arrays, assetLocations.arrays) && Objects.equals(this.files, assetLocations.files) && Objects.equals(this.groups, assetLocations.groups) && Objects.equals(this.mlModels, assetLocations.mlModels) && Objects.equals(this.notebooks, assetLocations.notebooks) && Objects.equals(this.taskGraphs, assetLocations.taskGraphs) && Objects.equals(this.udfs, assetLocations.udfs) && Objects.equals(this.additionalProperties, assetLocations.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.arrays, this.files, this.groups, this.mlModels, this.notebooks, this.taskGraphs, this.udfs, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetLocations {\n");
        sb.append("    arrays: ").append(this.toIndentedString(this.arrays)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    mlModels: ").append(this.toIndentedString(this.mlModels)).append("\n");
        sb.append("    notebooks: ").append(this.toIndentedString(this.notebooks)).append("\n");
        sb.append("    taskGraphs: ").append(this.toIndentedString(this.taskGraphs)).append("\n");
        sb.append("    udfs: ").append(this.toIndentedString(this.udfs)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AssetLocations is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAYS) != null && !jsonObj.get(SERIALIZED_NAME_ARRAYS).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAYS));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILES) != null && !jsonObj.get(SERIALIZED_NAME_FILES).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FILES));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GROUPS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ML_MODELS) != null && !jsonObj.get(SERIALIZED_NAME_ML_MODELS).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ML_MODELS));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTEBOOKS) != null && !jsonObj.get(SERIALIZED_NAME_NOTEBOOKS).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NOTEBOOKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TASK_GRAPHS) != null && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPHS).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TASK_GRAPHS));
        }
        if (jsonObj.get(SERIALIZED_NAME_UDFS) != null && !jsonObj.get(SERIALIZED_NAME_UDFS).isJsonNull()) {
            StorageLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_UDFS));
        }
    }

    public static AssetLocations fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, AssetLocations.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARRAYS);
        openapiFields.add(SERIALIZED_NAME_FILES);
        openapiFields.add(SERIALIZED_NAME_GROUPS);
        openapiFields.add(SERIALIZED_NAME_ML_MODELS);
        openapiFields.add(SERIALIZED_NAME_NOTEBOOKS);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPHS);
        openapiFields.add(SERIALIZED_NAME_UDFS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AssetLocations.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AssetLocations> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(AssetLocations.class));
            return new TypeAdapter<AssetLocations>(){

                @Override
                public void write(JsonWriter out, AssetLocations value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public AssetLocations read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AssetLocations.validateJsonObject(jsonObj);
                    AssetLocations instance = (AssetLocations)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

