/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Represents an attribute buffer header information")
public class AttributeBufferHeader {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_FIXED_LEN_BUFFER_SIZE_IN_BYTES = "fixedLenBufferSizeInBytes";
    @SerializedName(value="fixedLenBufferSizeInBytes")
    private Integer fixedLenBufferSizeInBytes;
    public static final String SERIALIZED_NAME_VAR_LEN_BUFFER_SIZE_IN_BYTES = "varLenBufferSizeInBytes";
    @SerializedName(value="varLenBufferSizeInBytes")
    private Integer varLenBufferSizeInBytes;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AttributeBufferHeader name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="attribute1", required=true, value="Attribute name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttributeBufferHeader fixedLenBufferSizeInBytes(Integer fixedLenBufferSizeInBytes) {
        this.fixedLenBufferSizeInBytes = fixedLenBufferSizeInBytes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of bytes in the fixed-length attribute data buffer (offsets for var-len attributes)")
    public Integer getFixedLenBufferSizeInBytes() {
        return this.fixedLenBufferSizeInBytes;
    }

    public void setFixedLenBufferSizeInBytes(Integer fixedLenBufferSizeInBytes) {
        this.fixedLenBufferSizeInBytes = fixedLenBufferSizeInBytes;
    }

    public AttributeBufferHeader varLenBufferSizeInBytes(Integer varLenBufferSizeInBytes) {
        this.varLenBufferSizeInBytes = varLenBufferSizeInBytes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of bytes in the var-length attribute data buffer")
    public Integer getVarLenBufferSizeInBytes() {
        return this.varLenBufferSizeInBytes;
    }

    public void setVarLenBufferSizeInBytes(Integer varLenBufferSizeInBytes) {
        this.varLenBufferSizeInBytes = varLenBufferSizeInBytes;
    }

    public AttributeBufferHeader putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeBufferHeader attributeBufferHeader = (AttributeBufferHeader)o;
        return Objects.equals(this.name, attributeBufferHeader.name) && Objects.equals(this.fixedLenBufferSizeInBytes, attributeBufferHeader.fixedLenBufferSizeInBytes) && Objects.equals(this.varLenBufferSizeInBytes, attributeBufferHeader.varLenBufferSizeInBytes) && Objects.equals(this.additionalProperties, attributeBufferHeader.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fixedLenBufferSizeInBytes, this.varLenBufferSizeInBytes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttributeBufferHeader {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fixedLenBufferSizeInBytes: ").append(this.toIndentedString(this.fixedLenBufferSizeInBytes)).append("\n");
        sb.append("    varLenBufferSizeInBytes: ").append(this.toIndentedString(this.varLenBufferSizeInBytes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AttributeBufferHeader is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static AttributeBufferHeader fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, AttributeBufferHeader.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_FIXED_LEN_BUFFER_SIZE_IN_BYTES);
        openapiFields.add(SERIALIZED_NAME_VAR_LEN_BUFFER_SIZE_IN_BYTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_FIXED_LEN_BUFFER_SIZE_IN_BYTES);
        openapiRequiredFields.add(SERIALIZED_NAME_VAR_LEN_BUFFER_SIZE_IN_BYTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AttributeBufferHeader.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AttributeBufferHeader> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(AttributeBufferHeader.class));
            return new TypeAdapter<AttributeBufferHeader>(){

                @Override
                public void write(JsonWriter out, AttributeBufferHeader value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public AttributeBufferHeader read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AttributeBufferHeader.validateJsonObject(jsonObj);
                    AttributeBufferHeader instance = (AttributeBufferHeader)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

