/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Backoff is a backoff strategy to use within retryStrategy")
public class Backoff {
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private String duration;
    public static final String SERIALIZED_NAME_FACTOR = "factor";
    @SerializedName(value="factor")
    private Integer factor;
    public static final String SERIALIZED_NAME_MAX_DURATION = "maxDuration";
    @SerializedName(value="maxDuration")
    private String maxDuration;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Backoff duration(String duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Duration is the amount to back off. Default unit is seconds, but could also be a duration (e.g. \"2m\", \"1h\")")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public Backoff factor(Integer factor) {
        this.factor = factor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Factor is a factor to multiply the base duration after each failed retry")
    public Integer getFactor() {
        return this.factor;
    }

    public void setFactor(Integer factor) {
        this.factor = factor;
    }

    public Backoff maxDuration(String maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MaxDuration is the maximum amount of time allowed for the backoff strategy")
    public String getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(String maxDuration) {
        this.maxDuration = maxDuration;
    }

    public Backoff putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Backoff backoff = (Backoff)o;
        return Objects.equals(this.duration, backoff.duration) && Objects.equals(this.factor, backoff.factor) && Objects.equals(this.maxDuration, backoff.maxDuration) && Objects.equals(this.additionalProperties, backoff.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.factor, this.maxDuration, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Backoff {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    factor: ").append(this.toIndentedString(this.factor)).append("\n");
        sb.append("    maxDuration: ").append(this.toIndentedString(this.maxDuration)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Backoff is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DURATION) != null && !jsonObj.get(SERIALIZED_NAME_DURATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DURATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `duration` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DURATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAX_DURATION) != null && !jsonObj.get(SERIALIZED_NAME_MAX_DURATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAX_DURATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maxDuration` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAX_DURATION).toString()));
        }
    }

    public static Backoff fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Backoff.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DURATION);
        openapiFields.add(SERIALIZED_NAME_FACTOR);
        openapiFields.add(SERIALIZED_NAME_MAX_DURATION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Backoff.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Backoff> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Backoff.class));
            return new TypeAdapter<Backoff>(){

                @Override
                public void write(JsonWriter out, Backoff value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Backoff read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Backoff.validateJsonObject(jsonObj);
                    Backoff instance = (Backoff)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

