/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArraySchema;
import io.tiledb.cloud.rest_api.model.SingleFragmentInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fragment info of an array")
public class FragmentInfo {
    public static final String SERIALIZED_NAME_ARRAY_SCHEMA_ALL = "arraySchemaAll";
    @SerializedName(value="arraySchemaAll")
    private Map<String, ArraySchema> arraySchemaAll = null;
    public static final String SERIALIZED_NAME_FRAGMENT_INFO = "fragmentInfo";
    @SerializedName(value="fragmentInfo")
    private List<SingleFragmentInfo> fragmentInfo = null;
    public static final String SERIALIZED_NAME_TO_VACUUM = "toVacuum";
    @SerializedName(value="toVacuum")
    private List<String> toVacuum = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FragmentInfo arraySchemaAll(Map<String, ArraySchema> arraySchemaAll) {
        this.arraySchemaAll = arraySchemaAll;
        return this;
    }

    public FragmentInfo putArraySchemaAllItem(String key, ArraySchema arraySchemaAllItem) {
        if (this.arraySchemaAll == null) {
            this.arraySchemaAll = new HashMap<String, ArraySchema>();
        }
        this.arraySchemaAll.put(key, arraySchemaAllItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="map of all array schemas")
    public Map<String, ArraySchema> getArraySchemaAll() {
        return this.arraySchemaAll;
    }

    public void setArraySchemaAll(Map<String, ArraySchema> arraySchemaAll) {
        this.arraySchemaAll = arraySchemaAll;
    }

    public FragmentInfo fragmentInfo(List<SingleFragmentInfo> fragmentInfo) {
        this.fragmentInfo = fragmentInfo;
        return this;
    }

    public FragmentInfo addFragmentInfoItem(SingleFragmentInfo fragmentInfoItem) {
        if (this.fragmentInfo == null) {
            this.fragmentInfo = new ArrayList<SingleFragmentInfo>();
        }
        this.fragmentInfo.add(fragmentInfoItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="information about fragments in the array")
    public List<SingleFragmentInfo> getFragmentInfo() {
        return this.fragmentInfo;
    }

    public void setFragmentInfo(List<SingleFragmentInfo> fragmentInfo) {
        this.fragmentInfo = fragmentInfo;
    }

    public FragmentInfo toVacuum(List<String> toVacuum) {
        this.toVacuum = toVacuum;
        return this;
    }

    public FragmentInfo addToVacuumItem(String toVacuumItem) {
        if (this.toVacuum == null) {
            this.toVacuum = new ArrayList<String>();
        }
        this.toVacuum.add(toVacuumItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the URIs of the fragments to vacuum")
    public List<String> getToVacuum() {
        return this.toVacuum;
    }

    public void setToVacuum(List<String> toVacuum) {
        this.toVacuum = toVacuum;
    }

    public FragmentInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentInfo fragmentInfo = (FragmentInfo)o;
        return Objects.equals(this.arraySchemaAll, fragmentInfo.arraySchemaAll) && Objects.equals(this.fragmentInfo, fragmentInfo.fragmentInfo) && Objects.equals(this.toVacuum, fragmentInfo.toVacuum) && Objects.equals(this.additionalProperties, fragmentInfo.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.arraySchemaAll, this.fragmentInfo, this.toVacuum, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FragmentInfo {\n");
        sb.append("    arraySchemaAll: ").append(this.toIndentedString(this.arraySchemaAll)).append("\n");
        sb.append("    fragmentInfo: ").append(this.toIndentedString(this.fragmentInfo)).append("\n");
        sb.append("    toVacuum: ").append(this.toIndentedString(this.toVacuum)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FragmentInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArrayfragmentInfo = jsonObj.getAsJsonArray(SERIALIZED_NAME_FRAGMENT_INFO);
        if (jsonArrayfragmentInfo != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FRAGMENT_INFO).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `fragmentInfo` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_INFO).toString()));
            }
            for (int i = 0; i < jsonArrayfragmentInfo.size(); ++i) {
                SingleFragmentInfo.validateJsonObject(jsonArrayfragmentInfo.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TO_VACUUM) != null && !jsonObj.get(SERIALIZED_NAME_TO_VACUUM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TO_VACUUM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `toVacuum` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_VACUUM).toString()));
        }
    }

    public static FragmentInfo fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, FragmentInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARRAY_SCHEMA_ALL);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_INFO);
        openapiFields.add(SERIALIZED_NAME_TO_VACUUM);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FragmentInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<FragmentInfo> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(FragmentInfo.class));
            return new TypeAdapter<FragmentInfo>(){

                @Override
                public void write(JsonWriter out, FragmentInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public FragmentInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FragmentInfo.validateJsonObject(jsonObj);
                    FragmentInfo instance = (FragmentInfo)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

