/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import io.tiledb.cloud.rest_api.model.UDFLanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User-defined function")
public class GenericUDF {
    public static final String SERIALIZED_NAME_UDF_INFO_NAME = "udf_info_name";
    @SerializedName(value="udf_info_name")
    private String udfInfoName;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private UDFLanguage language;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_IMAGE_NAME = "image_name";
    @SerializedName(value="image_name")
    private String imageName;
    public static final String SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME = "access_credentials_name";
    @SerializedName(value="access_credentials_name")
    private String accessCredentialsName;
    public static final String SERIALIZED_NAME_RESOURCE_CLASS = "resource_class";
    @SerializedName(value="resource_class")
    private String resourceClass;
    public static final String SERIALIZED_NAME_EXEC = "exec";
    @SerializedName(value="exec")
    private String exec;
    public static final String SERIALIZED_NAME_EXEC_RAW = "exec_raw";
    @SerializedName(value="exec_raw")
    private String execRaw;
    public static final String SERIALIZED_NAME_ARGUMENT = "argument";
    @SerializedName(value="argument")
    private String argument;
    public static final String SERIALIZED_NAME_STORED_PARAM_UUIDS = "stored_param_uuids";
    @SerializedName(value="stored_param_uuids")
    private List<String> storedParamUuids = null;
    public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
    @SerializedName(value="result_format")
    private ResultFormat resultFormat;
    public static final String SERIALIZED_NAME_TASK_NAME = "task_name";
    @SerializedName(value="task_name")
    private String taskName;
    public static final String SERIALIZED_NAME_STORE_RESULTS = "store_results";
    @SerializedName(value="store_results")
    private Boolean storeResults;
    public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
    @SerializedName(value="timeout")
    private Integer timeout;
    public static final String SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS = "dont_download_results";
    @SerializedName(value="dont_download_results")
    private Boolean dontDownloadResults;
    public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
    @SerializedName(value="task_graph_uuid")
    private String taskGraphUuid;
    public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
    @SerializedName(value="client_node_uuid")
    private String clientNodeUuid;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GenericUDF udfInfoName(String udfInfoName) {
        this.udfInfoName = udfInfoName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TileDB-Inc/csv_ingestor", value="name of UDFInfo to run, format is {namespace}/{udf_name}. Can not be used with exec")
    public String getUdfInfoName() {
        return this.udfInfoName;
    }

    public void setUdfInfoName(String udfInfoName) {
        this.udfInfoName = udfInfoName;
    }

    public GenericUDF language(UDFLanguage language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(UDFLanguage language) {
        this.language = language;
    }

    public GenericUDF version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type-specific version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public GenericUDF imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Docker image name to use for UDF")
    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public GenericUDF accessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the access credentials to use. if unset, no credentials will be configured in the environment.")
    public String getAccessCredentialsName() {
        return this.accessCredentialsName;
    }

    public void setAccessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
    }

    public GenericUDF resourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="standard", value="The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider. ")
    public String getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
    }

    public GenericUDF exec(String exec) {
        this.exec = exec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type-specific executable text")
    public String getExec() {
        return this.exec;
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    public GenericUDF execRaw(String execRaw) {
        this.execRaw = execRaw;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="optional raw text to store of serialized function, used for showing in UI")
    public String getExecRaw() {
        return this.execRaw;
    }

    public void setExecRaw(String execRaw) {
        this.execRaw = execRaw;
    }

    public GenericUDF argument(String argument) {
        this.argument = argument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Argument(s) to pass to UDF function, tuple or list of args/kwargs which can be in native or JSON format")
    public String getArgument() {
        return this.argument;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public GenericUDF storedParamUuids(List<String> storedParamUuids) {
        this.storedParamUuids = storedParamUuids;
        return this;
    }

    public GenericUDF addStoredParamUuidsItem(String storedParamUuidsItem) {
        if (this.storedParamUuids == null) {
            this.storedParamUuids = new ArrayList<String>();
        }
        this.storedParamUuids.add(storedParamUuidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UUIDs of stored input parameters (passed in a language-specific format within \"argument\") to be retrieved from the server-side cache. Serialized in standard hex format with no {}.")
    public List<String> getStoredParamUuids() {
        return this.storedParamUuids;
    }

    public void setStoredParamUuids(List<String> storedParamUuids) {
        this.storedParamUuids = storedParamUuids;
    }

    public GenericUDF resultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public GenericUDF taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of task, optional")
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public GenericUDF storeResults(Boolean storeResults) {
        this.storeResults = storeResults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="store results for later retrieval")
    public Boolean getStoreResults() {
        return this.storeResults;
    }

    public void setStoreResults(Boolean storeResults) {
        this.storeResults = storeResults;
    }

    public GenericUDF timeout(Integer timeout2) {
        this.timeout = timeout2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UDF-type timeout in seconds (default: 900)")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout2) {
        this.timeout = timeout2;
    }

    public GenericUDF dontDownloadResults(Boolean dontDownloadResults) {
        this.dontDownloadResults = dontDownloadResults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\"yes download results\").")
    public Boolean getDontDownloadResults() {
        return this.dontDownloadResults;
    }

    public void setDontDownloadResults(Boolean dontDownloadResults) {
        this.dontDownloadResults = dontDownloadResults;
    }

    public GenericUDF taskGraphUuid(String taskGraphUuid) {
        this.taskGraphUuid = taskGraphUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the ID of the log for the task graph that this was part of. ")
    public String getTaskGraphUuid() {
        return this.taskGraphUuid;
    }

    public void setTaskGraphUuid(String taskGraphUuid) {
        this.taskGraphUuid = taskGraphUuid;
    }

    public GenericUDF clientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the client-defined ID of the node within this task's graph. ")
    public String getClientNodeUuid() {
        return this.clientNodeUuid;
    }

    public void setClientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
    }

    public GenericUDF putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericUDF genericUDF = (GenericUDF)o;
        return Objects.equals(this.udfInfoName, genericUDF.udfInfoName) && Objects.equals((Object)this.language, (Object)genericUDF.language) && Objects.equals(this.version, genericUDF.version) && Objects.equals(this.imageName, genericUDF.imageName) && Objects.equals(this.accessCredentialsName, genericUDF.accessCredentialsName) && Objects.equals(this.resourceClass, genericUDF.resourceClass) && Objects.equals(this.exec, genericUDF.exec) && Objects.equals(this.execRaw, genericUDF.execRaw) && Objects.equals(this.argument, genericUDF.argument) && Objects.equals(this.storedParamUuids, genericUDF.storedParamUuids) && Objects.equals((Object)this.resultFormat, (Object)genericUDF.resultFormat) && Objects.equals(this.taskName, genericUDF.taskName) && Objects.equals(this.storeResults, genericUDF.storeResults) && Objects.equals(this.timeout, genericUDF.timeout) && Objects.equals(this.dontDownloadResults, genericUDF.dontDownloadResults) && Objects.equals(this.taskGraphUuid, genericUDF.taskGraphUuid) && Objects.equals(this.clientNodeUuid, genericUDF.clientNodeUuid) && Objects.equals(this.additionalProperties, genericUDF.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.udfInfoName, this.language, this.version, this.imageName, this.accessCredentialsName, this.resourceClass, this.exec, this.execRaw, this.argument, this.storedParamUuids, this.resultFormat, this.taskName, this.storeResults, this.timeout, this.dontDownloadResults, this.taskGraphUuid, this.clientNodeUuid, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenericUDF {\n");
        sb.append("    udfInfoName: ").append(this.toIndentedString(this.udfInfoName)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    imageName: ").append(this.toIndentedString(this.imageName)).append("\n");
        sb.append("    accessCredentialsName: ").append(this.toIndentedString(this.accessCredentialsName)).append("\n");
        sb.append("    resourceClass: ").append(this.toIndentedString(this.resourceClass)).append("\n");
        sb.append("    exec: ").append(this.toIndentedString(this.exec)).append("\n");
        sb.append("    execRaw: ").append(this.toIndentedString(this.execRaw)).append("\n");
        sb.append("    argument: ").append(this.toIndentedString(this.argument)).append("\n");
        sb.append("    storedParamUuids: ").append(this.toIndentedString(this.storedParamUuids)).append("\n");
        sb.append("    resultFormat: ").append(this.toIndentedString((Object)this.resultFormat)).append("\n");
        sb.append("    taskName: ").append(this.toIndentedString(this.taskName)).append("\n");
        sb.append("    storeResults: ").append(this.toIndentedString(this.storeResults)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    dontDownloadResults: ").append(this.toIndentedString(this.dontDownloadResults)).append("\n");
        sb.append("    taskGraphUuid: ").append(this.toIndentedString(this.taskGraphUuid)).append("\n");
        sb.append("    clientNodeUuid: ").append(this.toIndentedString(this.clientNodeUuid)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GenericUDF is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UDF_INFO_NAME) != null && !jsonObj.get(SERIALIZED_NAME_UDF_INFO_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UDF_INFO_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `udf_info_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UDF_INFO_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resource_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXEC) != null && !jsonObj.get(SERIALIZED_NAME_EXEC).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXEC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exec` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXEC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXEC_RAW) != null && !jsonObj.get(SERIALIZED_NAME_EXEC_RAW).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXEC_RAW).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exec_raw` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXEC_RAW).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARGUMENT) != null && !jsonObj.get(SERIALIZED_NAME_ARGUMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARGUMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `argument` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARGUMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_PARAM_UUIDS) != null && !jsonObj.get(SERIALIZED_NAME_STORED_PARAM_UUIDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STORED_PARAM_UUIDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `stored_param_uuids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PARAM_UUIDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TASK_NAME) != null && !jsonObj.get(SERIALIZED_NAME_TASK_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TASK_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `task_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASK_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID) != null && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).toString()));
        }
    }

    public static GenericUDF fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GenericUDF.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UDF_INFO_NAME);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_IMAGE_NAME);
        openapiFields.add(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLASS);
        openapiFields.add(SERIALIZED_NAME_EXEC);
        openapiFields.add(SERIALIZED_NAME_EXEC_RAW);
        openapiFields.add(SERIALIZED_NAME_ARGUMENT);
        openapiFields.add(SERIALIZED_NAME_STORED_PARAM_UUIDS);
        openapiFields.add(SERIALIZED_NAME_RESULT_FORMAT);
        openapiFields.add(SERIALIZED_NAME_TASK_NAME);
        openapiFields.add(SERIALIZED_NAME_STORE_RESULTS);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_UUID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_NODE_UUID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GenericUDF.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GenericUDF> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GenericUDF.class));
            return new TypeAdapter<GenericUDF>(){

                @Override
                public void write(JsonWriter out, GenericUDF value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GenericUDF read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GenericUDF.validateJsonObject(jsonObj);
                    GenericUDF instance = (GenericUDF)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

