/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.GroupMember;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A request to change the members of a group. Contains assets to add or remove.")
public class GroupChanges {
    public static final String SERIALIZED_NAME_ADD = "add";
    @SerializedName(value="add")
    private List<GroupMember> add = null;
    public static final String SERIALIZED_NAME_REMOVE = "remove";
    @SerializedName(value="remove")
    private List<GroupMember> remove = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GroupChanges add(List<GroupMember> add) {
        this.add = add;
        return this;
    }

    public GroupChanges addAddItem(GroupMember addItem) {
        if (this.add == null) {
            this.add = new ArrayList<GroupMember>();
        }
        this.add.add(addItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the assets, arrays or groups, to add to the group.")
    public List<GroupMember> getAdd() {
        return this.add;
    }

    public void setAdd(List<GroupMember> add) {
        this.add = add;
    }

    public GroupChanges remove(List<GroupMember> remove) {
        this.remove = remove;
        return this;
    }

    public GroupChanges addRemoveItem(GroupMember removeItem) {
        if (this.remove == null) {
            this.remove = new ArrayList<GroupMember>();
        }
        this.remove.add(removeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the assets, arrays or groups, to remove from the group.")
    public List<GroupMember> getRemove() {
        return this.remove;
    }

    public void setRemove(List<GroupMember> remove) {
        this.remove = remove;
    }

    public GroupChanges putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupChanges groupChanges = (GroupChanges)o;
        return Objects.equals(this.add, groupChanges.add) && Objects.equals(this.remove, groupChanges.remove) && Objects.equals(this.additionalProperties, groupChanges.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.add, this.remove, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupChanges {\n");
        sb.append("    add: ").append(this.toIndentedString(this.add)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayremove;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GroupChanges is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArrayadd = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADD);
        if (jsonArrayadd != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADD).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `add` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADD).toString()));
            }
            for (int i = 0; i < jsonArrayadd.size(); ++i) {
                GroupMember.validateJsonObject(jsonArrayadd.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayremove = jsonObj.getAsJsonArray(SERIALIZED_NAME_REMOVE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REMOVE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `remove` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REMOVE).toString()));
            }
            for (int i = 0; i < jsonArrayremove.size(); ++i) {
                GroupMember.validateJsonObject(jsonArrayremove.get(i).getAsJsonObject());
            }
        }
    }

    public static GroupChanges fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GroupChanges.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADD);
        openapiFields.add(SERIALIZED_NAME_REMOVE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GroupChanges.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GroupChanges> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GroupChanges.class));
            return new TypeAdapter<GroupChanges>(){

                @Override
                public void write(JsonWriter out, GroupChanges value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GroupChanges read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GroupChanges.validateJsonObject(jsonObj);
                    GroupChanges instance = (GroupChanges)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

