/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.GroupInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing a single member of a group, which can be an array or a group")
public class GroupEntry {
    public static final String SERIALIZED_NAME_MEMBER_ID = "member_id";
    @SerializedName(value="member_id")
    private String memberId;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private GroupInfo group;
    public static final String SERIALIZED_NAME_ARRAY = "array";
    @SerializedName(value="array")
    private ArrayInfo array;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GroupEntry() {
    }

    public GroupEntry(String memberId) {
        this();
        this.memberId = memberId;
    }

    @Nullable
    @ApiModelProperty(value="The unique member id for the entry")
    public String getMemberId() {
        return this.memberId;
    }

    public GroupEntry group(GroupInfo group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GroupInfo getGroup() {
        return this.group;
    }

    public void setGroup(GroupInfo group) {
        this.group = group;
    }

    public GroupEntry array(ArrayInfo array) {
        this.array = array;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayInfo getArray() {
        return this.array;
    }

    public void setArray(ArrayInfo array) {
        this.array = array;
    }

    public GroupEntry putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupEntry groupEntry = (GroupEntry)o;
        return Objects.equals(this.memberId, groupEntry.memberId) && Objects.equals(this.group, groupEntry.group) && Objects.equals(this.array, groupEntry.array) && Objects.equals(this.additionalProperties, groupEntry.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.memberId, this.group, this.array, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupEntry {\n");
        sb.append("    memberId: ").append(this.toIndentedString(this.memberId)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    array: ").append(this.toIndentedString(this.array)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GroupEntry is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEMBER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MEMBER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEMBER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `member_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEMBER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonNull()) {
            GroupInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GROUP));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY).isJsonNull()) {
            ArrayInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY));
        }
    }

    public static GroupEntry fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GroupEntry.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MEMBER_ID);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_ARRAY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GroupEntry.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GroupEntry> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GroupEntry.class));
            return new TypeAdapter<GroupEntry>(){

                @Override
                public void write(JsonWriter out, GroupEntry value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GroupEntry read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GroupEntry.validateJsonObject(jsonObj);
                    GroupEntry instance = (GroupEntry)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

