/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.GroupActions;
import io.tiledb.cloud.rest_api.model.GroupType;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="metadata of a group")
public class GroupInfo {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_TILEDB_URI = "tiledb_uri";
    @SerializedName(value="tiledb_uri")
    private String tiledbUri;
    public static final String SERIALIZED_NAME_ASSET_COUNT = "asset_count";
    @SerializedName(value="asset_count")
    private BigDecimal assetCount;
    public static final String SERIALIZED_NAME_GROUP_COUNT = "group_count";
    @SerializedName(value="group_count")
    private BigDecimal groupCount;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private BigDecimal size;
    public static final String SERIALIZED_NAME_LAST_ACCESSED = "last_accessed";
    @SerializedName(value="last_accessed")
    private OffsetDateTime lastAccessed;
    public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
    @SerializedName(value="allowed_actions")
    private List<GroupActions> allowedActions = null;
    public static final String SERIALIZED_NAME_GROUP_TYPE = "group_type";
    @SerializedName(value="group_type")
    private GroupType groupType;
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME = "access_credentials_name";
    @SerializedName(value="access_credentials_name")
    private String accessCredentialsName;
    public static final String SERIALIZED_NAME_SHARE_COUNT = "share_count";
    @SerializedName(value="share_count")
    private BigDecimal shareCount;
    public static final String SERIALIZED_NAME_PUBLIC_SHARE = "public_share";
    @SerializedName(value="public_share")
    private Boolean publicShare;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
    @SerializedName(value="license_id")
    private String licenseId;
    public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
    @SerializedName(value="license_text")
    private String licenseText;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GroupInfo id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of registered group")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GroupInfo namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user1", value="namespace group is in")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public GroupInfo name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="myarray1", value="name of group")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupInfo description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description of group")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GroupInfo uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="s3://bucket/asset", value="uri of group")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public GroupInfo tiledbUri(String tiledbUri) {
        this.tiledbUri = tiledbUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="uri for access through TileDB cloud")
    public String getTiledbUri() {
        return this.tiledbUri;
    }

    public void setTiledbUri(String tiledbUri) {
        this.tiledbUri = tiledbUri;
    }

    public GroupInfo assetCount(BigDecimal assetCount) {
        this.assetCount = assetCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12.0", value="A count of direct array members")
    public BigDecimal getAssetCount() {
        return this.assetCount;
    }

    public void setAssetCount(BigDecimal assetCount) {
        this.assetCount = assetCount;
    }

    public GroupInfo groupCount(BigDecimal groupCount) {
        this.groupCount = groupCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4.0", value="A count of direct group members")
    public BigDecimal getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(BigDecimal groupCount) {
        this.groupCount = groupCount;
    }

    public GroupInfo size(BigDecimal size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="16.0", value="A count of direct members. This is the sum of asset_count and group_count")
    public BigDecimal getSize() {
        return this.size;
    }

    public void setSize(BigDecimal size) {
        this.size = size;
    }

    public GroupInfo lastAccessed(OffsetDateTime lastAccessed) {
        this.lastAccessed = lastAccessed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime groups was last accessed in UTC")
    public OffsetDateTime getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(OffsetDateTime lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public GroupInfo allowedActions(List<GroupActions> allowedActions) {
        this.allowedActions = allowedActions;
        return this;
    }

    public GroupInfo addAllowedActionsItem(GroupActions allowedActionsItem) {
        if (this.allowedActions == null) {
            this.allowedActions = new ArrayList<GroupActions>();
        }
        this.allowedActions.add(allowedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of actions user is allowed to do on this group")
    public List<GroupActions> getAllowedActions() {
        return this.allowedActions;
    }

    public void setAllowedActions(List<GroupActions> allowedActions) {
        this.allowedActions = allowedActions;
    }

    public GroupInfo groupType(GroupType groupType) {
        this.groupType = groupType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
    }

    public GroupInfo logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="logo (base64 encoded) for the gruop. Optional")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public GroupInfo accessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the name of the access credentials to use. if unset, the default credentials will be used")
    public String getAccessCredentialsName() {
        return this.accessCredentialsName;
    }

    public void setAccessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
    }

    public GroupInfo shareCount(BigDecimal shareCount) {
        this.shareCount = shareCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="number of unique namespaces this group is shared with")
    public BigDecimal getShareCount() {
        return this.shareCount;
    }

    public void setShareCount(BigDecimal shareCount) {
        this.shareCount = shareCount;
    }

    public GroupInfo publicShare(Boolean publicShare) {
        this.publicShare = publicShare;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Suggests if the group was shared to public by owner")
    public Boolean getPublicShare() {
        return this.publicShare;
    }

    public void setPublicShare(Boolean publicShare) {
        this.publicShare = publicShare;
    }

    public GroupInfo tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public GroupInfo addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="optional tags for group")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public GroupInfo licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License identifier from SPDX License List or Custom")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public GroupInfo licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License text")
    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public GroupInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupInfo groupInfo = (GroupInfo)o;
        return Objects.equals(this.id, groupInfo.id) && Objects.equals(this.namespace, groupInfo.namespace) && Objects.equals(this.name, groupInfo.name) && Objects.equals(this.description, groupInfo.description) && Objects.equals(this.uri, groupInfo.uri) && Objects.equals(this.tiledbUri, groupInfo.tiledbUri) && Objects.equals(this.assetCount, groupInfo.assetCount) && Objects.equals(this.groupCount, groupInfo.groupCount) && Objects.equals(this.size, groupInfo.size) && Objects.equals(this.lastAccessed, groupInfo.lastAccessed) && Objects.equals(this.allowedActions, groupInfo.allowedActions) && Objects.equals((Object)this.groupType, (Object)groupInfo.groupType) && Objects.equals(this.logo, groupInfo.logo) && Objects.equals(this.accessCredentialsName, groupInfo.accessCredentialsName) && Objects.equals(this.shareCount, groupInfo.shareCount) && Objects.equals(this.publicShare, groupInfo.publicShare) && Objects.equals(this.tags, groupInfo.tags) && Objects.equals(this.licenseId, groupInfo.licenseId) && Objects.equals(this.licenseText, groupInfo.licenseText) && Objects.equals(this.additionalProperties, groupInfo.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.namespace, this.name, this.description, this.uri, this.tiledbUri, this.assetCount, this.groupCount, this.size, this.lastAccessed, this.allowedActions, this.groupType, this.logo, this.accessCredentialsName, this.shareCount, this.publicShare, this.tags, this.licenseId, this.licenseText, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    tiledbUri: ").append(this.toIndentedString(this.tiledbUri)).append("\n");
        sb.append("    assetCount: ").append(this.toIndentedString(this.assetCount)).append("\n");
        sb.append("    groupCount: ").append(this.toIndentedString(this.groupCount)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    lastAccessed: ").append(this.toIndentedString(this.lastAccessed)).append("\n");
        sb.append("    allowedActions: ").append(this.toIndentedString(this.allowedActions)).append("\n");
        sb.append("    groupType: ").append(this.toIndentedString((Object)this.groupType)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    accessCredentialsName: ").append(this.toIndentedString(this.accessCredentialsName)).append("\n");
        sb.append("    shareCount: ").append(this.toIndentedString(this.shareCount)).append("\n");
        sb.append("    publicShare: ").append(this.toIndentedString(this.publicShare)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GroupInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILEDB_URI) != null && !jsonObj.get(SERIALIZED_NAME_TILEDB_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TILEDB_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tiledb_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILEDB_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGO) != null && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_ID) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).toString()));
        }
    }

    public static GroupInfo fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GroupInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_TILEDB_URI);
        openapiFields.add(SERIALIZED_NAME_ASSET_COUNT);
        openapiFields.add(SERIALIZED_NAME_GROUP_COUNT);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_LAST_ACCESSED);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_GROUP_TYPE);
        openapiFields.add(SERIALIZED_NAME_LOGO);
        openapiFields.add(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME);
        openapiFields.add(SERIALIZED_NAME_SHARE_COUNT);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_SHARE);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_LICENSE_ID);
        openapiFields.add(SERIALIZED_NAME_LICENSE_TEXT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GroupInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GroupInfo> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GroupInfo.class));
            return new TypeAdapter<GroupInfo>(){

                @Override
                public void write(JsonWriter out, GroupInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GroupInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GroupInfo.validateJsonObject(jsonObj);
                    GroupInfo instance = (GroupInfo)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

