/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum GroupType {
    GENERIC("generic"),
    VCF("vcf"),
    SOMA("soma"),
    BIOIMG("bioimg"),
    POINTCLOUD("pointcloud"),
    RASTER("raster"),
    GEOMETRY("geometry"),
    VECTOR_SEARCH("vector_search");

    private String value;

    private GroupType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GroupType fromValue(String value) {
        for (GroupType b : GroupType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<GroupType> {
        @Override
        public void write(JsonWriter jsonWriter, GroupType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public GroupType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return GroupType.fromValue(value);
        }
    }
}

