/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.InvitationStatus;
import io.tiledb.cloud.rest_api.model.InvitationType;
import io.tiledb.cloud.rest_api.model.OrganizationRoles;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Invitations to share or collaborate")
public class Invitation {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INVITATION_TYPE = "invitation_type";
    @SerializedName(value="invitation_type")
    private InvitationType invitationType;
    public static final String SERIALIZED_NAME_OWNER_NAMESPACE_UUID = "owner_namespace_uuid";
    @SerializedName(value="owner_namespace_uuid")
    private String ownerNamespaceUuid;
    public static final String SERIALIZED_NAME_INVITER_UUID = "inviter_uuid";
    @SerializedName(value="inviter_uuid")
    private String inviterUuid;
    public static final String SERIALIZED_NAME_USER_NAMESPACE_UUID = "user_namespace_uuid";
    @SerializedName(value="user_namespace_uuid")
    private String userNamespaceUuid;
    public static final String SERIALIZED_NAME_ORGANIZATION_USER_UUID = "organization_user_uuid";
    @SerializedName(value="organization_user_uuid")
    private String organizationUserUuid;
    public static final String SERIALIZED_NAME_ORGANIZATION_NAME = "organization_name";
    @SerializedName(value="organization_name")
    private String organizationName;
    public static final String SERIALIZED_NAME_ORGANIZATION_ROLE = "organization_role";
    @SerializedName(value="organization_role")
    private OrganizationRoles organizationRole;
    public static final String SERIALIZED_NAME_ORGANIZATION_UUID = "organization_uuid";
    @SerializedName(value="organization_uuid")
    private String organizationUuid;
    public static final String SERIALIZED_NAME_ARRAY_UUID = "array_uuid";
    @SerializedName(value="array_uuid")
    private String arrayUuid;
    public static final String SERIALIZED_NAME_GROUP_UUID = "group_uuid";
    @SerializedName(value="group_uuid")
    private String groupUuid;
    public static final String SERIALIZED_NAME_ARRAY_NAME = "array_name";
    @SerializedName(value="array_name")
    private String arrayName;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    private String actions;
    public static final String SERIALIZED_NAME_GROUP_ACTIONS = "group_actions";
    @SerializedName(value="group_actions")
    private String groupActions;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private InvitationStatus status;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
    @SerializedName(value="expires_at")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_ACCEPTED_AT = "accepted_at";
    @SerializedName(value="accepted_at")
    private OffsetDateTime acceptedAt;
    public static final String SERIALIZED_NAME_NAMESPACE_INVITED = "namespace_invited";
    @SerializedName(value="namespace_invited")
    private String namespaceInvited;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Invitation id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of invitation added to magic link")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invitation invitationType(InvitationType invitationType) {
        this.invitationType = invitationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InvitationType getInvitationType() {
        return this.invitationType;
    }

    public void setInvitationType(InvitationType invitationType) {
        this.invitationType = invitationType;
    }

    public Invitation ownerNamespaceUuid(String ownerNamespaceUuid) {
        this.ownerNamespaceUuid = ownerNamespaceUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Namespace of the owner of the invitation (user or organization)")
    public String getOwnerNamespaceUuid() {
        return this.ownerNamespaceUuid;
    }

    public void setOwnerNamespaceUuid(String ownerNamespaceUuid) {
        this.ownerNamespaceUuid = ownerNamespaceUuid;
    }

    public Invitation inviterUuid(String inviterUuid) {
        this.inviterUuid = inviterUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the user that sent the invitation")
    public String getInviterUuid() {
        return this.inviterUuid;
    }

    public void setInviterUuid(String inviterUuid) {
        this.inviterUuid = inviterUuid;
    }

    public Invitation userNamespaceUuid(String userNamespaceUuid) {
        this.userNamespaceUuid = userNamespaceUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the user accepted the invitation")
    public String getUserNamespaceUuid() {
        return this.userNamespaceUuid;
    }

    public void setUserNamespaceUuid(String userNamespaceUuid) {
        this.userNamespaceUuid = userNamespaceUuid;
    }

    public Invitation organizationUserUuid(String organizationUserUuid) {
        this.organizationUserUuid = organizationUserUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the organization user accepted the invitation")
    public String getOrganizationUserUuid() {
        return this.organizationUserUuid;
    }

    public void setOrganizationUserUuid(String organizationUserUuid) {
        this.organizationUserUuid = organizationUserUuid;
    }

    public Invitation organizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="organization_name", value="Name of the organization, does not persist in database")
    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Invitation organizationRole(OrganizationRoles organizationRole) {
        this.organizationRole = organizationRole;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrganizationRoles getOrganizationRole() {
        return this.organizationRole;
    }

    public void setOrganizationRole(OrganizationRoles organizationRole) {
        this.organizationRole = organizationRole;
    }

    public Invitation organizationUuid(String organizationUuid) {
        this.organizationUuid = organizationUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the organization whose user(s) accepted the invitation")
    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public void setOrganizationUuid(String organizationUuid) {
        this.organizationUuid = organizationUuid;
    }

    public Invitation arrayUuid(String arrayUuid) {
        this.arrayUuid = arrayUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the array")
    public String getArrayUuid() {
        return this.arrayUuid;
    }

    public void setArrayUuid(String arrayUuid) {
        this.arrayUuid = arrayUuid;
    }

    public Invitation groupUuid(String groupUuid) {
        this.groupUuid = groupUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the group")
    public String getGroupUuid() {
        return this.groupUuid;
    }

    public void setGroupUuid(String groupUuid) {
        this.groupUuid = groupUuid;
    }

    public Invitation arrayName(String arrayName) {
        this.arrayName = arrayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="array_name", value="Name of the array, does not persist in database")
    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public Invitation email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="jane@doe.com", value="Email of the individual we send the invitation to")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Invitation actions(String actions) {
        this.actions = actions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="read,write", value="A comma separated list of ArrayActions or NamespaceActions")
    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public Invitation groupActions(String groupActions) {
        this.groupActions = groupActions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="read,write", value="A comma separated list of GroupActions")
    public String getGroupActions() {
        return this.groupActions;
    }

    public void setGroupActions(String groupActions) {
        this.groupActions = groupActions;
    }

    public Invitation status(InvitationStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InvitationStatus getStatus() {
        return this.status;
    }

    public void setStatus(InvitationStatus status) {
        this.status = status;
    }

    public Invitation createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime the invitation was created in UTC")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Invitation expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime the invitation is expected to expire in UTC")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Invitation acceptedAt(OffsetDateTime acceptedAt) {
        this.acceptedAt = acceptedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime the invitation was accepted in UTC")
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    public void setAcceptedAt(OffsetDateTime acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    public Invitation namespaceInvited(String namespaceInvited) {
        this.namespaceInvited = namespaceInvited;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The namespace invited (user or organization, if it exists in the DB)")
    public String getNamespaceInvited() {
        return this.namespaceInvited;
    }

    public void setNamespaceInvited(String namespaceInvited) {
        this.namespaceInvited = namespaceInvited;
    }

    public Invitation putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invitation invitation = (Invitation)o;
        return Objects.equals(this.id, invitation.id) && Objects.equals((Object)this.invitationType, (Object)invitation.invitationType) && Objects.equals(this.ownerNamespaceUuid, invitation.ownerNamespaceUuid) && Objects.equals(this.inviterUuid, invitation.inviterUuid) && Objects.equals(this.userNamespaceUuid, invitation.userNamespaceUuid) && Objects.equals(this.organizationUserUuid, invitation.organizationUserUuid) && Objects.equals(this.organizationName, invitation.organizationName) && Objects.equals((Object)this.organizationRole, (Object)invitation.organizationRole) && Objects.equals(this.organizationUuid, invitation.organizationUuid) && Objects.equals(this.arrayUuid, invitation.arrayUuid) && Objects.equals(this.groupUuid, invitation.groupUuid) && Objects.equals(this.arrayName, invitation.arrayName) && Objects.equals(this.email, invitation.email) && Objects.equals(this.actions, invitation.actions) && Objects.equals(this.groupActions, invitation.groupActions) && Objects.equals((Object)this.status, (Object)invitation.status) && Objects.equals(this.createdAt, invitation.createdAt) && Objects.equals(this.expiresAt, invitation.expiresAt) && Objects.equals(this.acceptedAt, invitation.acceptedAt) && Objects.equals(this.namespaceInvited, invitation.namespaceInvited) && Objects.equals(this.additionalProperties, invitation.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.invitationType, this.ownerNamespaceUuid, this.inviterUuid, this.userNamespaceUuid, this.organizationUserUuid, this.organizationName, this.organizationRole, this.organizationUuid, this.arrayUuid, this.groupUuid, this.arrayName, this.email, this.actions, this.groupActions, this.status, this.createdAt, this.expiresAt, this.acceptedAt, this.namespaceInvited, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invitation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    invitationType: ").append(this.toIndentedString((Object)this.invitationType)).append("\n");
        sb.append("    ownerNamespaceUuid: ").append(this.toIndentedString(this.ownerNamespaceUuid)).append("\n");
        sb.append("    inviterUuid: ").append(this.toIndentedString(this.inviterUuid)).append("\n");
        sb.append("    userNamespaceUuid: ").append(this.toIndentedString(this.userNamespaceUuid)).append("\n");
        sb.append("    organizationUserUuid: ").append(this.toIndentedString(this.organizationUserUuid)).append("\n");
        sb.append("    organizationName: ").append(this.toIndentedString(this.organizationName)).append("\n");
        sb.append("    organizationRole: ").append(this.toIndentedString((Object)this.organizationRole)).append("\n");
        sb.append("    organizationUuid: ").append(this.toIndentedString(this.organizationUuid)).append("\n");
        sb.append("    arrayUuid: ").append(this.toIndentedString(this.arrayUuid)).append("\n");
        sb.append("    groupUuid: ").append(this.toIndentedString(this.groupUuid)).append("\n");
        sb.append("    arrayName: ").append(this.toIndentedString(this.arrayName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    groupActions: ").append(this.toIndentedString(this.groupActions)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    acceptedAt: ").append(this.toIndentedString(this.acceptedAt)).append("\n");
        sb.append("    namespaceInvited: ").append(this.toIndentedString(this.namespaceInvited)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Invitation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `owner_namespace_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVITER_UUID) != null && !jsonObj.get(SERIALIZED_NAME_INVITER_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVITER_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `inviter_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVITER_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_NAMESPACE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_USER_NAMESPACE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER_NAMESPACE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user_namespace_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_NAMESPACE_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORGANIZATION_USER_UUID) != null && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_USER_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_USER_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `organization_user_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATION_USER_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `organization_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORGANIZATION_UUID) != null && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `organization_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATION_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_UUID) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_UUID) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `actions` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_actions` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE_INVITED) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE_INVITED).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE_INVITED).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace_invited` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE_INVITED).toString()));
        }
    }

    public static Invitation fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Invitation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INVITATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_OWNER_NAMESPACE_UUID);
        openapiFields.add(SERIALIZED_NAME_INVITER_UUID);
        openapiFields.add(SERIALIZED_NAME_USER_NAMESPACE_UUID);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION_USER_UUID);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION_NAME);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION_ROLE);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION_UUID);
        openapiFields.add(SERIALIZED_NAME_ARRAY_UUID);
        openapiFields.add(SERIALIZED_NAME_GROUP_UUID);
        openapiFields.add(SERIALIZED_NAME_ARRAY_NAME);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_GROUP_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_ACCEPTED_AT);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE_INVITED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Invitation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Invitation> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Invitation.class));
            return new TypeAdapter<Invitation>(){

                @Override
                public void write(JsonWriter out, Invitation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Invitation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Invitation.validateJsonObject(jsonObj);
                    Invitation instance = (Invitation)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

